/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;

public class InstanceCache<K, T extends K> {
    private final Map<K, SoftReference<T>> cache = new WeakHashMap<K, SoftReference<T>>();

    public synchronized T getInstance(K key, IInstanceFactory<T> instanceFactory) {
        SoftReference<Object> objectReference = this.cache.get(key);
        Object instance = null;
        if (objectReference != null) {
            instance = objectReference.get();
        }
        if (instance == null) {
            instance = instanceFactory.createObject();
            assert (instance != null);
            assert (instance.equals(key));
            assert (key.equals(instance));
            objectReference = new SoftReference<Object>(instance);
            this.cache.put(instance, objectReference);
        }
        return (T)instance;
    }

    public void clear() {
        this.cache.clear();
    }

    public static interface IInstanceFactory<T> {
        public T createObject();
    }
}

