/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java;

import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class Assert {
    private static final ILogger logger = Logger.getLogger(Assert.class);

    public static boolean illegalType() {
        return Assert.throwRuntimeException(new ClassCastException());
    }

    public static boolean illegalType(String message) {
        return Assert.throwRuntimeException(new ClassCastException(message));
    }

    public static boolean illegalArgument() {
        return Assert.throwRuntimeException(new IllegalArgumentException());
    }

    public static boolean illegalArgument(String message) {
        return Assert.throwRuntimeException(new IllegalArgumentException(message));
    }

    public static boolean illegalState() {
        return Assert.throwRuntimeException(new IllegalStateException());
    }

    public static boolean illegalState(String message) {
        return Assert.throwRuntimeException(new IllegalStateException(message));
    }

    public static boolean unsupportedOperation() {
        return Assert.throwRuntimeException(new UnsupportedOperationException());
    }

    public static boolean unsupportedOperation(String message) {
        return Assert.throwRuntimeException(new UnsupportedOperationException(message));
    }

    public static boolean concurrentAccess() {
        return Assert.throwRuntimeException(new ConcurrentModificationException());
    }

    public static boolean concurrentAccess(String message) {
        return Assert.throwRuntimeException(new ConcurrentModificationException(message));
    }

    public static boolean checkArgumentBeeingNotNull(Object o) {
        return Assert.checkArgument(o != null);
    }

    public static boolean checkStringToContainNoInvalidCharacters(String stringToBeChecked, String allowedCharacters) {
        boolean stringIsOk = true;
        char[] charsToBeChecked = stringToBeChecked.toCharArray();
        int i = charsToBeChecked.length - 1;
        while (i >= 0) {
            if (allowedCharacters.indexOf(charsToBeChecked[i]) == -1) {
                stringIsOk = false;
                break;
            }
            --i;
        }
        return Assert.checkArgument(stringIsOk);
    }

    public static boolean checkStringToBeNotEmpty(String stringToBeChecked) {
        return Assert.checkArgument(stringToBeChecked.length() != 0);
    }

    public static boolean checkCollectionToBeNotEmpty(ICollection_ collectionToBeChecked) {
        return Assert.checkArgument(collectionToBeChecked.size() > 0);
    }

    public static boolean checkObjectArgumentToBeInstanceOf(Object o, Class t) {
        Assert.checkArgumentBeeingNotNull(o);
        Assert.checkArgumentBeeingNotNull(t);
        return Assert.checkArgument(t.isInstance(o));
    }

    public static boolean checkCollectionArgumentToContainACertainType(Collection c, Class t) {
        Assert.checkArgumentBeeingNotNull(c);
        Assert.checkArgumentBeeingNotNull(t);
        boolean isCollectionOk = true;
        Iterator i = c.iterator();
        while (isCollectionOk && i.hasNext()) {
            Object currentObject = i.next();
            if (t.isInstance(currentObject)) continue;
            isCollectionOk = false;
            Assert.illegalArgument();
        }
        return isCollectionOk;
    }

    public static boolean checkCollectionArgumentToContainACertainType(ICollection_<Object> c, Class t) {
        return Assert.checkCollectionArgumentToContainACertainType(c.asJavaCollection(), t);
    }

    public static boolean checkArgument(boolean isValueOk) {
        if (!isValueOk) {
            Assert.illegalArgument();
        }
        return isValueOk;
    }

    public static boolean checkState(boolean isValueOk) {
        if (!isValueOk) {
            Assert.illegalState();
        }
        return isValueOk;
    }

    public static boolean checkState(boolean isValueOk, String message) {
        Assert.checkArgumentBeeingNotNull(message);
        if (!isValueOk) {
            Assert.illegalState(message);
        }
        return isValueOk;
    }

    public static boolean checkOperationSupport(boolean isValueOk) {
        if (!isValueOk) {
            Assert.unsupportedOperation();
        }
        return isValueOk;
    }

    public static boolean checkOperationSupport(boolean isValueOk, String message) {
        if (!isValueOk) {
            Assert.unsupportedOperation(message);
        }
        return isValueOk;
    }

    public static boolean checkConcurrentAccess(boolean isValueOk) {
        if (!isValueOk) {
            Assert.concurrentAccess();
        }
        return isValueOk;
    }

    public static boolean checkArgument(boolean isValueOk, String message) {
        Assert.checkArgumentBeeingNotNull(message);
        if (!isValueOk) {
            Assert.illegalArgument(message);
        }
        return isValueOk;
    }

    public static boolean throwRuntimeException(RuntimeException e) {
        Assert.checkArgumentBeeingNotNull(e);
        logger.error("Assertion error", (Throwable)e);
        throw e;
    }

    private Assert() {
    }
}

