/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.io;

import java.io.File;
import java.util.Date;

public abstract class AbstractFileWatcher {
    private final File fileToCheck;
    private long lastModifiedInMinutes = 0L;
    private long lastModifiedTime = 0L;
    private long lastKnownSize = -1L;
    private boolean isChanged = false;

    public AbstractFileWatcher(File fileToCheck) {
        this.fileToCheck = fileToCheck;
        this.lastModifiedTime = fileToCheck.lastModified();
        this.lastKnownSize = fileToCheck.length();
    }

    public void check() {
        long newlastModifiedInMinutes;
        boolean runUpdate = false;
        long newLastModifiedTime = this.fileToCheck.lastModified();
        long newLastKnownSize = this.fileToCheck.length();
        if (this.lastModifiedTime != newLastModifiedTime || newLastKnownSize != this.lastKnownSize) {
            this.lastModifiedTime = newLastModifiedTime;
            this.lastKnownSize = newLastKnownSize;
            this.lastModifiedInMinutes = 0L;
            runUpdate = true;
            this.isChanged = true;
        }
        if (!runUpdate && this.lastModifiedInMinutes != (newlastModifiedInMinutes = (new Date().getTime() - this.lastModifiedTime) / 60000L)) {
            this.lastModifiedInMinutes = newlastModifiedInMinutes;
            runUpdate = true;
        }
        if (runUpdate) {
            this.update();
        }
    }

    public long getLastModifiedDifferenceInMinutes() {
        return this.lastModifiedInMinutes;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    protected abstract void update();
}

