/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.extensioning;

import com.arcway.lib.extensioning.ExtensionPoint;
import com.arcway.lib.extensioning.IConfigurationElement;
import com.arcway.lib.extensioning.IConfigurationElementAttributeString;
import com.arcway.lib.extensioning.IExtension;
import com.arcway.lib.extensioning.IPlugin;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;

public class IDExtensionPoint
extends ExtensionPoint {
    private static final ILogger logger = Logger.getLogger(IDExtensionPoint.class);
    private final ISet_<String> ids;

    protected IDExtensionPoint(IPlugin plugin, String extensionPointID, String configElementName, String attributeName) {
        super(plugin, extensionPointID);
        Assert.checkArgumentBeeingNotNull(configElementName);
        Assert.checkArgumentBeeingNotNull(attributeName);
        this.ids = this.createRegisteredIDs(configElementName, attributeName);
    }

    private ISet_<String> createRegisteredIDs(String configElementName, String attributeName) {
        HashSet_<Object> loadedExtensionInstances = new HashSet_<Object>(IHasher_.EQUALS_HASHER);
        Collection extensions = this.getExtensions();
        for (IExtension currentExtension : extensions) {
            Collection configurationElements = currentExtension.getConfigurationElements(configElementName);
            for (IConfigurationElement currentConfigurationElement : configurationElements) {
                IConfigurationElementAttributeString idAttribute = currentConfigurationElement.getAttributeAsString(attributeName);
                String id = idAttribute.getRawString();
                if (id != null) {
                    if (id.length() != 0) {
                        loadedExtensionInstances.add(id);
                        continue;
                    }
                    logger.error("Error while reading extension for extension point " + To.makeNotNull((Object)this.getExtensionPointID()) + ": id " + configElementName + "/" + attributeName + " is empty");
                    continue;
                }
                logger.error("Error while reading extension for extension point " + To.makeNotNull((Object)this.getExtensionPointID()) + ": id " + configElementName + "/" + attributeName + " is null");
            }
        }
        return loadedExtensionInstances;
    }

    public ISet_<String> getIDs() {
        return this.ids;
    }
}

