/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.xml;

import com.arcway.lib.codec.xml.EXXMLDecodingFailed;
import com.arcway.lib.codec.xml.EXXMLEncodingFailed;
import com.arcway.lib.codec.xml.IXMLCharactersRO;
import com.arcway.lib.codec.xml.IXMLDecodingHandler;
import com.arcway.lib.codec.xml.IXMLElementRO;
import com.arcway.lib.codec.xml.IXMLItemRO;
import com.arcway.lib.codec.xml.IXMLProcessingInstructionRO;
import com.arcway.lib.codec.xml.IXMLRootElementFactoryWO;
import com.arcway.lib.codec.xml.IXMLRootElementRO;
import com.arcway.lib.codec.xml.SaxParsingHandler;
import com.arcway.lib.codec.xml.XMLAttribute;
import com.arcway.lib.codec.xml.XMLAttributeName;
import com.arcway.lib.codec.xml.XMLAttributeValue;
import com.arcway.lib.codec.xml.XMLElementName;
import com.arcway.lib.codec.xml.XMLFormatMode;
import com.arcway.lib.codec.xml.XMLProcessingInstruction;
import com.arcway.lib.codec.xml.XMLStackDecodingHandler;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.New;
import com.arcway.lib.java.collections.IList_;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLCoDec {
    public static final String ENCODING_UTF_8 = "UTF-8";
    public static final String ENCODING_UTF_16 = "UTF-16";
    public static final Set<String> VALID_ENCODINGS;
    private static final SAXParserFactory SAX_PARSER_FACTORY;

    static {
        HashSet<int> validEncodings = New.hashSet(2);
        validEncodings.add((int)ENCODING_UTF_8);
        validEncodings.add((int)ENCODING_UTF_16);
        VALID_ENCODINGS = Collections.unmodifiableSet(validEncodings);
        SAX_PARSER_FACTORY = SAXParserFactory.newInstance();
        SAX_PARSER_FACTORY.setNamespaceAware(true);
    }

    private XMLCoDec() {
    }

    public static void decode(InputStream inp, IXMLRootElementFactoryWO xmlRootElementFactory, boolean disableNamespacesFeature) throws EXXMLDecodingFailed {
        Assert.checkArgumentBeeingNotNull(inp);
        Assert.checkArgumentBeeingNotNull(xmlRootElementFactory);
        XMLCoDec.decode(inp, new XMLStackDecodingHandler(xmlRootElementFactory), disableNamespacesFeature);
    }

    public static void decode(InputStream inp, IXMLDecodingHandler xmlDecoder, boolean disableNamespacesFeature) throws EXXMLDecodingFailed {
        Assert.checkArgumentBeeingNotNull(inp);
        Assert.checkArgumentBeeingNotNull(xmlDecoder);
        SAXParser saxParser = XMLCoDec.createSAXParser();
        if (disableNamespacesFeature) {
            try {
                saxParser.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", false);
            }
            catch (SAXNotRecognizedException e1) {
                throw new RuntimeException(e1);
            }
            catch (SAXNotSupportedException e1) {
                throw new RuntimeException(e1);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
        SaxParsingHandler saxParsingHandler = new SaxParsingHandler(xmlDecoder);
        try {
            saxParser.parse(inp, (DefaultHandler)saxParsingHandler);
        }
        catch (IOException e) {
            throw new EXXMLDecodingFailed(e);
        }
        catch (SAXException e) {
            throw XMLCoDec.unwrapSAXException(e);
        }
    }

    private static SAXParser createSAXParser() throws EXXMLDecodingFailed {
        SAXParser saxParser;
        try {
            saxParser = SAX_PARSER_FACTORY.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new EXXMLDecodingFailed(e);
        }
        catch (SAXException e) {
            throw XMLCoDec.unwrapSAXException(e);
        }
        return saxParser;
    }

    private static EXXMLDecodingFailed unwrapSAXException(SAXException e) {
        Assert.checkArgumentBeeingNotNull(e);
        Throwable cause = e.getException() != null ? e.getException() : e;
        while (cause instanceof EXXMLDecodingFailed && ((Throwable)cause).getCause() != cause && ((Throwable)cause).getCause() != null) {
            cause = ((Throwable)cause).getCause();
        }
        EXXMLDecodingFailed decodingFailedException = cause instanceof EXXMLDecodingFailed ? (EXXMLDecodingFailed)cause : new EXXMLDecodingFailed(cause);
        return decodingFailedException;
    }

    public static void encodeIntoOutputStream(OutputStream out, String encoding, IXMLRootElementRO rootElement, XMLFormatMode formatOutput) throws EXXMLEncodingFailed {
        Assert.checkArgumentBeeingNotNull(out);
        Assert.checkArgumentBeeingNotNull(rootElement);
        OutputStreamXMLOutputStream outp = new OutputStreamXMLOutputStream(out, encoding, formatOutput);
        XMLCoDec.encode(outp, rootElement);
    }

    public static String encodeIntoString(String encoding, IXMLRootElementRO rootElement, XMLFormatMode formatOutput) throws EXXMLEncodingFailed {
        Assert.checkArgumentBeeingNotNull(rootElement);
        StringArrayXMLOutputStream outp = new StringArrayXMLOutputStream(encoding, formatOutput);
        XMLCoDec.encode(outp, rootElement);
        return outp.getOutputStreamContentsAsString();
    }

    private static void encode(XMLOutputStream outp, IXMLRootElementRO rootElement) throws EXXMLEncodingFailed {
        Assert.checkArgumentBeeingNotNull(outp);
        Assert.checkArgumentBeeingNotNull(rootElement);
        IList_<XMLProcessingInstruction> rootProcessingInstructions = rootElement.getRootProcessingInstructions();
        outp.open(rootProcessingInstructions);
        outp.encodeItem(rootElement, null);
        outp.close();
    }

    private static final class OutputStreamXMLOutputStream
    extends XMLOutputStream {
        private final OutputStreamWriter outputStreamWriter;

        public OutputStreamXMLOutputStream(OutputStream outputStream, String encoding, XMLFormatMode formatOutput) throws EXXMLEncodingFailed {
            super(encoding, formatOutput);
            Assert.checkArgumentBeeingNotNull(outputStream);
            try {
                this.outputStreamWriter = new OutputStreamWriter(outputStream, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new EXXMLEncodingFailed(e);
            }
        }

        @Override
        protected void openOutputStream() throws EXXMLEncodingFailed {
        }

        @Override
        protected void writeStringToStream(String string) throws EXXMLEncodingFailed {
            try {
                this.outputStreamWriter.write(string);
            }
            catch (IOException e) {
                throw new EXXMLEncodingFailed(e);
            }
        }

        @Override
        protected void closeOutputStream() throws EXXMLEncodingFailed {
            try {
                IOException flushIoEx = null;
                try {
                    this.outputStreamWriter.flush();
                }
                catch (IOException ioex) {
                    flushIoEx = ioex;
                }
                this.outputStreamWriter.close();
                if (flushIoEx != null) {
                    throw flushIoEx;
                }
            }
            catch (IOException e) {
                throw new EXXMLEncodingFailed(e);
            }
        }
    }

    private static final class StringArrayXMLOutputStream
    extends XMLOutputStream {
        private String[] strings = new String[500];
        private int nextWritePos = 0;
        private int cummulatedResultLength = 0;

        public StringArrayXMLOutputStream(String encoding, XMLFormatMode formatOutput) {
            super(encoding, formatOutput);
        }

        public String getOutputStreamContentsAsString() {
            char[] result = new char[this.cummulatedResultLength];
            int resultWritePos = 0;
            int pos = 0;
            while (pos < this.nextWritePos) {
                String s = this.strings[pos];
                int slength = s.length();
                s.getChars(0, slength, result, resultWritePos);
                resultWritePos += slength;
                ++pos;
            }
            return new String(result);
        }

        @Override
        protected void openOutputStream() throws EXXMLEncodingFailed {
        }

        @Override
        protected void writeStringToStream(String string) throws EXXMLEncodingFailed {
            int stringsLength = this.strings.length;
            if (this.nextWritePos == stringsLength) {
                String[] moreStrings = new String[stringsLength * 2];
                System.arraycopy(this.strings, 0, moreStrings, 0, stringsLength);
                this.strings = moreStrings;
            }
            this.strings[this.nextWritePos] = string;
            this.cummulatedResultLength += string.length();
            ++this.nextWritePos;
        }

        @Override
        protected void closeOutputStream() throws EXXMLEncodingFailed {
        }
    }

    private static abstract class XMLOutputStream {
        private final String encoding;
        private int depth;
        private final boolean escapeCRLFTAB;

        public XMLOutputStream(String encoding, XMLFormatMode formatOutput) {
            Assert.checkArgumentBeeingNotNull(encoding);
            Assert.checkArgument(VALID_ENCODINGS.contains(encoding));
            this.encoding = encoding;
            this.depth = formatOutput == XMLFormatMode.WITH_INDENTION ? 0 : -1;
            this.escapeCRLFTAB = formatOutput == XMLFormatMode.WITHOUT_INDENTION || formatOutput == XMLFormatMode.WITH_INDENTION;
        }

        public final void open(IList_<XMLProcessingInstruction> rootProcessingInstructions) throws EXXMLEncodingFailed {
            this.openOutputStream();
            this.writeStringToStream("<?xml version=\"1.0\" encoding=\"");
            this.writeStringToStream(this.encoding);
            this.writeStringToStream("\"?>");
            this.writeNewLine();
            for (XMLProcessingInstruction rootProcessingInstruction : rootProcessingInstructions) {
                this.encodeProcessingInstruction(rootProcessingInstruction);
            }
        }

        private final void encodeItems(IList_<IXMLItemRO> itemList, String activeNameSpace) throws EXXMLEncodingFailed {
            Assert.checkArgumentBeeingNotNull(itemList);
            for (IXMLItemRO xmlItem : itemList) {
                this.encodeItem(xmlItem, activeNameSpace);
            }
        }

        public final void encodeItem(IXMLItemRO xmlItem, String activeNameSpace) throws EXXMLEncodingFailed {
            Assert.checkArgumentBeeingNotNull(xmlItem);
            if (xmlItem instanceof IXMLElementRO) {
                IXMLElementRO xmlElement = (IXMLElementRO)xmlItem;
                this.encodeElement(xmlElement, activeNameSpace);
            }
            if (xmlItem instanceof IXMLCharactersRO) {
                IXMLCharactersRO xmlCharacters = (IXMLCharactersRO)xmlItem;
                this.encodeCharacters(xmlCharacters);
            }
            if (xmlItem instanceof XMLProcessingInstruction) {
                IXMLProcessingInstructionRO xmlProcessingInstruction = (IXMLProcessingInstructionRO)xmlItem;
                this.encodeProcessingInstruction(xmlProcessingInstruction);
            }
        }

        private final void encodeElement(IXMLElementRO xmlElement, String activeNameSpace) throws EXXMLEncodingFailed {
            Assert.checkArgumentBeeingNotNull(xmlElement);
            IList_<IXMLItemRO> childItems = xmlElement.getChildItems();
            if (childItems.size() == 0) {
                this.encodeEmptyElementTag(xmlElement.getElementName(), activeNameSpace, xmlElement.getAttributes());
            } else {
                boolean format = XMLOutputStream.hasChildElementsOrProcessingInstructions(childItems);
                this.encodeElementStart(xmlElement.getElementName(), activeNameSpace, xmlElement.getAttributes(), format);
                int oldDepth = this.nextDepth(format);
                String newNameSpace = xmlElement.getElementName().getNameSpace();
                if (newNameSpace == null) {
                    newNameSpace = activeNameSpace;
                }
                this.encodeItems(childItems, newNameSpace);
                this.prevDepth(oldDepth);
                this.encodeElementEnd(xmlElement.getElementName(), format);
            }
        }

        private int nextDepth(boolean format) {
            int oldDepth = this.depth;
            if (format) {
                if (this.depth >= 0) {
                    ++this.depth;
                }
            } else {
                this.depth = -1;
            }
            return oldDepth;
        }

        private void prevDepth(int oldDepth) {
            this.depth = oldDepth;
        }

        private static boolean hasChildElementsOrProcessingInstructions(IList_<IXMLItemRO> childItems) {
            boolean hasChildElementsOrProcessingInstructions = false;
            Iterator i = childItems.iterator();
            while (!hasChildElementsOrProcessingInstructions && i.hasNext()) {
                IXMLItemRO childItem = (IXMLItemRO)i.next();
                if (!(childItem instanceof IXMLElementRO) && !(childItem instanceof IXMLProcessingInstructionRO)) continue;
                hasChildElementsOrProcessingInstructions = true;
            }
            return hasChildElementsOrProcessingInstructions;
        }

        private final void encodeEmptyElementTag(XMLElementName elementName, String activeNameSpace, IList_<XMLAttribute> attributes) throws EXXMLEncodingFailed {
            Assert.checkArgumentBeeingNotNull(elementName);
            Assert.checkArgumentBeeingNotNull(attributes);
            this.writeStartTagOpen(elementName, activeNameSpace);
            this.writeAttributes(attributes);
            this.writeStartTagClose(true, true);
        }

        private final void encodeElementStart(XMLElementName elementName, String activeNameSpace, IList_<XMLAttribute> attributes, boolean format) throws EXXMLEncodingFailed {
            Assert.checkArgumentBeeingNotNull(elementName);
            Assert.checkArgumentBeeingNotNull(attributes);
            this.writeStartTagOpen(elementName, activeNameSpace);
            this.writeAttributes(attributes);
            this.writeStartTagClose(false, format);
        }

        private final void encodeCharacters(IXMLCharactersRO xmlCharacters) throws EXXMLEncodingFailed {
            Assert.checkArgumentBeeingNotNull(xmlCharacters);
            this.writeEscaped(xmlCharacters.getCharacters());
        }

        private final void encodeProcessingInstruction(IXMLProcessingInstructionRO processingInstruction) throws EXXMLEncodingFailed {
            Assert.checkArgumentBeeingNotNull(processingInstruction);
            this.encodeProcessingInstruction(processingInstruction.getProcessingInstruction());
        }

        private final void encodeProcessingInstruction(XMLProcessingInstruction processingInstruction) throws EXXMLEncodingFailed {
            Assert.checkArgumentBeeingNotNull(processingInstruction);
            String target = processingInstruction.getTarget();
            String data = processingInstruction.getData();
            Assert.checkArgumentBeeingNotNull(target);
            this.writeIndent();
            this.writeStringToStream("<?");
            this.writeStringToStream(target);
            if (data != null && data.length() > 0) {
                this.writeStringToStream(" ");
                this.writeStringToStream(data);
            }
            this.writeStringToStream("?>");
            this.writeNewLine();
        }

        private final void encodeElementEnd(XMLElementName elementName, boolean format) throws EXXMLEncodingFailed {
            Assert.checkArgumentBeeingNotNull(elementName);
            this.writeEndTag(elementName, format);
        }

        public final void close() throws EXXMLEncodingFailed {
            this.closeOutputStream();
        }

        private void writeStartTagOpen(XMLElementName elementName, String activeNameSpace) throws EXXMLEncodingFailed {
            Assert.checkArgumentBeeingNotNull(elementName);
            this.writeIndent();
            this.writeStringToStream("<");
            this.writeStringToStream(elementName.getElementName());
            String newNameSpace = elementName.getNameSpace();
            if (newNameSpace != null && newNameSpace.length() > 0 && !newNameSpace.equals(activeNameSpace)) {
                this.writeAttribute("xmlns", newNameSpace);
            }
        }

        private void writeAttributes(IList_<XMLAttribute> attributes) throws EXXMLEncodingFailed {
            Assert.checkArgumentBeeingNotNull(attributes);
            for (XMLAttribute attribute : attributes) {
                this.writeAttribute(attribute);
            }
        }

        private void writeAttribute(XMLAttribute attribute) throws EXXMLEncodingFailed {
            this.writeAttribute(attribute.getAttributeName(), attribute.getAttributeValue());
        }

        private void writeAttribute(XMLAttributeName attributeName, XMLAttributeValue attributeValue) throws EXXMLEncodingFailed {
            this.writeAttribute(attributeName.getAttributeName(), attributeValue.getRawStringValue());
        }

        private void writeAttribute(String attributeName, String attributeRawValue) throws EXXMLEncodingFailed {
            this.writeStringToStream(" ");
            this.writeStringToStream(attributeName);
            this.writeStringToStream("=\"");
            this.writeEscaped(attributeRawValue);
            this.writeStringToStream("\"");
        }

        private void writeStartTagClose(boolean closeElement, boolean format) throws EXXMLEncodingFailed {
            if (closeElement) {
                this.writeStringToStream("/");
            }
            this.writeStringToStream(">");
            if (format) {
                this.writeNewLine();
            }
        }

        private void writeEndTag(XMLElementName elementName, boolean format) throws EXXMLEncodingFailed {
            Assert.checkArgumentBeeingNotNull(elementName);
            if (format) {
                this.writeIndent();
            }
            this.writeStringToStream("</");
            this.writeStringToStream(elementName.getElementName());
            this.writeStringToStream(">");
            this.writeNewLine();
        }

        private void writeIndent() throws EXXMLEncodingFailed {
            int i = 0;
            while (i < this.depth) {
                this.writeStringToStream("\t");
                ++i;
            }
        }

        private void writeNewLine() throws EXXMLEncodingFailed {
            if (this.depth >= 0) {
                this.writeStringToStream("\n");
            }
        }

        private void writeEscaped(String string) throws EXXMLEncodingFailed {
            this.writeStringToStream(XMLOutputStream.escapeCharacters(string, this.escapeCRLFTAB));
        }

        private static String escapeCharacters(String s, boolean escapeCRLFTAB) {
            StringBuilder result = null;
            int i = 0;
            int max = s.length();
            int delta = 0;
            while (i < max) {
                char c = s.charAt(i);
                String replacement = null;
                if (c == '&') {
                    replacement = "&amp;";
                } else if (c == '<') {
                    replacement = "&lt;";
                } else if (c == '>') {
                    replacement = "&gt;";
                } else if (c == '\"') {
                    replacement = "&quot;";
                } else if (c == '\'') {
                    replacement = "&apos;";
                } else if ((c != '\t' && c != '\n' && c != '\r' || escapeCRLFTAB) && c < ' ') {
                    replacement = "&#" + Integer.toString(c) + ";";
                }
                if (replacement != null) {
                    if (result == null) {
                        result = new StringBuilder(s);
                    }
                    result.replace(i + delta, i + delta + 1, replacement);
                    delta += replacement.length() - 1;
                }
                ++i;
            }
            if (result == null) {
                return s;
            }
            return result.toString();
        }

        protected abstract void openOutputStream() throws EXXMLEncodingFailed;

        protected abstract void writeStringToStream(String var1) throws EXXMLEncodingFailed;

        protected abstract void closeOutputStream() throws EXXMLEncodingFailed;
    }
}

