/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.xml;

import com.arcway.lib.codec.data.EXDataAssemblingFailed;
import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.EXDataLoadingException;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.codec.data.IStructuredDataFactory;
import com.arcway.lib.codec.data.IStructuredDataType;
import com.arcway.lib.codec.data.Key;
import com.arcway.lib.codec.data.SubDataType;
import com.arcway.lib.codec.xml.DTXMLCharacters;
import com.arcway.lib.codec.xml.DTXMLElement;
import com.arcway.lib.codec.xml.DTXMLProcessingInstructionItem;
import com.arcway.lib.codec.xml.IXMLCharactersRO;
import com.arcway.lib.codec.xml.IXMLElementRO;
import com.arcway.lib.codec.xml.IXMLItemRO;
import com.arcway.lib.codec.xml.IXMLProcessingInstructionRO;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IList_;

public class DTXMLItem
implements IStructuredDataType {
    public static final IKey ROLE_CHILD_ELEMENT = Key.getCanonicalKeyInstance("childElement");
    public static final IKey ROLE_CHARACTERS = Key.getCanonicalKeyInstance("characters");
    public static final IKey ROLE_PROCESSING_INSTRUCTION = Key.getCanonicalKeyInstance("processingInstruction");
    private static DTXMLItem SINGELTON;

    public static synchronized DTXMLItem getInstance() {
        if (SINGELTON == null) {
            SINGELTON = new DTXMLItem();
        }
        return SINGELTON;
    }

    private DTXMLItem() {
    }

    @Override
    public Class<? extends IDataType> getStructureType() {
        return IStructuredDataType.class;
    }

    @Override
    public IDataType getConcreteDataType() {
        return this;
    }

    @Override
    public boolean isNull(Object data) {
        return data == null;
    }

    @Override
    public Object createNullDataElement() throws EXDataCreationFailed {
        return null;
    }

    @Override
    public IList_<IKey> getFlagAndPropertyAndChildRoles(Object data) {
        IXMLItemRO typedData = (IXMLItemRO)data;
        ArrayList_<boolean> roles = new ArrayList_<boolean>(true);
        if (typedData instanceof IXMLElementRO) {
            roles.add((boolean)ROLE_CHILD_ELEMENT);
        } else if (typedData instanceof IXMLCharactersRO) {
            roles.add((boolean)ROLE_CHARACTERS);
        } else if (typedData instanceof IXMLProcessingInstructionRO) {
            roles.add((boolean)ROLE_PROCESSING_INSTRUCTION);
        } else {
            throw new IllegalArgumentException();
        }
        return roles;
    }

    @Override
    public SubDataType getSubDataType(IKey role) {
        return SubDataType.IS_PROPERTY;
    }

    @Override
    public boolean isSet(Object data, IKey role) {
        throw new IllegalArgumentException();
    }

    @Override
    public IDataType getDataTypeOfPropertyOrChildren(Object data, IKey role) {
        return DTXMLItem.getDataTypeOfPropertyOrChildren(role);
    }

    private static IDataType getDataTypeOfPropertyOrChildren(IKey role) {
        IDataType dataTypeOfPropertyOrChildren;
        if (IKey.IS_EQUAL_IKEY_HASHER.isEqual(role, ROLE_CHILD_ELEMENT)) {
            dataTypeOfPropertyOrChildren = DTXMLElement.getInstance();
        } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual(role, ROLE_CHARACTERS)) {
            dataTypeOfPropertyOrChildren = DTXMLCharacters.getInstance();
        } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual(role, ROLE_PROCESSING_INSTRUCTION)) {
            dataTypeOfPropertyOrChildren = DTXMLProcessingInstructionItem.getInstance();
        } else {
            throw new IllegalArgumentException();
        }
        return dataTypeOfPropertyOrChildren;
    }

    @Override
    public Object getProperty(Object data, IKey role) {
        return data;
    }

    @Override
    public IList_<? extends Object> getChildren(Object data, IKey role) {
        throw new IllegalArgumentException();
    }

    @Override
    public IStructuredDataFactory createDataFactory() {
        return new IStructuredDataFactory(){
            private IXMLItemRO xmlItem;

            @Override
            public void setFlag(IKey role) {
                throw new IllegalArgumentException();
            }

            @Override
            public IDataType getDataTypeOfPropertyOrChildren(IKey role) {
                return DTXMLItem.getDataTypeOfPropertyOrChildren(role);
            }

            @Override
            public void addPropertyOrChild(IKey role, Object propertyOrChild) throws EXDataAssemblingFailed {
                this.xmlItem = (IXMLItemRO)propertyOrChild;
            }

            @Override
            public boolean isErroneousFlagOrPropertyOrChildToIgnore(IKey role, EXDataLoadingException exception) {
                return false;
            }

            @Override
            public Object createDataElement() throws EXDataCreationFailed {
                return this.xmlItem;
            }
        };
    }
}

