/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.xml;

import com.arcway.lib.codec.data.EXDataAssemblingFailed;
import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.EXDataLoadingException;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.codec.data.IStructuredDataFactory;
import com.arcway.lib.codec.data.IStructuredDataType;
import com.arcway.lib.codec.data.Key;
import com.arcway.lib.codec.data.SubDataType;
import com.arcway.lib.codec.data.lib.DTString;
import com.arcway.lib.codec.xml.DTXMLItem;
import com.arcway.lib.codec.xml.IXMLElementRO;
import com.arcway.lib.codec.xml.IXMLItemRO;
import com.arcway.lib.codec.xml.XMLAttribute;
import com.arcway.lib.codec.xml.XMLAttributeName;
import com.arcway.lib.codec.xml.XMLAttributeValue;
import com.arcway.lib.codec.xml.XMLElement;
import com.arcway.lib.codec.xml.XMLElementName;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.lib.java.collections.IList_;

public class DTXMLElement
implements IStructuredDataType {
    public static final IKey ROLE_ELEMENT_NAME = Key.getCanonicalKeyInstance("elementName");
    public static final IKey ROLE_NAMESPACE = Key.getCanonicalKeyInstance("namespace");
    public static final String ATTRIBUTE_KEY_PREFIX = "attribute" + IKey.KEY_SPERARTOR;
    public static final IKey ROLE_CONTENT = Key.getCanonicalKeyInstance("content");
    private static final IDataType DATA_TYPE_ELEMENT_NAME = DTString.getInstance();
    private static final IDataType DATA_TYPE_NAMESPACE = DTString.getInstance();
    private static final IDataType DATA_TYPE_ATTRIBUTE = DTString.getInstance();
    private static final IDataType DATA_TYPE_CONTENT = DTXMLItem.getInstance();
    private static DTXMLElement SINGELTON;

    public static synchronized DTXMLElement getInstance() {
        if (SINGELTON == null) {
            SINGELTON = new DTXMLElement();
        }
        return SINGELTON;
    }

    protected DTXMLElement() {
    }

    @Override
    public Class<? extends IDataType> getStructureType() {
        return IStructuredDataType.class;
    }

    @Override
    public IDataType getConcreteDataType() {
        return this;
    }

    @Override
    public boolean isNull(Object data) {
        return data == null;
    }

    @Override
    public Object createNullDataElement() throws EXDataCreationFailed {
        return null;
    }

    @Override
    public IList_<IKey> getFlagAndPropertyAndChildRoles(Object data) {
        String nameSpace;
        IXMLElementRO typedData = (IXMLElementRO)data;
        ArrayList_<IKey> keys = new ArrayList_<IKey>();
        XMLElementName xmlElementName = typedData.getElementName();
        String elementName = xmlElementName.getElementName();
        if (elementName != null && elementName.length() > 0) {
            keys.add(ROLE_ELEMENT_NAME);
        }
        if ((nameSpace = xmlElementName.getNameSpace()) != null && nameSpace.length() > 0) {
            keys.add(ROLE_NAMESPACE);
        }
        for (XMLAttribute xmlAttribute : typedData.getAttributes()) {
            XMLAttributeName xmlAttributeName = xmlAttribute.getAttributeName();
            String attributeName = xmlAttributeName.getAttributeName();
            String attributeKey = String.valueOf(ATTRIBUTE_KEY_PREFIX) + attributeName;
            Key attributeRole = Key.getCanonicalKeyInstance(attributeKey);
            keys.add(attributeRole);
        }
        if (!typedData.getChildItems().isEmpty()) {
            keys.add(ROLE_CONTENT);
        }
        return keys;
    }

    @Override
    public SubDataType getSubDataType(IKey role) {
        SubDataType subDataType;
        if (IKey.IS_EQUAL_IKEY_HASHER.isEqual(role, ROLE_ELEMENT_NAME)) {
            subDataType = SubDataType.IS_PROPERTY;
        } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual(role, ROLE_NAMESPACE)) {
            subDataType = SubDataType.IS_PROPERTY;
        } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual(role, ROLE_CONTENT)) {
            subDataType = SubDataType.IS_CHILD;
        } else {
            String keyWithPrefix = role.toCanonicalString();
            if (keyWithPrefix.startsWith(ATTRIBUTE_KEY_PREFIX)) {
                subDataType = SubDataType.IS_PROPERTY;
            } else {
                throw new IllegalArgumentException();
            }
        }
        return subDataType;
    }

    @Override
    public boolean isSet(Object data, IKey role) {
        throw new IllegalArgumentException();
    }

    @Override
    public IDataType getDataTypeOfPropertyOrChildren(Object data, IKey role) {
        return DTXMLElement.getDataTypeOfPropertyOrChildren(role);
    }

    private static IDataType getDataTypeOfPropertyOrChildren(IKey role) {
        IDataType dataTypeOfPropertyOrChildren;
        if (IKey.IS_EQUAL_IKEY_HASHER.isEqual(role, ROLE_ELEMENT_NAME)) {
            dataTypeOfPropertyOrChildren = DATA_TYPE_ELEMENT_NAME;
        } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual(role, ROLE_NAMESPACE)) {
            dataTypeOfPropertyOrChildren = DATA_TYPE_NAMESPACE;
        } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual(role, ROLE_CONTENT)) {
            dataTypeOfPropertyOrChildren = DATA_TYPE_CONTENT;
        } else if (role.toCanonicalString().startsWith(ATTRIBUTE_KEY_PREFIX)) {
            dataTypeOfPropertyOrChildren = DATA_TYPE_ATTRIBUTE;
        } else {
            throw new IllegalArgumentException();
        }
        return dataTypeOfPropertyOrChildren;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getProperty(Object data, IKey role) {
        IXMLElementRO typedData = (IXMLElementRO)data;
        if (IKey.IS_EQUAL_IKEY_HASHER.isEqual(role, ROLE_ELEMENT_NAME)) {
            return typedData.getElementName().getElementName();
        }
        if (IKey.IS_EQUAL_IKEY_HASHER.isEqual(role, ROLE_NAMESPACE)) {
            return typedData.getElementName().getNameSpace();
        }
        String keyWithPrefix = role.toCanonicalString();
        if (!keyWithPrefix.startsWith(ATTRIBUTE_KEY_PREFIX)) throw new IllegalArgumentException();
        String key = keyWithPrefix.substring(ATTRIBUTE_KEY_PREFIX.length());
        XMLAttributeName xmlAttributeName = new XMLAttributeName(key);
        IList_<XMLAttribute> xmlAttributes = typedData.getAttributes();
        XMLAttributeValue xmlAttributeValue = XMLAttribute.findValueByAtributeName(xmlAttributes, xmlAttributeName);
        if (xmlAttributeValue == null) throw new IllegalArgumentException();
        String value = xmlAttributeValue.getRawStringValue();
        return value;
    }

    @Override
    public IList_<? extends Object> getChildren(Object data, IKey role) {
        IXMLElementRO typedData = (IXMLElementRO)data;
        if (!IKey.IS_EQUAL_IKEY_HASHER.isEqual(role, ROLE_CONTENT)) {
            throw new IllegalArgumentException();
        }
        IList_<IXMLItemRO> children = typedData.getChildItems();
        return children;
    }

    @Override
    public IStructuredDataFactory createDataFactory() {
        return new IStructuredDataFactory(){
            private String elementName;
            private String nameSpace = null;
            private final IListRW_<XMLAttribute> attributes = new ArrayList_<XMLAttribute>();
            private final IListRW_<IXMLItemRO> childItems = new ArrayList_<IXMLItemRO>();

            @Override
            public void setFlag(IKey role) {
                throw new IllegalArgumentException();
            }

            @Override
            public IDataType getDataTypeOfPropertyOrChildren(IKey role) {
                return DTXMLElement.getDataTypeOfPropertyOrChildren(role);
            }

            @Override
            public void addPropertyOrChild(IKey role, Object propertyOrChild) throws EXDataAssemblingFailed {
                if (IKey.IS_EQUAL_IKEY_HASHER.isEqual(role, ROLE_ELEMENT_NAME)) {
                    this.elementName = (String)propertyOrChild;
                } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual(role, ROLE_NAMESPACE)) {
                    this.nameSpace = (String)propertyOrChild;
                } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual(role, ROLE_CONTENT)) {
                    this.childItems.add((IXMLItemRO)propertyOrChild);
                } else {
                    String keyWithPrefix = role.toCanonicalString();
                    if (keyWithPrefix.startsWith(ATTRIBUTE_KEY_PREFIX)) {
                        String key = keyWithPrefix.substring(ATTRIBUTE_KEY_PREFIX.length());
                        String value = (String)propertyOrChild;
                        XMLAttributeName xmlAttributeName = new XMLAttributeName(key);
                        XMLAttributeValue xmlAttributeValue = new XMLAttributeValue(value);
                        XMLAttribute xmlAttribute = new XMLAttribute(xmlAttributeName, xmlAttributeValue);
                        this.attributes.add(xmlAttribute);
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
            }

            @Override
            public boolean isErroneousFlagOrPropertyOrChildToIgnore(IKey role, EXDataLoadingException exception) {
                return false;
            }

            @Override
            public Object createDataElement() throws EXDataCreationFailed {
                XMLElementName xmlElementName = new XMLElementName(this.nameSpace, this.elementName);
                XMLElement xmlElement = new XMLElement(xmlElementName, this.attributes, this.childItems);
                return xmlElement;
            }
        };
    }
}

