/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.data.lib;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.lib.generic.AbstractElementaryDataType;
import java.text.ParseException;

public abstract class DTBoolean
extends AbstractElementaryDataType {
    private static final String STRING_REPRESENTATION_FALSE = "false";
    private static final String STRING_REPRESENTATION_TRUE = "true";
    private static DTBoolean SINGELTON;

    public static synchronized DTBoolean getInstance() {
        if (SINGELTON == null) {
            SINGELTON = new DTBoolean(){

                @Override
                protected Boolean convertDataToTypedData(Object data) {
                    return (Boolean)data;
                }

                @Override
                protected Object convertTypedDataToData(Boolean typedData) throws EXDataCreationFailed {
                    return typedData;
                }
            };
        }
        return SINGELTON;
    }

    protected DTBoolean() {
    }

    protected abstract Boolean convertDataToTypedData(Object var1);

    protected abstract Object convertTypedDataToData(Boolean var1) throws EXDataCreationFailed;

    @Override
    public boolean isNull(Object data) {
        Boolean typedData = this.convertDataToTypedData(data);
        return typedData == null;
    }

    @Override
    public String getValueAsString(Object data) {
        Boolean typedData = this.convertDataToTypedData(data);
        String stringRepresentation = typedData == null ? null : (typedData != false ? STRING_REPRESENTATION_TRUE : STRING_REPRESENTATION_FALSE);
        return stringRepresentation;
    }

    @Override
    public Object createNullDataElement() throws EXDataCreationFailed {
        Boolean typedData = null;
        Object data = this.convertTypedDataToData(typedData);
        return data;
    }

    @Override
    protected Object createDataFromString(String string) throws EXDataCreationFailed {
        Boolean typedData;
        if (string.equalsIgnoreCase(STRING_REPRESENTATION_TRUE)) {
            typedData = Boolean.TRUE;
        } else if (string.equalsIgnoreCase(STRING_REPRESENTATION_FALSE)) {
            typedData = Boolean.FALSE;
        } else {
            throw new EXDataCreationFailed(new ParseException(string, 0));
        }
        Object data = this.convertTypedDataToData(typedData);
        return data;
    }
}

