/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.data.codecs.xml;

import com.arcway.lib.codec.data.EXDataLoadingException;
import com.arcway.lib.codec.data.EXDataLoadingExceptionWithCause;
import com.arcway.lib.codec.data.Key;
import com.arcway.lib.codec.data.codecs.generic.decoding.IDataLoader;
import com.arcway.lib.codec.data.codecs.xml.EXInvalidXMLAttribute;
import com.arcway.lib.codec.data.codecs.xml.XMLCoDecForData;
import com.arcway.lib.codec.xml.EXXMLDecodingFailed;
import com.arcway.lib.codec.xml.IXMLElementWO;
import com.arcway.lib.codec.xml.XMLAttribute;
import com.arcway.lib.codec.xml.XMLAttributeName;
import com.arcway.lib.codec.xml.XMLAttributeValue;
import com.arcway.lib.codec.xml.XMLElementName;
import com.arcway.lib.codec.xml.XMLProcessingInstruction;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.IList_;

public class XMLElementWOForDataLoading
implements IXMLElementWO {
    private final IDataLoader dataLoader;

    public XMLElementWOForDataLoading(IDataLoader dataLoader, IList_<XMLAttribute> attributes) throws EXXMLDecodingFailed {
        Assert.checkArgumentBeeingNotNull(dataLoader);
        this.dataLoader = dataLoader;
        for (XMLAttribute attribute : attributes) {
            XMLAttributeName attributeName = attribute.getAttributeName();
            if (XMLAttributeName.IS_EQUAL_XML_ATTRIBUTE_NAME_HASHER.isEqual(attributeName, XMLCoDecForData.NULL_ATTRIBUTE_NAME)) {
                XMLAttributeValue attributeValue = attribute.getAttributeValue();
                if (attributeValue.getRawStringValue().equals(XMLCoDecForData.NULL_ATTRIBUTE_VALUE.getRawStringValue())) {
                    dataLoader.setNull();
                    continue;
                }
                throw new EXXMLDecodingFailed(new EXInvalidXMLAttribute(attribute));
            }
            throw new EXXMLDecodingFailed(new EXInvalidXMLAttribute(attribute));
        }
    }

    @Override
    public void processingInstruction(XMLProcessingInstruction processingInstruction) throws EXXMLDecodingFailed {
    }

    @Override
    public void characters(String characters) throws EXXMLDecodingFailed {
        boolean canContainIngorableWhitespaces = true;
        this.dataLoader.characters(characters, canContainIngorableWhitespaces);
    }

    @Override
    public IXMLElementWO createChildElement(XMLElementName elementName, IList_<XMLAttribute> attributes) throws EXXMLDecodingFailed {
        Key flagOrPropertyOrChildRole = Key.getCanonicalKeyInstance(elementName.getElementName());
        IDataLoader flagOrPropertyOrChildDataLoader = this.dataLoader.createFlagOrPropertyOrChildDataLoader(flagOrPropertyOrChildRole);
        XMLElementWOForDataLoading flagOrPropertyOrChildXMLElementWO = new XMLElementWOForDataLoading(flagOrPropertyOrChildDataLoader, attributes);
        return flagOrPropertyOrChildXMLElementWO;
    }

    @Override
    public void endElement() throws EXXMLDecodingFailed {
        try {
            this.dataLoader.endData();
        }
        catch (EXDataLoadingExceptionWithCause e) {
            throw new EXXMLDecodingFailed(e.getCausingException());
        }
        catch (EXDataLoadingException e) {
            throw new EXXMLDecodingFailed(e);
        }
    }
}

