/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.data.codecs.ram;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IElementaryDataType;
import com.arcway.lib.codec.data.IStructuredDataType;
import com.arcway.lib.codec.data.codecs.ram.ElementaryRAMData;
import com.arcway.lib.codec.data.codecs.ram.IElementaryRAMData;
import com.arcway.lib.codec.data.codecs.ram.IRAMData;
import com.arcway.lib.codec.data.codecs.ram.IStructuredRAMData;
import com.arcway.lib.codec.data.codecs.ram.RAMData;
import com.arcway.lib.codec.data.codecs.ram.StructuredRAMData;

public class RAMDataCoDecForData {
    public static RAMData encodeIntoRAMData(IDataType dataType, Object data) {
        RAMData ramData;
        Class<? extends IDataType> type = dataType.getStructureType();
        IDataType concreteDataType = dataType.getConcreteDataType();
        if (concreteDataType.isNull(data)) {
            ramData = null;
        } else if (IElementaryDataType.class.isAssignableFrom(type)) {
            IElementaryDataType elementaryDataType = (IElementaryDataType)concreteDataType;
            ramData = new ElementaryRAMData(elementaryDataType, data);
        } else if (IStructuredDataType.class.isAssignableFrom(type)) {
            IStructuredDataType structuredDataType = (IStructuredDataType)concreteDataType;
            ramData = new StructuredRAMData(structuredDataType, data);
        } else {
            throw new IllegalArgumentException();
        }
        return ramData;
    }

    public static Object decodeFromRAMData(IDataType dataType, IRAMData ramData) throws EXDataCreationFailed {
        Object data;
        Class<? extends IDataType> type = dataType.getStructureType();
        IDataType concreteDataType = dataType.getConcreteDataType();
        if (ramData == null) {
            data = concreteDataType.createNullDataElement();
        } else if (IElementaryDataType.class.isAssignableFrom(type)) {
            IElementaryDataType elementaryDataType = (IElementaryDataType)concreteDataType;
            IElementaryRAMData elementaryRAMData = (IElementaryRAMData)ramData;
            data = elementaryRAMData.decodeElementaryData(elementaryDataType);
        } else if (IStructuredDataType.class.isAssignableFrom(type)) {
            IStructuredDataType structuredDataType = (IStructuredDataType)concreteDataType;
            IStructuredRAMData structuredRAMData = (IStructuredRAMData)ramData;
            data = structuredRAMData.decodeStructuredData(structuredDataType);
        } else {
            throw new IllegalArgumentException();
        }
        return data;
    }
}

