/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.data.codecs.generic.decoding;

import com.arcway.lib.codec.data.EXDataAssemblingFailed;
import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.EXDataLoadingException;
import com.arcway.lib.codec.data.EXUnknownFlagOrPropertyOrChildRoleForStructuredData;
import com.arcway.lib.codec.data.IDataFactory;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IElementaryDataFactory;
import com.arcway.lib.codec.data.IElementaryDataType;
import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.codec.data.IStructuredDataFactory;
import com.arcway.lib.codec.data.IStructuredDataType;
import com.arcway.lib.codec.data.SubDataType;
import com.arcway.lib.codec.data.codecs.generic.decoding.EXCharactersFoundForNonElementaryData;
import com.arcway.lib.codec.data.codecs.generic.decoding.EXCharactersOrSubElementFoundForNullData;
import com.arcway.lib.codec.data.codecs.generic.decoding.EXFlagOrPropertyOrChildFoundForNonStrucutedData;
import com.arcway.lib.codec.data.codecs.generic.decoding.EXMoreThanOneRootDataDetected;
import com.arcway.lib.codec.data.codecs.generic.decoding.EXMoreThanOneStringFoundForElementaryData;
import com.arcway.lib.codec.data.codecs.generic.decoding.FlagDataLoader;
import com.arcway.lib.codec.data.codecs.generic.decoding.IDataLoader;
import com.arcway.lib.codec.data.codecs.generic.decoding.PropertyOrChildDataLoader;
import com.arcway.lib.java.Assert;
import com.arcway.lib.stringtools.StringUtil;

public abstract class AbstractDataLoader
implements IDataLoader {
    private final IDataType dataType;
    private IDataFactory dataFactory = null;
    private boolean nullValueDetected = false;
    private boolean elementaryDataDetected = false;
    private boolean structuredDataDetected = false;
    private EXDataLoadingException dataLoadingException = null;

    public AbstractDataLoader(IDataType dataType) {
        Assert.checkArgumentBeeingNotNull(dataType);
        this.dataType = dataType;
    }

    @Override
    public void setNull() {
        if (this.elementaryDataDetected && this.dataLoadingException == null) {
            this.dataLoadingException = new EXCharactersOrSubElementFoundForNullData();
        }
        if (this.structuredDataDetected && this.dataLoadingException == null) {
            this.dataLoadingException = new EXCharactersOrSubElementFoundForNullData();
        }
        if (this.dataLoadingException == null) {
            this.nullValueDetected = true;
        }
    }

    @Override
    public void characters(String characters, boolean canContainIgnorableWhitespaces) {
        block5: {
            Assert.checkArgumentBeeingNotNull(characters);
            if (!(!this.nullValueDetected || this.dataLoadingException != null || canContainIgnorableWhitespaces && AbstractDataLoader.containsOnlyWhiteSpaces(characters))) {
                this.dataLoadingException = new EXCharactersOrSubElementFoundForNullData();
            }
            if (this.elementaryDataDetected && this.dataLoadingException == null) {
                this.dataLoadingException = new EXMoreThanOneStringFoundForElementaryData();
            }
            if (this.dataLoadingException == null) {
                try {
                    IElementaryDataFactory elementaryDataFactory = this.getElementaryDataFactory();
                    elementaryDataFactory.setCharacters(characters);
                    this.elementaryDataDetected = true;
                }
                catch (EXCharactersFoundForNonElementaryData e) {
                    if (canContainIgnorableWhitespaces && AbstractDataLoader.containsOnlyWhiteSpaces(characters)) break block5;
                    this.dataLoadingException = e;
                }
            }
        }
    }

    private static boolean containsOnlyWhiteSpaces(String characters) {
        String cleanedCharacters = StringUtil.removeLineBreaksAndControlCharacters(characters).trim();
        return cleanedCharacters.length() == 0;
    }

    @Override
    public IDataLoader createFlagOrPropertyOrChildDataLoader(IKey flagOrPropertyOrChildRole) {
        if (this.nullValueDetected) {
            this.dataLoadingException = new EXCharactersOrSubElementFoundForNullData();
        }
        IDataLoader subElementDataLoader = DUMMY_DATA_LOADER;
        if (this.dataLoadingException == null) {
            IStructuredDataType structuredDataType = this.getStructuredDataType();
            if (this.dataLoadingException == null) {
                IStructuredDataFactory structuredDataFactory = this.getStructuredDataFactory();
                if (this.dataLoadingException == null) {
                    SubDataType subDataType = structuredDataType.getSubDataType(flagOrPropertyOrChildRole);
                    if (subDataType == null) {
                        this.handleErrorenousFlagOrPropertyOrChild(flagOrPropertyOrChildRole, new EXUnknownFlagOrPropertyOrChildRoleForStructuredData(flagOrPropertyOrChildRole));
                    } else if (subDataType.isFlag()) {
                        subElementDataLoader = new FlagDataLoader(this, flagOrPropertyOrChildRole);
                    } else if (subDataType.isProperty() || subDataType.isChild()) {
                        IDataType propertyOrChildDataType = structuredDataFactory.getDataTypeOfPropertyOrChildren(flagOrPropertyOrChildRole);
                        subElementDataLoader = new PropertyOrChildDataLoader(this, flagOrPropertyOrChildRole, propertyOrChildDataType);
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        if (this.dataLoadingException == null) {
            this.structuredDataDetected = true;
        }
        Assert.checkArgumentBeeingNotNull(subElementDataLoader);
        return subElementDataLoader;
    }

    @Override
    public void endData() throws EXDataLoadingException {
        this.endDataWithoutThrowingException();
        if (this.dataLoadingException != null) {
            this.handleErrorenousFlagOrPropertyOrChildByParent(this.dataLoadingException);
        }
    }

    private void endDataWithoutThrowingException() {
        Object createdData = null;
        if (this.dataLoadingException == null) {
            try {
                if (this.nullValueDetected) {
                    createdData = this.dataType.createNullDataElement();
                } else {
                    this.lazySetupDataFactory();
                    createdData = this.dataFactory.createDataElement();
                }
            }
            catch (EXDataCreationFailed e) {
                this.dataLoadingException = e;
            }
        }
        if (this.dataLoadingException == null) {
            try {
                this.registerPropertyOrChildAtParent(createdData);
            }
            catch (EXDataLoadingException e) {
                this.dataLoadingException = e;
            }
        }
    }

    final void registerFlag(IKey roleOfFlag) {
        IStructuredDataFactory structuredDataFactory = this.getStructuredDataFactory();
        structuredDataFactory.setFlag(roleOfFlag);
    }

    final void registerPropertyOrChild(IKey roleOfPropertyOrChild, Object propertyOrChildData) throws EXDataAssemblingFailed {
        IStructuredDataFactory structuredDataFactory = this.getStructuredDataFactory();
        structuredDataFactory.addPropertyOrChild(roleOfPropertyOrChild, propertyOrChildData);
    }

    final void handleErrorenousFlagOrPropertyOrChild(IKey role, EXDataLoadingException exception) {
        IStructuredDataFactory structuredDataFactory = this.getStructuredDataFactory();
        if (!structuredDataFactory.isErroneousFlagOrPropertyOrChildToIgnore(role, exception)) {
            this.dataLoadingException = exception;
        }
    }

    protected abstract void registerPropertyOrChildAtParent(Object var1) throws EXMoreThanOneRootDataDetected, EXDataAssemblingFailed;

    protected abstract void handleErrorenousFlagOrPropertyOrChildByParent(EXDataLoadingException var1) throws EXDataLoadingException;

    private IStructuredDataType getStructuredDataType() {
        IStructuredDataType structuredDataType;
        Class<? extends IDataType> type = this.dataType.getStructureType();
        if (!IStructuredDataType.class.isAssignableFrom(type)) {
            this.dataLoadingException = new EXFlagOrPropertyOrChildFoundForNonStrucutedData();
            structuredDataType = null;
        } else {
            structuredDataType = (IStructuredDataType)this.dataType.getConcreteDataType();
        }
        return structuredDataType;
    }

    private IElementaryDataFactory getElementaryDataFactory() throws EXCharactersFoundForNonElementaryData {
        Class<? extends IDataType> type = this.dataType.getStructureType();
        if (!IElementaryDataType.class.isAssignableFrom(type)) {
            throw new EXCharactersFoundForNonElementaryData();
        }
        this.lazySetupDataFactory();
        IElementaryDataFactory elementaryDataFactory = (IElementaryDataFactory)this.dataFactory;
        return elementaryDataFactory;
    }

    private IStructuredDataFactory getStructuredDataFactory() {
        IStructuredDataFactory structuredDataFactory;
        Class<? extends IDataType> type = this.dataType.getStructureType();
        if (!IStructuredDataType.class.isAssignableFrom(type)) {
            this.dataLoadingException = new EXFlagOrPropertyOrChildFoundForNonStrucutedData();
            structuredDataFactory = null;
        } else {
            this.lazySetupDataFactory();
            structuredDataFactory = (IStructuredDataFactory)this.dataFactory;
        }
        return structuredDataFactory;
    }

    private void lazySetupDataFactory() {
        if (this.dataFactory == null) {
            Class<? extends IDataType> type = this.dataType.getStructureType();
            if (IElementaryDataType.class.isAssignableFrom(type)) {
                IElementaryDataType elementaryDataType = (IElementaryDataType)this.dataType.getConcreteDataType();
                this.dataFactory = elementaryDataType.createDataFactory();
            } else if (IStructuredDataType.class.isAssignableFrom(type)) {
                IStructuredDataType structuredDataType = (IStructuredDataType)this.dataType.getConcreteDataType();
                this.dataFactory = structuredDataType.createDataFactory();
            }
        }
    }
}

