/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.data;

import com.arcway.lib.codec.data.EXDataAssemblingFailed;
import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.EXDataLoadingException;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IElementaryDataFactory;
import com.arcway.lib.codec.data.IElementaryDataType;
import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.codec.data.IStructuredDataFactory;
import com.arcway.lib.codec.data.IStructuredDataType;
import com.arcway.lib.codec.data.SubDataType;
import com.arcway.lib.java.collections.IList_;

public abstract class DelegatingDataType
implements IDataType {
    private final IDataType wrapperDataType;
    private final IDataType targetDataType;

    public DelegatingDataType(IDataType targetDataType) {
        this.targetDataType = targetDataType;
        Class<? extends IDataType> type = targetDataType.getStructureType();
        if (IElementaryDataType.class.isAssignableFrom(type)) {
            this.wrapperDataType = new DelegateForElementaryDataType();
        } else if (IStructuredDataType.class.isAssignableFrom(type)) {
            this.wrapperDataType = new DelegateForStructuredDataType();
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Class<? extends IDataType> getStructureType() {
        return this.targetDataType.getStructureType();
    }

    @Override
    public IDataType getConcreteDataType() {
        return this.wrapperDataType;
    }

    @Override
    public boolean isNull(Object data) {
        Object unwrappedData = this.unwrapData(data);
        return this.targetDataType.isNull(unwrappedData);
    }

    @Override
    public Object createNullDataElement() throws EXDataCreationFailed {
        Object unwrappedData = this.targetDataType.createNullDataElement();
        return this.createWrappedData(unwrappedData);
    }

    protected abstract Object unwrapData(Object var1);

    protected abstract Object createWrappedData(Object var1) throws EXDataCreationFailed;

    private abstract class AbstractDelegatingDataType
    implements IDataType {
        @Override
        public Class<? extends IDataType> getStructureType() {
            return DelegatingDataType.this.getStructureType();
        }

        @Override
        public IDataType getConcreteDataType() {
            return DelegatingDataType.this.getConcreteDataType();
        }

        @Override
        public boolean isNull(Object data) {
            return DelegatingDataType.this.isNull(data);
        }

        @Override
        public Object createNullDataElement() throws EXDataCreationFailed {
            return DelegatingDataType.this.createNullDataElement();
        }
    }

    private class DelegateForElementaryDataType
    extends AbstractDelegatingDataType
    implements IElementaryDataType {
        private DelegateForElementaryDataType() {
        }

        @Override
        public String getValueAsString(Object data) {
            Object unwrappedData = DelegatingDataType.this.unwrapData(data);
            return this.getTargetDataType().getValueAsString(unwrappedData);
        }

        @Override
        public IElementaryDataFactory createDataFactory() {
            return new DelegateForElementaryDataFactory();
        }

        private IElementaryDataType getTargetDataType() {
            return (IElementaryDataType)DelegatingDataType.this.targetDataType.getConcreteDataType();
        }

        private class DelegateForElementaryDataFactory
        implements IElementaryDataFactory {
            private final IElementaryDataFactory targetDataFactory;

            private DelegateForElementaryDataFactory() {
                this.targetDataFactory = DelegateForElementaryDataType.this.getTargetDataType().createDataFactory();
            }

            @Override
            public void setCharacters(String characters) {
                this.targetDataFactory.setCharacters(characters);
            }

            @Override
            public Object createDataElement() throws EXDataCreationFailed {
                Object unwrappedData = this.targetDataFactory.createDataElement();
                return DelegatingDataType.this.createWrappedData(unwrappedData);
            }
        }
    }

    private class DelegateForStructuredDataType
    extends AbstractDelegatingDataType
    implements IStructuredDataType {
        private DelegateForStructuredDataType() {
        }

        @Override
        public IList_<IKey> getFlagAndPropertyAndChildRoles(Object data) {
            return this.getTargetDataType().getFlagAndPropertyAndChildRoles(data);
        }

        @Override
        public SubDataType getSubDataType(IKey role) {
            return this.getTargetDataType().getSubDataType(role);
        }

        @Override
        public boolean isSet(Object data, IKey role) {
            Object unwrappedData = DelegatingDataType.this.unwrapData(data);
            return this.getTargetDataType().isSet(unwrappedData, role);
        }

        @Override
        public IDataType getDataTypeOfPropertyOrChildren(Object data, IKey role) {
            Object unwrappedData = DelegatingDataType.this.unwrapData(data);
            return this.getTargetDataType().getDataTypeOfPropertyOrChildren(unwrappedData, role);
        }

        @Override
        public Object getProperty(Object data, IKey role) {
            Object unwrappedData = DelegatingDataType.this.unwrapData(data);
            return this.getTargetDataType().getProperty(unwrappedData, role);
        }

        @Override
        public IList_<? extends Object> getChildren(Object data, IKey role) {
            Object unwrappedData = DelegatingDataType.this.unwrapData(data);
            return this.getTargetDataType().getChildren(unwrappedData, role);
        }

        @Override
        public IStructuredDataFactory createDataFactory() {
            return new DelegateForStructuredDataFactory();
        }

        private IStructuredDataType getTargetDataType() {
            return (IStructuredDataType)DelegatingDataType.this.targetDataType;
        }

        private class DelegateForStructuredDataFactory
        implements IStructuredDataFactory {
            private final IStructuredDataFactory targetDataFactory;

            private DelegateForStructuredDataFactory() {
                this.targetDataFactory = DelegateForStructuredDataType.this.getTargetDataType().createDataFactory();
            }

            @Override
            public void setFlag(IKey role) {
                this.targetDataFactory.setFlag(role);
            }

            @Override
            public IDataType getDataTypeOfPropertyOrChildren(IKey role) {
                return this.targetDataFactory.getDataTypeOfPropertyOrChildren(role);
            }

            @Override
            public void addPropertyOrChild(IKey role, Object propertyOrChild) throws EXDataAssemblingFailed {
                this.targetDataFactory.addPropertyOrChild(role, propertyOrChild);
            }

            @Override
            public Object createDataElement() throws EXDataCreationFailed {
                Object unwrappedData = this.targetDataFactory.createDataElement();
                return DelegatingDataType.this.createWrappedData(unwrappedData);
            }

            @Override
            public boolean isErroneousFlagOrPropertyOrChildToIgnore(IKey role, EXDataLoadingException exception) {
                return this.targetDataFactory.isErroneousFlagOrPropertyOrChildToIgnore(role, exception);
            }
        }
    }
}

