/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;

public class UUIDGenerator {
    static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final UUIDGenerator generator = new UUIDGenerator();
    private final char[] uuidAssemblyBuffer;
    private final SecureRandom seeder = new SecureRandom();
    private long lastUUIDMillis;
    private int randomInititialCounterValueForUUIDsGeneratedSinceLastUUIDMillisChanged;
    private int counterForUUIDsGeneratedSinceLastUUIDMillisChanged;

    public UUIDGenerator() {
        String hexInetAddress;
        this.seeder.nextInt();
        try {
            InetAddress inet = InetAddress.getLocalHost();
            byte[] bytes = inet.getAddress();
            hexInetAddress = this.hexFormat8(this.getInt(bytes));
        }
        catch (UnknownHostException e) {
            hexInetAddress = this.hexFormat8((int)System.currentTimeMillis());
        }
        this.lastUUIDMillis = 0L;
        this.counterForUUIDsGeneratedSinceLastUUIDMillisChanged = this.randomInititialCounterValueForUUIDsGeneratedSinceLastUUIDMillisChanged = 0xFFFF & this.seeder.nextInt();
        this.uuidAssemblyBuffer = new char[32];
        System.arraycopy(hexInetAddress.toCharArray(), 0, this.uuidAssemblyBuffer, 8, 8);
    }

    private String hexFormat8(int valueToConvertToHexFormat) {
        char[] tmp = new char[8];
        this.fastHexFormat8(valueToConvertToHexFormat, tmp, 0);
        return new String(tmp);
    }

    private void fastHexFormat8(int valueToConvertToHexFormat, char[] resultBuffer, int resultBufferStartPos) {
        int remainder = valueToConvertToHexFormat;
        resultBuffer[resultBufferStartPos + 7] = hexDigits[remainder & 0xF];
        resultBuffer[resultBufferStartPos + 6] = hexDigits[(remainder >>>= 4) & 0xF];
        resultBuffer[resultBufferStartPos + 5] = hexDigits[(remainder >>>= 4) & 0xF];
        resultBuffer[resultBufferStartPos + 4] = hexDigits[(remainder >>>= 4) & 0xF];
        resultBuffer[resultBufferStartPos + 3] = hexDigits[(remainder >>>= 4) & 0xF];
        resultBuffer[resultBufferStartPos + 2] = hexDigits[(remainder >>>= 4) & 0xF];
        resultBuffer[resultBufferStartPos + 1] = hexDigits[(remainder >>>= 4) & 0xF];
        resultBuffer[resultBufferStartPos] = hexDigits[(remainder >>>= 4) & 0xF];
    }

    private int getInt(byte[] bytes) {
        int i = 0;
        int j = bytes.length - 1;
        while (j > 0) {
            i = i * 256 + bytes[j];
            --j;
        }
        return i;
    }

    public synchronized String getUUID() {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.lastUUIDMillis >= currentTimeMillis && (0xFFFF & this.counterForUUIDsGeneratedSinceLastUUIDMillisChanged + 1) == this.randomInititialCounterValueForUUIDsGeneratedSinceLastUUIDMillisChanged) {
            currentTimeMillis = this.lastUUIDMillis + 1L;
        }
        if (currentTimeMillis > this.lastUUIDMillis) {
            this.lastUUIDMillis = currentTimeMillis;
            this.counterForUUIDsGeneratedSinceLastUUIDMillisChanged = this.randomInititialCounterValueForUUIDsGeneratedSinceLastUUIDMillisChanged = 0xFFFF & this.seeder.nextInt();
        } else {
            this.counterForUUIDsGeneratedSinceLastUUIDMillisChanged = 0xFFFF & this.counterForUUIDsGeneratedSinceLastUUIDMillisChanged + 1;
        }
        this.fastHexFormat8((int)(0xFFFFFFFFFFFFFFFFL & this.lastUUIDMillis), this.uuidAssemblyBuffer, 0);
        int mixed = (int)(this.lastUUIDMillis >>> 16 & 0xFFFFFFFFFFFF0000L | (long)this.counterForUUIDsGeneratedSinceLastUUIDMillisChanged);
        this.fastHexFormat8(mixed, this.uuidAssemblyBuffer, 16);
        this.fastHexFormat8(this.seeder.nextInt(), this.uuidAssemblyBuffer, 24);
        return new String(this.uuidAssemblyBuffer);
    }

    public static String getUniqueID() {
        return generator.getUUID();
    }
}

