/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.FileChannel;

public class SettingsCopier {
    public static final int bufferCapacity = 65536;

    public static void main(String[] args) throws IOException {
        File source = new File("D:\\hh\\cockpit-head-mars\\ARCWAYLib\\.settings");
        File root = source.getParentFile().getParentFile();
        File[] fileArray = root.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File sources;
            File project = fileArray[n2];
            if (project.isDirectory() && (sources = new File(project, "sources")).isDirectory()) {
                File target = new File(project, ".settings");
                if (!target.exists()) {
                    target.mkdir();
                }
                if (target.isDirectory()) {
                    SettingsCopier.copy(source, target);
                }
            }
            ++n2;
        }
    }

    private static void copy(File source, File dest) throws IOException {
        SettingsCopier.copyFile(source, dest, "org.eclipse.jdt.core.prefs");
        SettingsCopier.copyFile(source, dest, "org.eclipse.jdt.launching.prefs");
        SettingsCopier.copyFile(source, dest, "org.eclipse.jdt.ui.prefs");
        SettingsCopier.copyFile(source, dest, "org.eclipse.pde.prefs");
    }

    private static void copyFile(File source, File dest, String name) throws IOException {
        SettingsCopier.copyFile(new File(source, name), new File(dest, name));
    }

    private static void copyFile(File source, File destination) throws IOException {
        FileInputStream fin = null;
        fin = new FileInputStream(source);
        FileOutputStream fout = null;
        fout = new FileOutputStream(destination);
        SettingsCopier.streamCopy(fin, fout);
    }

    private static void streamCopy(InputStream source, OutputStream destination) throws IOException {
        FileChannel sourceChannel = source instanceof FileInputStream ? ((FileInputStream)source).getChannel() : null;
        FileChannel destinationChannel = destination instanceof FileOutputStream ? ((FileOutputStream)destination).getChannel() : null;
        if (sourceChannel != null) {
            if (destinationChannel != null) {
                SettingsCopier.byteCopy((ByteChannel)sourceChannel, (ByteChannel)destinationChannel);
            } else {
                SettingsCopier.byteCopy((ByteChannel)sourceChannel, destination);
            }
        } else if (destinationChannel != null) {
            SettingsCopier.byteCopy(source, (ByteChannel)destinationChannel);
        } else {
            SettingsCopier.byteCopy(source, destination);
        }
        destination.flush();
    }

    private static void byteCopy(InputStream source, OutputStream destination) throws IOException {
        int bytesRead;
        byte[] bufferArray = new byte[65536];
        while ((bytesRead = source.read(bufferArray)) > 0) {
            destination.write(bufferArray, 0, bytesRead);
        }
    }

    private static void byteCopy(InputStream source, ByteChannel destination) throws IOException {
        block1: {
            ByteBuffer buffer = ByteBuffer.allocate(65536);
            do {
                buffer.clear();
                int r = source.read(buffer.array());
                if (r == -1) break block1;
                buffer.position(r);
                buffer.flip();
                destination.write(buffer);
            } while (buffer.remaining() == 0);
            throw new IOException("I/O Buffer still contained Data after trying to transfer the Buffer content to an I/O Channel.");
        }
    }

    private static void byteCopy(ByteChannel source, OutputStream destination) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        while (true) {
            buffer.clear();
            int r = source.read(buffer);
            if (r == -1) break;
            buffer.flip();
            destination.write(buffer.array(), buffer.position(), buffer.remaining());
        }
    }

    private static void byteCopy(ByteChannel source, ByteChannel destination) throws IOException {
        block1: {
            ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
            do {
                buffer.clear();
                int r = source.read(buffer);
                if (r == -1) break block1;
                buffer.flip();
                destination.write(buffer);
            } while (buffer.remaining() == 0);
            throw new IOException("I/O Buffer still contained Data after trying to transfer the Buffer content to an I/O Channel.");
        }
    }
}

