/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CRC64 {
    private static final long POLY = -3932672073523589310L;
    private static final long[][] table;
    private long value;

    static {
        int k;
        long crc;
        table = new long[8][256];
        int n = 0;
        while (n < 256) {
            crc = n;
            k = 0;
            while (k < 8) {
                crc = (crc & 1L) == 1L ? crc >>> 1 ^ 0xC96C5795D7870F42L : (crc >>>= 1);
                ++k;
            }
            CRC64.table[0][n] = crc;
            ++n;
        }
        n = 0;
        while (n < 256) {
            crc = table[0][n];
            k = 1;
            while (k < 8) {
                CRC64.table[k][n] = crc = table[0][(int)(crc & 0xFFL)] ^ crc >>> 8;
                ++k;
            }
            ++n;
        }
    }

    private CRC64() {
        this.value = 0L;
    }

    private CRC64(long value) {
        this.value = value;
    }

    private CRC64(byte[] b, int len) {
        this.value = 0L;
        this.update(b, len);
    }

    private CRC64(byte[] b, int off, int len) {
        this.value = 0L;
        this.update(b, off, len);
    }

    public static long calculateCRC64FromBytes(byte[] b) {
        CRC64 crc = new CRC64(b, b.length);
        return crc.getValue();
    }

    public static long calculateCRC64FromBytes(byte[] b, int off, int len) {
        CRC64 crc = new CRC64(b, off, len);
        return crc.getValue();
    }

    public static long calculateCRC64FromFile(File f) throws IOException {
        return CRC64.fromFile(f).getValue();
    }

    public static long calculateCRC64FromInputStream(InputStream in) throws IOException {
        return CRC64.fromInputStream(in).getValue();
    }

    private static CRC64 fromFile(File f) throws IOException {
        return CRC64.fromInputStream(new FileInputStream(f));
    }

    private static CRC64 fromInputStream(InputStream in) throws IOException {
        try {
            CRC64 crc = new CRC64();
            byte[] b = new byte[65536];
            int l = 0;
            while ((l = in.read(b)) != -1) {
                crc.update(b, l);
            }
            CRC64 cRC64 = crc;
            return cRC64;
        }
        finally {
            in.close();
        }
    }

    private long getValue() {
        return this.value;
    }

    private void update(byte[] b, int len) {
        this.update(b, 0, len);
    }

    private void update(byte[] b, int off, int len2) {
        int len = len2;
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
        int idx = off;
        while (len >= 8) {
            this.value = table[7][(int)(this.value & 0xFFL ^ (long)(b[idx] & 0xFF))] ^ table[6][(int)(this.value >>> 8 & 0xFFL ^ (long)(b[idx + 1] & 0xFF))] ^ table[5][(int)(this.value >>> 16 & 0xFFL ^ (long)(b[idx + 2] & 0xFF))] ^ table[4][(int)(this.value >>> 24 & 0xFFL ^ (long)(b[idx + 3] & 0xFF))] ^ table[3][(int)(this.value >>> 32 & 0xFFL ^ (long)(b[idx + 4] & 0xFF))] ^ table[2][(int)(this.value >>> 40 & 0xFFL ^ (long)(b[idx + 5] & 0xFF))] ^ table[1][(int)(this.value >>> 48 & 0xFFL ^ (long)(b[idx + 6] & 0xFF))] ^ table[0][(int)(this.value >>> 56 ^ (long)(b[idx + 7] & 0xFF))];
            idx += 8;
            len -= 8;
        }
        while (len > 0) {
            this.value = table[0][(int)((this.value ^ (long)b[idx]) & 0xFFL)] ^ this.value >>> 8;
            ++idx;
            --len;
        }
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
    }
}

