/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer.dom3;

import java.util.Enumeration;
import org.apache.xml.serializer.dom3.NamespaceSupport;

public class NamespaceSupport {
    static final String PREFIX_XML = "xml".intern();
    static final String PREFIX_XMLNS = "xmlns".intern();
    public static final String XML_URI = "http://www.w3.org/XML/1998/namespace".intern();
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/".intern();
    protected String[] fNamespace = new String[32];
    protected int fNamespaceSize;
    protected int[] fContext = new int[8];
    protected int fCurrentContext;
    protected String[] fPrefixes = new String[16];

    public void reset() {
        this.fNamespaceSize = 0;
        this.fCurrentContext = 0;
        this.fContext[this.fCurrentContext] = this.fNamespaceSize;
        this.fNamespace[this.fNamespaceSize++] = PREFIX_XML;
        this.fNamespace[this.fNamespaceSize++] = XML_URI;
        this.fNamespace[this.fNamespaceSize++] = PREFIX_XMLNS;
        this.fNamespace[this.fNamespaceSize++] = XMLNS_URI;
        ++this.fCurrentContext;
    }

    public void pushContext() {
        if (this.fCurrentContext + 1 == this.fContext.length) {
            int[] contextarray = new int[this.fContext.length * 2];
            System.arraycopy(this.fContext, 0, contextarray, 0, this.fContext.length);
            this.fContext = contextarray;
        }
        this.fContext[++this.fCurrentContext] = this.fNamespaceSize;
    }

    public void popContext() {
        this.fNamespaceSize = this.fContext[this.fCurrentContext--];
    }

    public boolean declarePrefix(String prefix, String uri) {
        if (prefix == PREFIX_XML || prefix == PREFIX_XMLNS) {
            return false;
        }
        int i = this.fNamespaceSize;
        while (i > this.fContext[this.fCurrentContext]) {
            if (this.fNamespace[i - 2].equals(prefix)) {
                this.fNamespace[i - 1] = uri;
                return true;
            }
            i -= 2;
        }
        if (this.fNamespaceSize == this.fNamespace.length) {
            String[] namespacearray = new String[this.fNamespaceSize * 2];
            System.arraycopy(this.fNamespace, 0, namespacearray, 0, this.fNamespaceSize);
            this.fNamespace = namespacearray;
        }
        this.fNamespace[this.fNamespaceSize++] = prefix;
        this.fNamespace[this.fNamespaceSize++] = uri;
        return true;
    }

    public String getURI(String prefix) {
        int i = this.fNamespaceSize;
        while (i > 0) {
            if (this.fNamespace[i - 2].equals(prefix)) {
                return this.fNamespace[i - 1];
            }
            i -= 2;
        }
        return null;
    }

    public String getPrefix(String uri) {
        int i = this.fNamespaceSize;
        while (i > 0) {
            if (this.fNamespace[i - 1].equals(uri) && this.getURI(this.fNamespace[i - 2]).equals(uri)) {
                return this.fNamespace[i - 2];
            }
            i -= 2;
        }
        return null;
    }

    public int getDeclaredPrefixCount() {
        return (this.fNamespaceSize - this.fContext[this.fCurrentContext]) / 2;
    }

    public String getDeclaredPrefixAt(int index) {
        return this.fNamespace[this.fContext[this.fCurrentContext] + index * 2];
    }

    public Enumeration getAllPrefixes() {
        int count = 0;
        if (this.fPrefixes.length < this.fNamespace.length / 2) {
            String[] prefixes = new String[this.fNamespaceSize];
            this.fPrefixes = prefixes;
        }
        String prefix = null;
        boolean unique = true;
        int i = 2;
        while (i < this.fNamespaceSize - 2) {
            prefix = this.fNamespace[i + 2];
            int k = 0;
            while (k < count) {
                if (this.fPrefixes[k] == prefix) {
                    unique = false;
                    break;
                }
                ++k;
            }
            if (unique) {
                this.fPrefixes[count++] = prefix;
            }
            unique = true;
            i += 2;
        }
        return new Prefixes(this, this.fPrefixes, count);
    }
}

