/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.xpointer;

import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xpointer.ElementSchemePointer;
import org.apache.xerces.xpointer.ShortHandPointer;
import org.apache.xerces.xpointer.XPointerErrorHandler;
import org.apache.xerces.xpointer.XPointerMessageFormatter;
import org.apache.xerces.xpointer.XPointerPart;

/*
 * Exception performing whole class analysis ignored.
 */
class ElementSchemePointer
implements XPointerPart {
    private String fSchemeName;
    private String fSchemeData;
    private String fShortHandPointerName;
    private boolean fIsResolveElement = false;
    private boolean fIsElementFound = false;
    private boolean fWasOnlyEmptyElementFound = false;
    boolean fIsShortHand = false;
    int fFoundDepth = 0;
    private int[] fChildSequence;
    private int fCurrentChildPosition = 1;
    private int fCurrentChildDepth = 0;
    private int[] fCurrentChildSequence;
    private boolean fIsFragmentResolved = false;
    private ShortHandPointer fShortHandPointer;
    protected XMLErrorReporter fErrorReporter;
    protected XMLErrorHandler fErrorHandler;
    private SymbolTable fSymbolTable;

    public ElementSchemePointer() {
    }

    public ElementSchemePointer(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
    }

    public ElementSchemePointer(SymbolTable symbolTable, XMLErrorReporter xMLErrorReporter) {
        this.fSymbolTable = symbolTable;
        this.fErrorReporter = xMLErrorReporter;
    }

    public void parseXPointer(String string) throws XNIException {
        this.init();
        Tokens tokens = new Tokens(this, this.fSymbolTable, null);
        1 var3_3 = new /* Unavailable Anonymous Inner Class!! */;
        int n = string.length();
        boolean bl = Scanner.access$300((Scanner)var3_3, (SymbolTable)this.fSymbolTable, (Tokens)tokens, (String)string, (int)0, (int)n);
        if (!bl) {
            this.reportError("InvalidElementSchemeXPointer", new Object[]{string});
        }
        int[] nArray = new int[Tokens.access$400((Tokens)tokens) / 2 + 1];
        int n2 = 0;
        while (Tokens.access$500((Tokens)tokens)) {
            int n3 = Tokens.access$600((Tokens)tokens);
            switch (n3) {
                case 0: {
                    n3 = Tokens.access$600((Tokens)tokens);
                    this.fShortHandPointerName = Tokens.access$200((Tokens)tokens, (int)n3);
                    this.fShortHandPointer = new ShortHandPointer(this.fSymbolTable);
                    this.fShortHandPointer.setSchemeName(this.fShortHandPointerName);
                    break;
                }
                case 1: {
                    nArray[n2] = Tokens.access$600((Tokens)tokens);
                    ++n2;
                    break;
                }
                default: {
                    this.reportError("InvalidElementSchemeXPointer", new Object[]{string});
                }
            }
        }
        this.fChildSequence = new int[n2];
        this.fCurrentChildSequence = new int[n2];
        System.arraycopy(nArray, 0, this.fChildSequence, 0, n2);
    }

    public String getSchemeName() {
        return this.fSchemeName;
    }

    public String getSchemeData() {
        return this.fSchemeData;
    }

    public void setSchemeName(String string) {
        this.fSchemeName = string;
    }

    public void setSchemeData(String string) {
        this.fSchemeData = string;
    }

    public boolean resolveXPointer(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations, int n) throws XNIException {
        boolean bl = false;
        if (this.fShortHandPointerName != null) {
            bl = this.fShortHandPointer.resolveXPointer(qName, xMLAttributes, augmentations, n);
            if (bl) {
                this.fIsResolveElement = true;
                this.fIsShortHand = true;
            } else {
                this.fIsResolveElement = false;
            }
        } else {
            this.fIsResolveElement = true;
        }
        this.fIsFragmentResolved = this.fChildSequence.length > 0 ? this.matchChildSequence(qName, n) : (bl && this.fChildSequence.length <= 0 ? bl : false);
        return this.fIsFragmentResolved;
    }

    protected boolean matchChildSequence(QName qName, int n) throws XNIException {
        if (this.fCurrentChildDepth >= this.fCurrentChildSequence.length) {
            int[] nArray = new int[this.fCurrentChildSequence.length];
            System.arraycopy(this.fCurrentChildSequence, 0, nArray, 0, this.fCurrentChildSequence.length);
            this.fCurrentChildSequence = new int[this.fCurrentChildDepth * 2];
            System.arraycopy(nArray, 0, this.fCurrentChildSequence, 0, nArray.length);
        }
        if (this.fIsResolveElement) {
            if (n == 0) {
                this.fCurrentChildSequence[this.fCurrentChildDepth] = this.fCurrentChildPosition;
                ++this.fCurrentChildDepth;
                this.fCurrentChildPosition = 1;
                if (this.fCurrentChildDepth <= this.fFoundDepth || this.fFoundDepth == 0) {
                    if (this.checkMatch()) {
                        this.fIsElementFound = true;
                        this.fFoundDepth = this.fCurrentChildDepth;
                    } else {
                        this.fIsElementFound = false;
                        this.fFoundDepth = 0;
                    }
                }
            } else if (n == 1) {
                if (this.fCurrentChildDepth == this.fFoundDepth) {
                    this.fIsElementFound = true;
                } else if (this.fCurrentChildDepth < this.fFoundDepth && this.fFoundDepth != 0 || this.fCurrentChildDepth > this.fFoundDepth && this.fFoundDepth == 0) {
                    this.fIsElementFound = false;
                }
                this.fCurrentChildSequence[this.fCurrentChildDepth] = 0;
                --this.fCurrentChildDepth;
                this.fCurrentChildPosition = this.fCurrentChildSequence[this.fCurrentChildDepth] + 1;
            } else if (n == 2) {
                this.fCurrentChildSequence[this.fCurrentChildDepth] = this.fCurrentChildPosition++;
                if (this.checkMatch()) {
                    this.fWasOnlyEmptyElementFound = !this.fIsElementFound;
                    this.fIsElementFound = true;
                } else {
                    this.fIsElementFound = false;
                    this.fWasOnlyEmptyElementFound = false;
                }
            }
        }
        return this.fIsElementFound;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkMatch() {
        if (!this.fIsShortHand) {
            if (this.fChildSequence.length > this.fCurrentChildDepth + 1) return false;
            int n = 0;
            while (n < this.fChildSequence.length) {
                if (this.fChildSequence[n] != this.fCurrentChildSequence[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        } else {
            if (this.fChildSequence.length > this.fCurrentChildDepth + 1) return false;
            int n = 0;
            while (n < this.fChildSequence.length) {
                if (this.fCurrentChildSequence.length < n + 2) {
                    return false;
                }
                if (this.fChildSequence[n] != this.fCurrentChildSequence[n + 1]) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public boolean isFragmentResolved() throws XNIException {
        return this.fIsFragmentResolved;
    }

    public boolean isChildFragmentResolved() {
        if (this.fIsShortHand && this.fShortHandPointer != null && this.fChildSequence.length <= 0) {
            return this.fShortHandPointer.isChildFragmentResolved();
        }
        return this.fWasOnlyEmptyElementFound ? !this.fWasOnlyEmptyElementFound : this.fIsFragmentResolved && this.fCurrentChildDepth >= this.fFoundDepth;
    }

    protected void reportError(String string, Object[] objectArray) throws XNIException {
        throw new XNIException(this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/XPTR").formatMessage(this.fErrorReporter.getLocale(), string, objectArray));
    }

    protected void initErrorReporter() {
        if (this.fErrorReporter == null) {
            this.fErrorReporter = new XMLErrorReporter();
        }
        if (this.fErrorHandler == null) {
            this.fErrorHandler = new XPointerErrorHandler();
        }
        this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/XPTR", (MessageFormatter)new XPointerMessageFormatter());
    }

    protected void init() {
        this.fSchemeName = null;
        this.fSchemeData = null;
        this.fShortHandPointerName = null;
        this.fIsResolveElement = false;
        this.fIsElementFound = false;
        this.fWasOnlyEmptyElementFound = false;
        this.fFoundDepth = 0;
        this.fCurrentChildPosition = 1;
        this.fCurrentChildDepth = 0;
        this.fIsFragmentResolved = false;
        this.fShortHandPointer = null;
        this.initErrorReporter();
    }
}

