/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.validation;

import java.io.IOException;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.validation.EntityState;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.jaxp.validation.DOMDocumentHandler;
import org.apache.xerces.jaxp.validation.DOMResultAugmentor;
import org.apache.xerces.jaxp.validation.DOMResultBuilder;
import org.apache.xerces.jaxp.validation.DOMValidatorHelper;
import org.apache.xerces.jaxp.validation.JAXPValidationMessageFormatter;
import org.apache.xerces.jaxp.validation.Util;
import org.apache.xerces.jaxp.validation.ValidatorHelper;
import org.apache.xerces.jaxp.validation.XMLSchemaValidatorComponentManager;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

final class DOMValidatorHelper
implements ValidatorHelper,
EntityState {
    private static final int CHUNK_SIZE = 1024;
    private static final int CHUNK_MASK = 1023;
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String NAMESPACE_CONTEXT = "http://apache.org/xml/properties/internal/namespace-context";
    private static final String SCHEMA_VALIDATOR = "http://apache.org/xml/properties/internal/validator/schema";
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    private XMLErrorReporter fErrorReporter;
    private NamespaceSupport fNamespaceContext;
    private DOMNamespaceContext fDOMNamespaceContext = new DOMNamespaceContext(this);
    private XMLSchemaValidator fSchemaValidator;
    private SymbolTable fSymbolTable;
    private ValidationManager fValidationManager;
    private XMLSchemaValidatorComponentManager fComponentManager;
    private final SimpleLocator fXMLLocator = new SimpleLocator(null, null, -1, -1, -1);
    private DOMDocumentHandler fDOMValidatorHandler;
    private final DOMResultAugmentor fDOMResultAugmentor = new DOMResultAugmentor(this);
    private final DOMResultBuilder fDOMResultBuilder = new DOMResultBuilder();
    private NamedNodeMap fEntities = null;
    private char[] fCharBuffer = new char[1024];
    private Node fRoot;
    private Node fCurrentElement;
    final QName fElementQName = new QName();
    final QName fAttributeQName = new QName();
    final XMLAttributesImpl fAttributes = new XMLAttributesImpl();
    final XMLString fTempString = new XMLString();

    public DOMValidatorHelper(XMLSchemaValidatorComponentManager xMLSchemaValidatorComponentManager) {
        this.fComponentManager = xMLSchemaValidatorComponentManager;
        this.fErrorReporter = (XMLErrorReporter)this.fComponentManager.getProperty(ERROR_REPORTER);
        this.fNamespaceContext = (NamespaceSupport)this.fComponentManager.getProperty(NAMESPACE_CONTEXT);
        this.fSchemaValidator = (XMLSchemaValidator)this.fComponentManager.getProperty(SCHEMA_VALIDATOR);
        this.fSymbolTable = (SymbolTable)this.fComponentManager.getProperty(SYMBOL_TABLE);
        this.fValidationManager = (ValidationManager)this.fComponentManager.getProperty(VALIDATION_MANAGER);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate(Source source, Result result) throws SAXException, IOException {
        Node node;
        if (!(result instanceof DOMResult) && result != null) {
            throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage((Locale)Locale.getDefault(), (String)"SourceResultMismatch", (Object[])new Object[]{source.getClass().getName(), result.getClass().getName()}));
        }
        DOMSource dOMSource = (DOMSource)source;
        DOMResult dOMResult = (DOMResult)result;
        this.fRoot = node = dOMSource.getNode();
        if (node == null) return;
        this.fComponentManager.reset();
        this.fValidationManager.setEntityState((EntityState)this);
        this.fDOMNamespaceContext.reset();
        String string = dOMSource.getSystemId();
        this.fXMLLocator.setLiteralSystemId(string);
        this.fXMLLocator.setExpandedSystemId(string);
        this.fErrorReporter.setDocumentLocator((XMLLocator)this.fXMLLocator);
        try {
            try {
                this.setupEntityMap(node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument());
                this.setupDOMResultHandler(dOMSource, dOMResult);
                this.fSchemaValidator.startDocument((XMLLocator)this.fXMLLocator, null, (NamespaceContext)this.fDOMNamespaceContext, null);
                this.validate(node);
                this.fSchemaValidator.endDocument(null);
            }
            catch (XMLParseException xMLParseException) {
                throw Util.toSAXParseException((XMLParseException)xMLParseException);
            }
            catch (XNIException xNIException) {
                throw Util.toSAXException((XNIException)xNIException);
            }
            Object var10_7 = null;
            this.fRoot = null;
            this.fCurrentElement = null;
            this.fEntities = null;
            if (this.fDOMValidatorHandler == null) return;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            this.fRoot = null;
            this.fCurrentElement = null;
            this.fEntities = null;
            if (this.fDOMValidatorHandler == null) throw throwable;
            this.fDOMValidatorHandler.setDOMResult(null);
            throw throwable;
        }
        this.fDOMValidatorHandler.setDOMResult(null);
    }

    public boolean isEntityDeclared(String string) {
        return false;
    }

    public boolean isEntityUnparsed(String string) {
        Entity entity;
        if (this.fEntities != null && (entity = (Entity)this.fEntities.getNamedItem(string)) != null) {
            return entity.getNotationName() != null;
        }
        return false;
    }

    private void validate(Node node) {
        Node node2 = node;
        while (node != null) {
            this.beginNode(node);
            Node node3 = node.getFirstChild();
            while (node3 == null) {
                this.finishNode(node);
                if (node2 == node) break;
                node3 = node.getNextSibling();
                if (node3 != null || (node = node.getParentNode()) != null && node2 != node) continue;
                if (node != null) {
                    this.finishNode(node);
                }
                node3 = null;
                break;
            }
            node = node3;
        }
    }

    private void beginNode(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                this.fCurrentElement = node;
                this.fNamespaceContext.pushContext();
                this.fillQName(this.fElementQName, node);
                this.processAttributes(node.getAttributes());
                this.fSchemaValidator.startElement(this.fElementQName, (XMLAttributes)this.fAttributes, null);
                break;
            }
            case 3: {
                if (this.fDOMValidatorHandler != null) {
                    this.fDOMValidatorHandler.setIgnoringCharacters(true);
                    this.sendCharactersToValidator(node.getNodeValue());
                    this.fDOMValidatorHandler.setIgnoringCharacters(false);
                    this.fDOMValidatorHandler.characters((Text)node);
                    break;
                }
                this.sendCharactersToValidator(node.getNodeValue());
                break;
            }
            case 4: {
                if (this.fDOMValidatorHandler != null) {
                    this.fDOMValidatorHandler.setIgnoringCharacters(true);
                    this.fSchemaValidator.startCDATA(null);
                    this.sendCharactersToValidator(node.getNodeValue());
                    this.fSchemaValidator.endCDATA(null);
                    this.fDOMValidatorHandler.setIgnoringCharacters(false);
                    this.fDOMValidatorHandler.cdata((CDATASection)node);
                    break;
                }
                this.fSchemaValidator.startCDATA(null);
                this.sendCharactersToValidator(node.getNodeValue());
                this.fSchemaValidator.endCDATA(null);
                break;
            }
            case 7: {
                if (this.fDOMValidatorHandler == null) break;
                this.fDOMValidatorHandler.processingInstruction((ProcessingInstruction)node);
                break;
            }
            case 8: {
                if (this.fDOMValidatorHandler == null) break;
                this.fDOMValidatorHandler.comment((Comment)node);
                break;
            }
            case 10: {
                if (this.fDOMValidatorHandler == null) break;
                this.fDOMValidatorHandler.doctypeDecl((DocumentType)node);
                break;
            }
        }
    }

    private void finishNode(Node node) {
        if (node.getNodeType() == 1) {
            this.fCurrentElement = node;
            this.fillQName(this.fElementQName, node);
            this.fSchemaValidator.endElement(this.fElementQName, null);
            this.fNamespaceContext.popContext();
        }
    }

    private void setupEntityMap(Document document) {
        DocumentType documentType;
        if (document != null && (documentType = document.getDoctype()) != null) {
            this.fEntities = documentType.getEntities();
            return;
        }
        this.fEntities = null;
    }

    private void setupDOMResultHandler(DOMSource dOMSource, DOMResult dOMResult) throws SAXException {
        if (dOMResult == null) {
            this.fDOMValidatorHandler = null;
            this.fSchemaValidator.setDocumentHandler(null);
            return;
        }
        Node node = dOMResult.getNode();
        if (dOMSource.getNode() == node) {
            this.fDOMValidatorHandler = this.fDOMResultAugmentor;
            this.fDOMResultAugmentor.setDOMResult(dOMResult);
            this.fSchemaValidator.setDocumentHandler((XMLDocumentHandler)this.fDOMResultAugmentor);
            return;
        }
        if (dOMResult.getNode() == null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                dOMResult.setNode(documentBuilder.newDocument());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SAXException(parserConfigurationException);
            }
        }
        this.fDOMValidatorHandler = this.fDOMResultBuilder;
        this.fDOMResultBuilder.setDOMResult(dOMResult);
        this.fSchemaValidator.setDocumentHandler((XMLDocumentHandler)this.fDOMResultBuilder);
    }

    private void fillQName(QName qName, Node node) {
        String string = node.getPrefix();
        String string2 = node.getLocalName();
        String string3 = node.getNodeName();
        String string4 = node.getNamespaceURI();
        qName.prefix = string != null ? this.fSymbolTable.addSymbol(string) : XMLSymbols.EMPTY_STRING;
        qName.localpart = string2 != null ? this.fSymbolTable.addSymbol(string2) : XMLSymbols.EMPTY_STRING;
        qName.rawname = string3 != null ? this.fSymbolTable.addSymbol(string3) : XMLSymbols.EMPTY_STRING;
        qName.uri = string4 != null && string4.length() > 0 ? this.fSymbolTable.addSymbol(string4) : null;
    }

    private void processAttributes(NamedNodeMap namedNodeMap) {
        int n = namedNodeMap.getLength();
        this.fAttributes.removeAllAttributes();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            String string = attr.getValue();
            if (string == null) {
                string = XMLSymbols.EMPTY_STRING;
            }
            this.fillQName(this.fAttributeQName, (Node)attr);
            this.fAttributes.addAttributeNS(this.fAttributeQName, XMLSymbols.fCDATASymbol, string);
            this.fAttributes.setSpecified(n2, attr.getSpecified());
            if (this.fAttributeQName.uri == NamespaceContext.XMLNS_URI) {
                if (this.fAttributeQName.prefix == XMLSymbols.PREFIX_XMLNS) {
                    this.fNamespaceContext.declarePrefix(this.fAttributeQName.localpart, string.length() != 0 ? this.fSymbolTable.addSymbol(string) : null);
                } else {
                    this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, string.length() != 0 ? this.fSymbolTable.addSymbol(string) : null);
                }
            }
            ++n2;
        }
    }

    private void sendCharactersToValidator(String string) {
        if (string != null) {
            int n = string.length();
            int n2 = n & 0x3FF;
            if (n2 > 0) {
                string.getChars(0, n2, this.fCharBuffer, 0);
                this.fTempString.setValues(this.fCharBuffer, 0, n2);
                this.fSchemaValidator.characters(this.fTempString, null);
            }
            int n3 = n2;
            while (n3 < n) {
                string.getChars(n3, n3 += 1024, this.fCharBuffer, 0);
                this.fTempString.setValues(this.fCharBuffer, 0, 1024);
                this.fSchemaValidator.characters(this.fTempString, null);
            }
        }
    }

    Node getCurrentElement() {
        return this.fCurrentElement;
    }

    static /* synthetic */ NamespaceSupport access$000(DOMValidatorHelper dOMValidatorHelper) {
        return dOMValidatorHelper.fNamespaceContext;
    }

    static /* synthetic */ Node access$100(DOMValidatorHelper dOMValidatorHelper) {
        return dOMValidatorHelper.fRoot;
    }

    static /* synthetic */ void access$200(DOMValidatorHelper dOMValidatorHelper, QName qName, Node node) {
        dOMValidatorHelper.fillQName(qName, node);
    }

    static /* synthetic */ SymbolTable access$300(DOMValidatorHelper dOMValidatorHelper) {
        return dOMValidatorHelper.fSymbolTable;
    }
}

