/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.validation.Schema;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.jaxp.DefaultValidationErrorHandler;
import org.apache.xerces.jaxp.JAXPConstants;
import org.apache.xerces.jaxp.JAXPValidatorComponent;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xerces.jaxp.SAXParserImpl;
import org.apache.xerces.jaxp.SchemaValidatorConfiguration;
import org.apache.xerces.jaxp.UnparsedEntityHandler;
import org.apache.xerces.jaxp.validation.XSGrammarPoolContainer;
import org.apache.xerces.util.SecurityManager;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLDTDSource;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xerces.xs.AttributePSVI;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.PSVIProvider;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SAXParserImpl
extends SAXParser
implements JAXPConstants,
PSVIProvider {
    private static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    private static final String XMLSCHEMA_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/schema";
    private static final String XINCLUDE_FEATURE = "http://apache.org/xml/features/xinclude";
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private JAXPSAXParser xmlReader = new JAXPSAXParser(this);
    private String schemaLanguage = null;
    private final Schema grammar;
    private XMLComponent fSchemaValidator;
    private XMLComponentManager fSchemaValidatorComponentManager;
    private ValidationManager fSchemaValidationManager;
    private final ErrorHandler fInitErrorHandler;
    private final EntityResolver fInitEntityResolver;

    SAXParserImpl(SAXParserFactoryImpl sAXParserFactoryImpl, Hashtable hashtable) throws SAXException {
        this(sAXParserFactoryImpl, hashtable, false);
    }

    SAXParserImpl(SAXParserFactoryImpl sAXParserFactoryImpl, Hashtable hashtable, boolean bl) throws SAXException {
        this.xmlReader.setFeature0(NAMESPACES_FEATURE, sAXParserFactoryImpl.isNamespaceAware());
        this.xmlReader.setFeature0(NAMESPACE_PREFIXES_FEATURE, !sAXParserFactoryImpl.isNamespaceAware());
        if (sAXParserFactoryImpl.isXIncludeAware()) {
            this.xmlReader.setFeature0(XINCLUDE_FEATURE, true);
        }
        if (bl) {
            this.xmlReader.setProperty0(SECURITY_MANAGER, (Object)new SecurityManager());
        }
        this.setFeatures(hashtable);
        if (sAXParserFactoryImpl.isValidating()) {
            this.fInitErrorHandler = new DefaultValidationErrorHandler();
            this.xmlReader.setErrorHandler(this.fInitErrorHandler);
        } else {
            this.fInitErrorHandler = this.xmlReader.getErrorHandler();
        }
        this.xmlReader.setFeature0(VALIDATION_FEATURE, sAXParserFactoryImpl.isValidating());
        this.grammar = sAXParserFactoryImpl.getSchema();
        if (this.grammar != null) {
            XMLParserConfiguration xMLParserConfiguration = this.xmlReader.getXMLParserConfiguration();
            XMLSchemaValidator xMLSchemaValidator = null;
            if (this.grammar instanceof XSGrammarPoolContainer) {
                xMLSchemaValidator = new XMLSchemaValidator();
                this.fSchemaValidationManager = new ValidationManager();
                UnparsedEntityHandler unparsedEntityHandler = new UnparsedEntityHandler(this.fSchemaValidationManager);
                xMLParserConfiguration.setDTDHandler((XMLDTDHandler)unparsedEntityHandler);
                unparsedEntityHandler.setDTDHandler((XMLDTDHandler)this.xmlReader);
                this.xmlReader.setDTDSource((XMLDTDSource)unparsedEntityHandler);
                this.fSchemaValidatorComponentManager = new SchemaValidatorConfiguration((XMLComponentManager)xMLParserConfiguration, (XSGrammarPoolContainer)this.grammar, this.fSchemaValidationManager);
            } else {
                xMLSchemaValidator = new JAXPValidatorComponent(this.grammar.newValidatorHandler());
                this.fSchemaValidatorComponentManager = xMLParserConfiguration;
            }
            xMLParserConfiguration.addRecognizedFeatures(xMLSchemaValidator.getRecognizedFeatures());
            xMLParserConfiguration.addRecognizedProperties(xMLSchemaValidator.getRecognizedProperties());
            xMLParserConfiguration.setDocumentHandler((XMLDocumentHandler)xMLSchemaValidator);
            ((XMLDocumentSource)xMLSchemaValidator).setDocumentHandler((XMLDocumentHandler)this.xmlReader);
            this.xmlReader.setDocumentSource((XMLDocumentSource)xMLSchemaValidator);
            this.fSchemaValidator = xMLSchemaValidator;
        }
        this.fInitEntityResolver = this.xmlReader.getEntityResolver();
    }

    private void setFeatures(Hashtable hashtable) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl = (Boolean)hashtable.get(string);
                this.xmlReader.setFeature0(string, bl);
            }
        }
    }

    public Parser getParser() throws SAXException {
        return this.xmlReader;
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public boolean isNamespaceAware() {
        try {
            return this.xmlReader.getFeature(NAMESPACES_FEATURE);
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    public boolean isValidating() {
        try {
            return this.xmlReader.getFeature(VALIDATION_FEATURE);
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    public boolean isXIncludeAware() {
        try {
            return this.xmlReader.getFeature(XINCLUDE_FEATURE);
        }
        catch (SAXException sAXException) {
            return false;
        }
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.xmlReader.setProperty(string, object);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.xmlReader.getProperty(string);
    }

    public void parse(InputSource inputSource, DefaultHandler defaultHandler) throws SAXException, IOException {
        if (inputSource == null) {
            throw new IllegalArgumentException();
        }
        if (defaultHandler != null) {
            this.xmlReader.setContentHandler((ContentHandler)defaultHandler);
            this.xmlReader.setEntityResolver((EntityResolver)defaultHandler);
            this.xmlReader.setErrorHandler((ErrorHandler)defaultHandler);
            this.xmlReader.setDTDHandler((DTDHandler)defaultHandler);
            this.xmlReader.setDocumentHandler(null);
        }
        this.xmlReader.parse(inputSource);
    }

    public void parse(InputSource inputSource, HandlerBase handlerBase) throws SAXException, IOException {
        if (inputSource == null) {
            throw new IllegalArgumentException();
        }
        if (handlerBase != null) {
            this.xmlReader.setDocumentHandler((DocumentHandler)handlerBase);
            this.xmlReader.setEntityResolver((EntityResolver)handlerBase);
            this.xmlReader.setErrorHandler((ErrorHandler)handlerBase);
            this.xmlReader.setDTDHandler((DTDHandler)handlerBase);
            this.xmlReader.setContentHandler(null);
        }
        this.xmlReader.parse(inputSource);
    }

    public Schema getSchema() {
        return this.grammar;
    }

    public void reset() {
        try {
            this.xmlReader.restoreInitState();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        this.xmlReader.setContentHandler(null);
        this.xmlReader.setDTDHandler(null);
        if (this.xmlReader.getErrorHandler() != this.fInitErrorHandler) {
            this.xmlReader.setErrorHandler(this.fInitErrorHandler);
        }
        if (this.xmlReader.getEntityResolver() != this.fInitEntityResolver) {
            this.xmlReader.setEntityResolver(this.fInitEntityResolver);
        }
    }

    public ElementPSVI getElementPSVI() {
        return this.xmlReader.getElementPSVI();
    }

    public AttributePSVI getAttributePSVI(int n) {
        return this.xmlReader.getAttributePSVI(n);
    }

    public AttributePSVI getAttributePSVIByName(String string, String string2) {
        return this.xmlReader.getAttributePSVIByName(string, string2);
    }

    static /* synthetic */ XMLComponent access$000(SAXParserImpl sAXParserImpl) {
        return sAXParserImpl.fSchemaValidator;
    }

    static /* synthetic */ Schema access$100(SAXParserImpl sAXParserImpl) {
        return sAXParserImpl.grammar;
    }

    static /* synthetic */ String access$202(SAXParserImpl sAXParserImpl, String string) {
        sAXParserImpl.schemaLanguage = string;
        return sAXParserImpl.schemaLanguage;
    }

    static /* synthetic */ String access$200(SAXParserImpl sAXParserImpl) {
        return sAXParserImpl.schemaLanguage;
    }

    static /* synthetic */ ValidationManager access$300(SAXParserImpl sAXParserImpl) {
        return sAXParserImpl.fSchemaValidationManager;
    }

    static /* synthetic */ XMLComponentManager access$400(SAXParserImpl sAXParserImpl) {
        return sAXParserImpl.fSchemaValidatorComponentManager;
    }
}

