/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.jaxp.JAXPValidatorComponent;
import org.apache.xerces.jaxp.TeeXMLDocumentFilterImpl;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;

final class JAXPValidatorComponent
extends TeeXMLDocumentFilterImpl
implements XMLComponent {
    private static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private final ValidatorHandler validator;
    private final XNI2SAX xni2sax = new XNI2SAX(this, null);
    private final SAX2XNI sax2xni = new SAX2XNI(this, null);
    private final TypeInfoProvider typeInfoProvider;
    private Augmentations fCurrentAug;
    private XMLAttributes fCurrentAttributes;
    private SymbolTable fSymbolTable;
    private XMLErrorReporter fErrorReporter;
    private XMLEntityResolver fEntityResolver;
    private static final TypeInfoProvider noInfoProvider = new /* Unavailable Anonymous Inner Class!! */;

    public JAXPValidatorComponent(ValidatorHandler validatorHandler) {
        this.validator = validatorHandler;
        TypeInfoProvider typeInfoProvider = validatorHandler.getTypeInfoProvider();
        if (typeInfoProvider == null) {
            typeInfoProvider = noInfoProvider;
        }
        this.typeInfoProvider = typeInfoProvider;
        this.xni2sax.setContentHandler((ContentHandler)this.validator);
        this.validator.setContentHandler((ContentHandler)this.sax2xni);
        this.setSide((XMLDocumentHandler)this.xni2sax);
        this.validator.setErrorHandler((ErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.validator.setResourceResolver((LSResourceResolver)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.fCurrentAttributes = xMLAttributes;
        this.fCurrentAug = augmentations;
        this.xni2sax.startElement(qName, xMLAttributes, null);
        this.fCurrentAttributes = null;
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        this.fCurrentAug = augmentations;
        this.xni2sax.endElement(qName, null);
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.startElement(qName, xMLAttributes, augmentations);
        this.endElement(qName, augmentations);
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.fCurrentAug = augmentations;
        this.xni2sax.characters(xMLString, null);
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.fCurrentAug = augmentations;
        this.xni2sax.ignorableWhitespace(xMLString, null);
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        try {
            this.fEntityResolver = (XMLEntityResolver)xMLComponentManager.getProperty(ENTITY_MANAGER);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fEntityResolver = null;
        }
    }

    private void updateAttributes(Attributes attributes) {
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            String string = attributes.getQName(n2);
            int n3 = this.fCurrentAttributes.getIndex(string);
            String string2 = attributes.getValue(n2);
            if (n3 == -1) {
                int n4 = string.indexOf(58);
                String string3 = n4 < 0 ? null : this.symbolize(string.substring(0, n4));
                n3 = this.fCurrentAttributes.addAttribute(new QName(string3, this.symbolize(attributes.getLocalName(n2)), this.symbolize(string), this.symbolize(attributes.getURI(n2))), attributes.getType(n2), string2);
            } else if (!string2.equals(this.fCurrentAttributes.getValue(n3))) {
                this.fCurrentAttributes.setValue(n3, string2);
            }
            ++n2;
        }
    }

    private String symbolize(String string) {
        return this.fSymbolTable.addSymbol(string);
    }

    public String[] getRecognizedFeatures() {
        return null;
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return new String[]{ENTITY_MANAGER, ERROR_REPORTER, SYMBOL_TABLE};
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
    }

    public Boolean getFeatureDefault(String string) {
        return null;
    }

    public Object getPropertyDefault(String string) {
        return null;
    }

    static /* synthetic */ XMLErrorReporter access$200(JAXPValidatorComponent jAXPValidatorComponent) {
        return jAXPValidatorComponent.fErrorReporter;
    }

    static /* synthetic */ XMLEntityResolver access$300(JAXPValidatorComponent jAXPValidatorComponent) {
        return jAXPValidatorComponent.fEntityResolver;
    }

    static /* synthetic */ void access$400(JAXPValidatorComponent jAXPValidatorComponent, Attributes attributes) {
        jAXPValidatorComponent.updateAttributes(attributes);
    }

    static /* synthetic */ XMLAttributes access$500(JAXPValidatorComponent jAXPValidatorComponent) {
        return jAXPValidatorComponent.fCurrentAttributes;
    }

    static /* synthetic */ Augmentations access$600(JAXPValidatorComponent jAXPValidatorComponent) {
        return jAXPValidatorComponent.fCurrentAug;
    }

    static /* synthetic */ Augmentations access$602(JAXPValidatorComponent jAXPValidatorComponent, Augmentations augmentations) {
        jAXPValidatorComponent.fCurrentAug = augmentations;
        return jAXPValidatorComponent.fCurrentAug;
    }

    static /* synthetic */ String access$700(JAXPValidatorComponent jAXPValidatorComponent, String string) {
        return jAXPValidatorComponent.symbolize(string);
    }
}

