/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NodeIteratorImpl;
import org.apache.xerces.dom.RangeImpl;
import org.apache.xerces.dom.TreeWalkerImpl;
import org.apache.xerces.dom.events.EventImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class DocumentImpl
extends CoreDocumentImpl
implements DocumentTraversal,
DocumentEvent,
DocumentRange {
    static final long serialVersionUID = 515687835542616694L;
    protected Vector iterators;
    protected Vector ranges;
    protected Hashtable eventListeners;
    protected boolean mutationEvents = false;
    EnclosingAttr savedEnclosingAttr;

    public DocumentImpl() {
    }

    public DocumentImpl(boolean bl) {
        super(bl);
    }

    public DocumentImpl(DocumentType documentType) {
        super(documentType);
    }

    public DocumentImpl(DocumentType documentType, boolean bl) {
        super(documentType, bl);
    }

    public Node cloneNode(boolean bl) {
        DocumentImpl documentImpl = new DocumentImpl();
        this.callUserDataHandlers((Node)this, (Node)documentImpl, (short)1);
        this.cloneNode((CoreDocumentImpl)documentImpl, bl);
        documentImpl.mutationEvents = this.mutationEvents;
        return documentImpl;
    }

    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public NodeIterator createNodeIterator(Node node, short s, NodeFilter nodeFilter) {
        return this.createNodeIterator(node, (int)s, nodeFilter, true);
    }

    public NodeIterator createNodeIterator(Node node, int n, NodeFilter nodeFilter, boolean bl) {
        if (node == null) {
            String string = DOMMessageFormatter.formatMessage((String)"http://www.w3.org/dom/DOMTR", (String)"NOT_SUPPORTED_ERR", null);
            throw new DOMException(9, string);
        }
        NodeIteratorImpl nodeIteratorImpl = new NodeIteratorImpl(this, node, n, nodeFilter, bl);
        if (this.iterators == null) {
            this.iterators = new Vector();
        }
        this.iterators.addElement(nodeIteratorImpl);
        return nodeIteratorImpl;
    }

    public TreeWalker createTreeWalker(Node node, short s, NodeFilter nodeFilter) {
        return this.createTreeWalker(node, (int)s, nodeFilter, true);
    }

    public TreeWalker createTreeWalker(Node node, int n, NodeFilter nodeFilter, boolean bl) {
        if (node == null) {
            String string = DOMMessageFormatter.formatMessage((String)"http://www.w3.org/dom/DOMTR", (String)"NOT_SUPPORTED_ERR", null);
            throw new DOMException(9, string);
        }
        return new TreeWalkerImpl(node, n, nodeFilter, bl);
    }

    void removeNodeIterator(NodeIterator nodeIterator) {
        if (nodeIterator == null) {
            return;
        }
        if (this.iterators == null) {
            return;
        }
        this.iterators.removeElement(nodeIterator);
    }

    public Range createRange() {
        if (this.ranges == null) {
            this.ranges = new Vector();
        }
        RangeImpl rangeImpl = new RangeImpl(this);
        this.ranges.addElement(rangeImpl);
        return rangeImpl;
    }

    void removeRange(Range range) {
        if (range == null) {
            return;
        }
        if (this.ranges == null) {
            return;
        }
        this.ranges.removeElement(range);
    }

    void replacedText(NodeImpl nodeImpl) {
        if (this.ranges != null) {
            this.notifyRangesReplacedText(nodeImpl);
        }
    }

    private void notifyRangesReplacedText(NodeImpl nodeImpl) {
        int n = this.ranges.size();
        int n2 = 0;
        while (n2 != n) {
            ((RangeImpl)this.ranges.elementAt(n2)).receiveReplacedText((Node)nodeImpl);
            ++n2;
        }
    }

    void deletedText(NodeImpl nodeImpl, int n, int n2) {
        if (this.ranges != null) {
            this.notifyRangesDeletedText(nodeImpl, n, n2);
        }
    }

    private void notifyRangesDeletedText(NodeImpl nodeImpl, int n, int n2) {
        int n3 = this.ranges.size();
        int n4 = 0;
        while (n4 != n3) {
            ((RangeImpl)this.ranges.elementAt(n4)).receiveDeletedText((Node)nodeImpl, n, n2);
            ++n4;
        }
    }

    void insertedText(NodeImpl nodeImpl, int n, int n2) {
        if (this.ranges != null) {
            this.notifyRangesInsertedText(nodeImpl, n, n2);
        }
    }

    private void notifyRangesInsertedText(NodeImpl nodeImpl, int n, int n2) {
        int n3 = this.ranges.size();
        int n4 = 0;
        while (n4 != n3) {
            ((RangeImpl)this.ranges.elementAt(n4)).receiveInsertedText((Node)nodeImpl, n, n2);
            ++n4;
        }
    }

    void splitData(Node node, Node node2, int n) {
        if (this.ranges != null) {
            this.notifyRangesSplitData(node, node2, n);
        }
    }

    private void notifyRangesSplitData(Node node, Node node2, int n) {
        int n2 = this.ranges.size();
        int n3 = 0;
        while (n3 != n2) {
            ((RangeImpl)this.ranges.elementAt(n3)).receiveSplitData(node, node2, n);
            ++n3;
        }
    }

    public Event createEvent(String string) throws DOMException {
        if (string.equalsIgnoreCase("Events") || "Event".equals(string)) {
            return new EventImpl();
        }
        if (string.equalsIgnoreCase("MutationEvents") || "MutationEvent".equals(string)) {
            return new MutationEventImpl();
        }
        String string2 = DOMMessageFormatter.formatMessage((String)"http://www.w3.org/dom/DOMTR", (String)"NOT_SUPPORTED_ERR", null);
        throw new DOMException(9, string2);
    }

    void setMutationEvents(boolean bl) {
        this.mutationEvents = bl;
    }

    boolean getMutationEvents() {
        return this.mutationEvents;
    }

    protected void setEventListeners(NodeImpl nodeImpl, Vector vector) {
        if (this.eventListeners == null) {
            this.eventListeners = new Hashtable();
        }
        if (vector == null) {
            this.eventListeners.remove(nodeImpl);
            if (this.eventListeners.isEmpty()) {
                this.mutationEvents = false;
            }
        } else {
            this.eventListeners.put(nodeImpl, vector);
            this.mutationEvents = true;
        }
    }

    protected Vector getEventListeners(NodeImpl nodeImpl) {
        if (this.eventListeners == null) {
            return null;
        }
        return (Vector)this.eventListeners.get(nodeImpl);
    }

    protected void addEventListener(NodeImpl nodeImpl, String string, EventListener eventListener, boolean bl) {
        if (string == null || string.equals("") || eventListener == null) {
            return;
        }
        this.removeEventListener(nodeImpl, string, eventListener, bl);
        Vector<LEntry> vector = this.getEventListeners(nodeImpl);
        if (vector == null) {
            vector = new Vector<LEntry>();
            this.setEventListeners(nodeImpl, vector);
        }
        vector.addElement(new LEntry(this, string, eventListener, bl));
        LCount lCount = LCount.lookup((String)string);
        if (bl) {
            ++lCount.captures;
            ++lCount.total;
        } else {
            ++lCount.bubbles;
            ++lCount.total;
        }
    }

    protected void removeEventListener(NodeImpl nodeImpl, String string, EventListener eventListener, boolean bl) {
        if (string == null || string.equals("") || eventListener == null) {
            return;
        }
        Vector vector = this.getEventListeners(nodeImpl);
        if (vector == null) {
            return;
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            LEntry lEntry = (LEntry)vector.elementAt(n);
            if (lEntry.useCapture == bl && lEntry.listener == eventListener && lEntry.type.equals(string)) {
                vector.removeElementAt(n);
                if (vector.size() == 0) {
                    this.setEventListeners(nodeImpl, null);
                }
                LCount lCount = LCount.lookup((String)string);
                if (bl) {
                    --lCount.captures;
                    --lCount.total;
                    break;
                }
                --lCount.bubbles;
                --lCount.total;
                break;
            }
            --n;
        }
    }

    protected void copyEventListeners(NodeImpl nodeImpl, NodeImpl nodeImpl2) {
        Vector vector = this.getEventListeners(nodeImpl);
        if (vector == null) {
            return;
        }
        this.setEventListeners(nodeImpl2, (Vector)vector.clone());
    }

    protected boolean dispatchEvent(NodeImpl nodeImpl, Event event) {
        Vector vector;
        Object object;
        if (event == null) {
            return false;
        }
        EventImpl eventImpl = (EventImpl)event;
        if (!eventImpl.initialized || eventImpl.type == null || eventImpl.type.equals("")) {
            String string = DOMMessageFormatter.formatMessage((String)"http://www.w3.org/dom/DOMTR", (String)"UNSPECIFIED_EVENT_TYPE_ERR", null);
            throw new EventException(0, string);
        }
        LCount lCount = LCount.lookup((String)eventImpl.getType());
        if (lCount.total == 0) {
            return eventImpl.preventDefault;
        }
        eventImpl.target = nodeImpl;
        eventImpl.stopPropagation = false;
        eventImpl.preventDefault = false;
        ArrayList<Node> arrayList = new ArrayList<Node>(10);
        Object object2 = nodeImpl;
        Node node = object2.getParentNode();
        while (node != null) {
            arrayList.add(node);
            object2 = node;
            node = node.getParentNode();
        }
        if (lCount.captures > 0) {
            eventImpl.eventPhase = 1;
            int n = arrayList.size() - 1;
            while (n >= 0) {
                if (eventImpl.stopPropagation) break;
                object = (NodeImpl)arrayList.get(n);
                eventImpl.currentTarget = object;
                Vector vector2 = this.getEventListeners((NodeImpl)object);
                if (vector2 != null) {
                    vector = (Vector)vector2.clone();
                    int n2 = vector.size();
                    int n3 = 0;
                    while (n3 < n2) {
                        LEntry lEntry = (LEntry)vector.elementAt(n3);
                        if (lEntry.useCapture && lEntry.type.equals(eventImpl.type) && vector2.contains(lEntry)) {
                            try {
                                lEntry.listener.handleEvent((Event)eventImpl);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ++n3;
                    }
                }
                --n;
            }
        }
        if (lCount.bubbles > 0) {
            eventImpl.eventPhase = (short)2;
            eventImpl.currentTarget = nodeImpl;
            Vector vector3 = this.getEventListeners(nodeImpl);
            if (!eventImpl.stopPropagation && vector3 != null) {
                object = (Vector)vector3.clone();
                int n = ((Vector)object).size();
                int n4 = 0;
                while (n4 < n) {
                    LEntry lEntry = (LEntry)((Vector)object).elementAt(n4);
                    if (!lEntry.useCapture && lEntry.type.equals(eventImpl.type) && vector3.contains(lEntry)) {
                        try {
                            lEntry.listener.handleEvent((Event)eventImpl);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++n4;
                }
            }
            if (eventImpl.bubbles) {
                eventImpl.eventPhase = (short)3;
                int n = arrayList.size();
                int n5 = 0;
                while (n5 < n) {
                    if (eventImpl.stopPropagation) break;
                    vector = (NodeImpl)arrayList.get(n5);
                    eventImpl.currentTarget = vector;
                    vector3 = this.getEventListeners((NodeImpl)vector);
                    if (vector3 != null) {
                        Vector vector4 = (Vector)vector3.clone();
                        int n6 = vector4.size();
                        int n7 = 0;
                        while (n7 < n6) {
                            LEntry lEntry = (LEntry)vector4.elementAt(n7);
                            if (!lEntry.useCapture && lEntry.type.equals(eventImpl.type) && vector3.contains(lEntry)) {
                                try {
                                    lEntry.listener.handleEvent((Event)eventImpl);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            ++n7;
                        }
                    }
                    ++n5;
                }
            }
        }
        if (lCount.defaults <= 0 || !eventImpl.cancelable || !eventImpl.preventDefault) {
            // empty if block
        }
        return eventImpl.preventDefault;
    }

    protected void dispatchEventToSubtree(Node node, Event event) {
        ((NodeImpl)node).dispatchEvent(event);
        if (node.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength() - 1;
            while (n >= 0) {
                this.dispatchingEventToSubtree(namedNodeMap.item(n), event);
                --n;
            }
        }
        this.dispatchingEventToSubtree(node.getFirstChild(), event);
    }

    protected void dispatchingEventToSubtree(Node node, Event event) {
        if (node == null) {
            return;
        }
        ((NodeImpl)node).dispatchEvent(event);
        if (node.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength() - 1;
            while (n >= 0) {
                this.dispatchingEventToSubtree(namedNodeMap.item(n), event);
                --n;
            }
        }
        this.dispatchingEventToSubtree(node.getFirstChild(), event);
        this.dispatchingEventToSubtree(node.getNextSibling(), event);
    }

    protected void dispatchAggregateEvents(NodeImpl nodeImpl, EnclosingAttr enclosingAttr) {
        if (enclosingAttr != null) {
            this.dispatchAggregateEvents(nodeImpl, enclosingAttr.node, enclosingAttr.oldvalue, (short)1);
        } else {
            this.dispatchAggregateEvents(nodeImpl, null, null, (short)0);
        }
    }

    protected void dispatchAggregateEvents(NodeImpl nodeImpl, AttrImpl attrImpl, String string, short s) {
        MutationEventImpl mutationEventImpl;
        LCount lCount;
        NodeImpl nodeImpl2 = null;
        if (attrImpl != null) {
            lCount = LCount.lookup((String)"DOMAttrModified");
            nodeImpl2 = (NodeImpl)attrImpl.getOwnerElement();
            if (lCount.total > 0 && nodeImpl2 != null) {
                mutationEventImpl = new MutationEventImpl();
                mutationEventImpl.initMutationEvent("DOMAttrModified", true, false, (Node)attrImpl, string, attrImpl.getNodeValue(), attrImpl.getNodeName(), s);
                nodeImpl2.dispatchEvent((Event)mutationEventImpl);
            }
        }
        lCount = LCount.lookup((String)"DOMSubtreeModified");
        if (lCount.total > 0) {
            mutationEventImpl = new MutationEventImpl();
            mutationEventImpl.initMutationEvent("DOMSubtreeModified", true, false, null, null, null, null, (short)0);
            if (attrImpl != null) {
                this.dispatchEvent((NodeImpl)attrImpl, (Event)mutationEventImpl);
                if (nodeImpl2 != null) {
                    this.dispatchEvent(nodeImpl2, (Event)mutationEventImpl);
                }
            } else {
                this.dispatchEvent(nodeImpl, (Event)mutationEventImpl);
            }
        }
    }

    protected void saveEnclosingAttr(NodeImpl nodeImpl) {
        this.savedEnclosingAttr = null;
        LCount lCount = LCount.lookup((String)"DOMAttrModified");
        if (lCount.total > 0) {
            NodeImpl nodeImpl2 = nodeImpl;
            while (true) {
                if (nodeImpl2 == null) {
                    return;
                }
                short s = nodeImpl2.getNodeType();
                if (s == 2) {
                    EnclosingAttr enclosingAttr = new EnclosingAttr(this);
                    enclosingAttr.node = (AttrImpl)nodeImpl2;
                    enclosingAttr.oldvalue = enclosingAttr.node.getNodeValue();
                    this.savedEnclosingAttr = enclosingAttr;
                    return;
                }
                if (s == 5) {
                    nodeImpl2 = nodeImpl2.parentNode();
                    continue;
                }
                if (s != 3) break;
                nodeImpl2 = nodeImpl2.parentNode();
            }
            return;
        }
    }

    void modifyingCharacterData(NodeImpl nodeImpl, boolean bl) {
        if (this.mutationEvents && !bl) {
            this.saveEnclosingAttr(nodeImpl);
        }
    }

    void modifiedCharacterData(NodeImpl nodeImpl, String string, String string2, boolean bl) {
        if (this.mutationEvents) {
            this.mutationEventsModifiedCharacterData(nodeImpl, string, string2, bl);
        }
    }

    private void mutationEventsModifiedCharacterData(NodeImpl nodeImpl, String string, String string2, boolean bl) {
        if (!bl) {
            LCount lCount = LCount.lookup((String)"DOMCharacterDataModified");
            if (lCount.total > 0) {
                MutationEventImpl mutationEventImpl = new MutationEventImpl();
                mutationEventImpl.initMutationEvent("DOMCharacterDataModified", true, false, null, string, string2, null, (short)0);
                this.dispatchEvent(nodeImpl, (Event)mutationEventImpl);
            }
            this.dispatchAggregateEvents(nodeImpl, this.savedEnclosingAttr);
        }
    }

    void replacedCharacterData(NodeImpl nodeImpl, String string, String string2) {
        this.modifiedCharacterData(nodeImpl, string, string2, false);
    }

    void insertingNode(NodeImpl nodeImpl, boolean bl) {
        if (this.mutationEvents && !bl) {
            this.saveEnclosingAttr(nodeImpl);
        }
    }

    void insertedNode(NodeImpl nodeImpl, NodeImpl nodeImpl2, boolean bl) {
        if (this.mutationEvents) {
            this.mutationEventsInsertedNode(nodeImpl, nodeImpl2, bl);
        }
        if (this.ranges != null) {
            this.notifyRangesInsertedNode(nodeImpl2);
        }
    }

    private void mutationEventsInsertedNode(NodeImpl nodeImpl, NodeImpl nodeImpl2, boolean bl) {
        MutationEventImpl mutationEventImpl;
        LCount lCount = LCount.lookup((String)"DOMNodeInserted");
        if (lCount.total > 0) {
            mutationEventImpl = new MutationEventImpl();
            mutationEventImpl.initMutationEvent("DOMNodeInserted", true, false, (Node)nodeImpl, null, null, null, (short)0);
            this.dispatchEvent(nodeImpl2, (Event)mutationEventImpl);
        }
        lCount = LCount.lookup((String)"DOMNodeInsertedIntoDocument");
        if (lCount.total > 0) {
            mutationEventImpl = nodeImpl;
            if (this.savedEnclosingAttr != null) {
                mutationEventImpl = (NodeImpl)this.savedEnclosingAttr.node.getOwnerElement();
            }
            if (mutationEventImpl != null) {
                MutationEventImpl mutationEventImpl2 = mutationEventImpl;
                while (mutationEventImpl2 != null) {
                    mutationEventImpl = mutationEventImpl2;
                    mutationEventImpl2 = mutationEventImpl2.getNodeType() == 2 ? (NodeImpl)((AttrImpl)mutationEventImpl2).getOwnerElement() : mutationEventImpl2.parentNode();
                }
                if (mutationEventImpl.getNodeType() == 9) {
                    MutationEventImpl mutationEventImpl3 = new MutationEventImpl();
                    mutationEventImpl3.initMutationEvent("DOMNodeInsertedIntoDocument", false, false, null, null, null, null, (short)0);
                    this.dispatchEventToSubtree((Node)nodeImpl2, (Event)mutationEventImpl3);
                }
            }
        }
        if (!bl) {
            this.dispatchAggregateEvents(nodeImpl, this.savedEnclosingAttr);
        }
    }

    private void notifyRangesInsertedNode(NodeImpl nodeImpl) {
        int n = this.ranges.size();
        int n2 = 0;
        while (n2 != n) {
            ((RangeImpl)this.ranges.elementAt(n2)).insertedNodeFromDOM((Node)nodeImpl);
            ++n2;
        }
    }

    void removingNode(NodeImpl nodeImpl, NodeImpl nodeImpl2, boolean bl) {
        if (this.iterators != null) {
            this.notifyIteratorsRemovingNode(nodeImpl2);
        }
        if (this.ranges != null) {
            this.notifyRangesRemovingNode(nodeImpl2);
        }
        if (this.mutationEvents) {
            this.mutationEventsRemovingNode(nodeImpl, nodeImpl2, bl);
        }
    }

    private void notifyIteratorsRemovingNode(NodeImpl nodeImpl) {
        int n = this.iterators.size();
        int n2 = 0;
        while (n2 != n) {
            ((NodeIteratorImpl)this.iterators.elementAt(n2)).removeNode((Node)nodeImpl);
            ++n2;
        }
    }

    private void notifyRangesRemovingNode(NodeImpl nodeImpl) {
        int n = this.ranges.size();
        int n2 = 0;
        while (n2 != n) {
            ((RangeImpl)this.ranges.elementAt(n2)).removeNode((Node)nodeImpl);
            ++n2;
        }
    }

    private void mutationEventsRemovingNode(NodeImpl nodeImpl, NodeImpl nodeImpl2, boolean bl) {
        MutationEventImpl mutationEventImpl;
        if (!bl) {
            this.saveEnclosingAttr(nodeImpl);
        }
        LCount lCount = LCount.lookup((String)"DOMNodeRemoved");
        if (lCount.total > 0) {
            mutationEventImpl = new MutationEventImpl();
            mutationEventImpl.initMutationEvent("DOMNodeRemoved", true, false, (Node)nodeImpl, null, null, null, (short)0);
            this.dispatchEvent(nodeImpl2, (Event)mutationEventImpl);
        }
        lCount = LCount.lookup((String)"DOMNodeRemovedFromDocument");
        if (lCount.total > 0) {
            mutationEventImpl = this;
            if (this.savedEnclosingAttr != null) {
                mutationEventImpl = (NodeImpl)this.savedEnclosingAttr.node.getOwnerElement();
            }
            if (mutationEventImpl != null) {
                NodeImpl nodeImpl3 = mutationEventImpl.parentNode();
                while (nodeImpl3 != null) {
                    mutationEventImpl = nodeImpl3;
                    nodeImpl3 = nodeImpl3.parentNode();
                }
                if (mutationEventImpl.getNodeType() == 9) {
                    MutationEventImpl mutationEventImpl2 = new MutationEventImpl();
                    mutationEventImpl2.initMutationEvent("DOMNodeRemovedFromDocument", false, false, null, null, null, null, (short)0);
                    this.dispatchEventToSubtree((Node)nodeImpl2, (Event)mutationEventImpl2);
                }
            }
        }
    }

    void removedNode(NodeImpl nodeImpl, boolean bl) {
        if (this.mutationEvents && !bl) {
            this.dispatchAggregateEvents(nodeImpl, this.savedEnclosingAttr);
        }
    }

    void replacingNode(NodeImpl nodeImpl) {
        if (this.mutationEvents) {
            this.saveEnclosingAttr(nodeImpl);
        }
    }

    void replacingData(NodeImpl nodeImpl) {
        if (this.mutationEvents) {
            this.saveEnclosingAttr(nodeImpl);
        }
    }

    void replacedNode(NodeImpl nodeImpl) {
        if (this.mutationEvents) {
            this.dispatchAggregateEvents(nodeImpl, this.savedEnclosingAttr);
        }
    }

    void modifiedAttrValue(AttrImpl attrImpl, String string) {
        if (this.mutationEvents) {
            this.dispatchAggregateEvents((NodeImpl)attrImpl, attrImpl, string, (short)1);
        }
    }

    void setAttrNode(AttrImpl attrImpl, AttrImpl attrImpl2) {
        if (this.mutationEvents) {
            if (attrImpl2 == null) {
                this.dispatchAggregateEvents(attrImpl.ownerNode, attrImpl, null, (short)2);
            } else {
                this.dispatchAggregateEvents(attrImpl.ownerNode, attrImpl, attrImpl2.getNodeValue(), (short)1);
            }
        }
    }

    void removedAttrNode(AttrImpl attrImpl, NodeImpl nodeImpl, String string) {
        if (this.mutationEvents) {
            this.mutationEventsRemovedAttrNode(attrImpl, nodeImpl, string);
        }
    }

    private void mutationEventsRemovedAttrNode(AttrImpl attrImpl, NodeImpl nodeImpl, String string) {
        LCount lCount = LCount.lookup((String)"DOMAttrModified");
        if (lCount.total > 0) {
            MutationEventImpl mutationEventImpl = new MutationEventImpl();
            mutationEventImpl.initMutationEvent("DOMAttrModified", true, false, (Node)attrImpl, attrImpl.getNodeValue(), null, string, (short)3);
            this.dispatchEvent(nodeImpl, (Event)mutationEventImpl);
        }
        this.dispatchAggregateEvents(nodeImpl, null, null, (short)0);
    }

    void renamedAttrNode(Attr attr, Attr attr2) {
    }

    void renamedElement(Element element, Element element2) {
    }
}

