/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;
import org.apache.xpath.patterns.UnionPattern;

public class UnionPattern
extends Expression {
    static final long serialVersionUID = -6670449967116905820L;
    private StepPattern[] m_patterns;

    public void fixupVariables(Vector vars, int globalsSize) {
        int i = 0;
        while (i < this.m_patterns.length) {
            this.m_patterns[i].fixupVariables(vars, globalsSize);
            ++i;
        }
    }

    public boolean canTraverseOutsideSubtree() {
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            int i = 0;
            while (i < n) {
                if (this.m_patterns[i].canTraverseOutsideSubtree()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void setPatterns(StepPattern[] patterns) {
        this.m_patterns = patterns;
        if (null != patterns) {
            int i = 0;
            while (i < patterns.length) {
                patterns[i].exprSetParent((ExpressionNode)this);
                ++i;
            }
        }
    }

    public StepPattern[] getPatterns() {
        return this.m_patterns;
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        XNumber bestScore = null;
        int n = this.m_patterns.length;
        int i = 0;
        while (i < n) {
            XObject score = this.m_patterns[i].execute(xctxt);
            if (score != NodeTest.SCORE_NONE) {
                if (null == bestScore) {
                    bestScore = score;
                } else if (score.num() > bestScore.num()) {
                    bestScore = score;
                }
            }
            ++i;
        }
        if (null == bestScore) {
            bestScore = NodeTest.SCORE_NONE;
        }
        return bestScore;
    }

    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        visitor.visitUnionPattern(owner, this);
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            int i = 0;
            while (i < n) {
                this.m_patterns[i].callVisitors((ExpressionOwner)new UnionPathPartOwner(this, i), visitor);
                ++i;
            }
        }
    }

    public boolean deepEquals(Expression expr) {
        if (!this.isSameClass(expr)) {
            return false;
        }
        UnionPattern up = (UnionPattern)expr;
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            if (null == up.m_patterns || up.m_patterns.length != n) {
                return false;
            }
            int i = 0;
            while (i < n) {
                if (!this.m_patterns[i].deepEquals((Expression)up.m_patterns[i])) {
                    return false;
                }
                ++i;
            }
        } else if (up.m_patterns != null) {
            return false;
        }
        return true;
    }

    static /* synthetic */ StepPattern[] access$000(UnionPattern x0) {
        return x0.m_patterns;
    }
}

