/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;

public class StepPattern
extends NodeTest
implements SubContextList,
ExpressionOwner {
    static final long serialVersionUID = 9071668960168152644L;
    protected int m_axis;
    String m_targetString;
    StepPattern m_relativePathPattern;
    Expression[] m_predicates;
    private static final boolean DEBUG_MATCHES = false;

    public StepPattern(int whatToShow, String namespace, String name, int axis, int axisForPredicate) {
        super(whatToShow, namespace, name);
        this.m_axis = axis;
    }

    public StepPattern(int whatToShow, int axis, int axisForPredicate) {
        super(whatToShow);
        this.m_axis = axis;
    }

    public void calcTargetString() {
        int whatToShow = this.getWhatToShow();
        switch (whatToShow) {
            case 128: {
                this.m_targetString = "#comment";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                this.m_targetString = "#text";
                break;
            }
            case -1: {
                this.m_targetString = "*";
                break;
            }
            case 256: 
            case 1280: {
                this.m_targetString = "/";
                break;
            }
            case 1: {
                if ("*" == this.m_name) {
                    this.m_targetString = "*";
                    break;
                }
                this.m_targetString = this.m_name;
                break;
            }
            default: {
                this.m_targetString = "*";
            }
        }
    }

    public String getTargetString() {
        return this.m_targetString;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        super.fixupVariables(vars, globalsSize);
        if (null != this.m_predicates) {
            int i = 0;
            while (i < this.m_predicates.length) {
                this.m_predicates[i].fixupVariables(vars, globalsSize);
                ++i;
            }
        }
        if (null != this.m_relativePathPattern) {
            this.m_relativePathPattern.fixupVariables(vars, globalsSize);
        }
    }

    public void setRelativePathPattern(StepPattern expr) {
        this.m_relativePathPattern = expr;
        expr.exprSetParent((ExpressionNode)this);
        this.calcScore();
    }

    public StepPattern getRelativePathPattern() {
        return this.m_relativePathPattern;
    }

    public Expression[] getPredicates() {
        return this.m_predicates;
    }

    public boolean canTraverseOutsideSubtree() {
        int n = this.getPredicateCount();
        int i = 0;
        while (i < n) {
            if (this.getPredicate(i).canTraverseOutsideSubtree()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Expression getPredicate(int i) {
        return this.m_predicates[i];
    }

    public final int getPredicateCount() {
        return null == this.m_predicates ? 0 : this.m_predicates.length;
    }

    public void setPredicates(Expression[] predicates) {
        this.m_predicates = predicates;
        if (null != predicates) {
            int i = 0;
            while (i < predicates.length) {
                predicates[i].exprSetParent((ExpressionNode)this);
                ++i;
            }
        }
        this.calcScore();
    }

    public void calcScore() {
        if (this.getPredicateCount() > 0 || null != this.m_relativePathPattern) {
            this.m_score = NodeTest.SCORE_OTHER;
        } else {
            super.calcScore();
        }
        if (null == this.m_targetString) {
            this.calcTargetString();
        }
    }

    public XObject execute(XPathContext xctxt, int currentNode) throws TransformerException {
        DTM dtm = xctxt.getDTM(currentNode);
        if (dtm != null) {
            int expType = dtm.getExpandedTypeID(currentNode);
            return this.execute(xctxt, currentNode, dtm, expType);
        }
        return NodeTest.SCORE_NONE;
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        return this.execute(xctxt, xctxt.getCurrentNode());
    }

    public XObject execute(XPathContext xctxt, int currentNode, DTM dtm, int expType) throws TransformerException {
        if (this.m_whatToShow == 65536) {
            if (null != this.m_relativePathPattern) {
                return this.m_relativePathPattern.execute(xctxt);
            }
            return NodeTest.SCORE_NONE;
        }
        XObject score = super.execute(xctxt, currentNode, dtm, expType);
        if (score == NodeTest.SCORE_NONE) {
            return NodeTest.SCORE_NONE;
        }
        if (this.getPredicateCount() != 0 && !this.executePredicates(xctxt, dtm, currentNode)) {
            return NodeTest.SCORE_NONE;
        }
        if (null != this.m_relativePathPattern) {
            return this.m_relativePathPattern.executeRelativePathPattern(xctxt, dtm, currentNode);
        }
        return score;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean checkProximityPosition(XPathContext xctxt, int predPos, DTM dtm, int context, int pos) {
        try {
            DTMAxisTraverser traverser = dtm.getAxisTraverser(12);
            int child = traverser.first(context);
            while (-1 != child) {
                Object var18_15;
                block15: {
                    boolean bl;
                    try {
                        Object var16_14;
                        xctxt.pushCurrentNode(child);
                        if (NodeTest.SCORE_NONE == super.execute(xctxt, child)) break block15;
                        boolean pass = true;
                        try {
                            xctxt.pushSubContextList((SubContextList)this);
                            int i = 0;
                            while (true) {
                                Object var14_13;
                                block18: {
                                    block17: {
                                        if (i >= predPos) {
                                            break;
                                        }
                                        xctxt.pushPredicatePos(i);
                                        try {
                                            Object var12_12;
                                            XObject pred;
                                            block16: {
                                                pred = this.m_predicates[i].execute(xctxt);
                                                try {
                                                    if (2 == pred.getType()) {
                                                        throw new Error("Why: Should never have been called");
                                                    }
                                                    if (pred.boolWithSideEffects()) break block16;
                                                    pass = false;
                                                    var12_12 = null;
                                                }
                                                catch (Throwable throwable) {
                                                    var12_12 = null;
                                                    pred.detach();
                                                    throw throwable;
                                                }
                                                pred.detach();
                                                var14_13 = null;
                                                break block17;
                                            }
                                            var12_12 = null;
                                            pred.detach();
                                            break block18;
                                        }
                                        catch (Throwable throwable) {
                                            var14_13 = null;
                                            xctxt.popPredicatePos();
                                            throw throwable;
                                        }
                                    }
                                    xctxt.popPredicatePos();
                                    break;
                                }
                                var14_13 = null;
                                xctxt.popPredicatePos();
                                ++i;
                            }
                            var16_14 = null;
                        }
                        catch (Throwable throwable) {
                            var16_14 = null;
                            xctxt.popSubContextList();
                            throw throwable;
                        }
                        xctxt.popSubContextList();
                        if (pass) {
                            --pos;
                        }
                        if (pos >= 1) break block15;
                        bl = false;
                        var18_15 = null;
                    }
                    catch (Throwable throwable) {
                        var18_15 = null;
                        xctxt.popCurrentNode();
                        throw throwable;
                    }
                    xctxt.popCurrentNode();
                    return bl;
                }
                var18_15 = null;
                xctxt.popCurrentNode();
                child = traverser.next(context, child);
            }
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
        if (pos != 1) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int getProximityPosition(XPathContext xctxt, int predPos, boolean findLast) {
        int pos = 0;
        int context = xctxt.getCurrentNode();
        DTM dtm = xctxt.getDTM(context);
        int parent = dtm.getParent(context);
        try {
            DTMAxisTraverser traverser = dtm.getAxisTraverser(3);
            int child = traverser.first(parent);
            while (true) {
                Object var20_17;
                block16: {
                    int n;
                    if (-1 == child) {
                        return pos;
                    }
                    try {
                        Object var18_16;
                        xctxt.pushCurrentNode(child);
                        if (NodeTest.SCORE_NONE == super.execute(xctxt, child)) break block16;
                        boolean pass = true;
                        try {
                            xctxt.pushSubContextList((SubContextList)this);
                            int i = 0;
                            while (true) {
                                Object var16_15;
                                block22: {
                                    block21: {
                                        block20: {
                                            if (i >= predPos) {
                                                break;
                                            }
                                            xctxt.pushPredicatePos(i);
                                            try {
                                                Object var14_14;
                                                XObject pred;
                                                block17: {
                                                    block19: {
                                                        block18: {
                                                            pred = this.m_predicates[i].execute(xctxt);
                                                            try {
                                                                if (2 == pred.getType()) {
                                                                    if (pos + 1 == (int)pred.numWithSideEffects()) break block17;
                                                                    pass = false;
                                                                    var14_14 = null;
                                                                    break block18;
                                                                }
                                                                if (pred.boolWithSideEffects()) break block17;
                                                                pass = false;
                                                                break block19;
                                                            }
                                                            catch (Throwable throwable) {
                                                                var14_14 = null;
                                                                pred.detach();
                                                                throw throwable;
                                                            }
                                                        }
                                                        pred.detach();
                                                        var16_15 = null;
                                                        break block20;
                                                    }
                                                    var14_14 = null;
                                                    pred.detach();
                                                    break block21;
                                                }
                                                var14_14 = null;
                                                pred.detach();
                                                break block22;
                                            }
                                            catch (Throwable throwable) {
                                                var16_15 = null;
                                                xctxt.popPredicatePos();
                                                throw throwable;
                                            }
                                        }
                                        xctxt.popPredicatePos();
                                        break;
                                    }
                                    var16_15 = null;
                                    xctxt.popPredicatePos();
                                    break;
                                }
                                var16_15 = null;
                                xctxt.popPredicatePos();
                                ++i;
                            }
                            var18_16 = null;
                        }
                        catch (Throwable throwable) {
                            var18_16 = null;
                            xctxt.popSubContextList();
                            throw throwable;
                        }
                        xctxt.popSubContextList();
                        if (pass) {
                            ++pos;
                        }
                        if (findLast || child != context) break block16;
                        n = pos;
                        var20_17 = null;
                    }
                    catch (Throwable throwable) {
                        var20_17 = null;
                        xctxt.popCurrentNode();
                        throw throwable;
                    }
                    xctxt.popCurrentNode();
                    return n;
                }
                var20_17 = null;
                xctxt.popCurrentNode();
                child = traverser.next(parent, child);
            }
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    public int getProximityPosition(XPathContext xctxt) {
        return this.getProximityPosition(xctxt, xctxt.getPredicatePos(), false);
    }

    public int getLastPos(XPathContext xctxt) {
        return this.getProximityPosition(xctxt, xctxt.getPredicatePos(), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final XObject executeRelativePathPattern(XPathContext xctxt, DTM dtm, int currentNode) throws TransformerException {
        XNumber score = NodeTest.SCORE_NONE;
        int context = currentNode;
        DTMAxisTraverser traverser = dtm.getAxisTraverser(this.m_axis);
        int relative = traverser.first(context);
        while (true) {
            Object var9_8;
            block4: {
                if (-1 == relative) {
                    return score;
                }
                try {
                    xctxt.pushCurrentNode(relative);
                    score = this.execute(xctxt);
                    if (score == NodeTest.SCORE_NONE) break block4;
                    var9_8 = null;
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    xctxt.popCurrentNode();
                    throw throwable;
                }
                xctxt.popCurrentNode();
                return score;
            }
            var9_8 = null;
            xctxt.popCurrentNode();
            relative = traverser.next(context, relative);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean executePredicates(XPathContext xctxt, DTM dtm, int currentNode) throws TransformerException {
        boolean result = true;
        boolean positionAlreadySeen = false;
        int n = this.getPredicateCount();
        try {
            xctxt.pushSubContextList((SubContextList)this);
            int i = 0;
            while (true) {
                Object var13_11;
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                if (i >= n) {
                                    break;
                                }
                                xctxt.pushPredicatePos(i);
                                try {
                                    Object var11_10;
                                    XObject pred;
                                    block11: {
                                        block13: {
                                            block12: {
                                                block10: {
                                                    pred = this.m_predicates[i].execute(xctxt);
                                                    try {
                                                        if (2 == pred.getType()) {
                                                            int pos = (int)pred.num();
                                                            if (positionAlreadySeen) {
                                                                result = pos == 1;
                                                                var11_10 = null;
                                                                break block10;
                                                            }
                                                            positionAlreadySeen = true;
                                                            if (this.checkProximityPosition(xctxt, i, dtm, currentNode, pos)) break block11;
                                                            result = false;
                                                            break block12;
                                                        }
                                                        if (pred.boolWithSideEffects()) break block11;
                                                        result = false;
                                                        break block13;
                                                    }
                                                    catch (Throwable throwable) {
                                                        var11_10 = null;
                                                        pred.detach();
                                                        throw throwable;
                                                    }
                                                }
                                                pred.detach();
                                                var13_11 = null;
                                                break block14;
                                            }
                                            var11_10 = null;
                                            pred.detach();
                                            break block15;
                                        }
                                        var11_10 = null;
                                        pred.detach();
                                        break block16;
                                    }
                                    var11_10 = null;
                                    pred.detach();
                                    break block17;
                                }
                                catch (Throwable throwable) {
                                    var13_11 = null;
                                    xctxt.popPredicatePos();
                                    throw throwable;
                                }
                            }
                            xctxt.popPredicatePos();
                            break;
                        }
                        var13_11 = null;
                        xctxt.popPredicatePos();
                        break;
                    }
                    var13_11 = null;
                    xctxt.popPredicatePos();
                    break;
                }
                var13_11 = null;
                xctxt.popPredicatePos();
                ++i;
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            xctxt.popSubContextList();
            throw throwable;
        }
        xctxt.popSubContextList();
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        StepPattern pat = this;
        while (pat != null) {
            if (pat != this) {
                buf.append("/");
            }
            buf.append(Axis.getNames((int)pat.m_axis));
            buf.append("::");
            if (20480 == pat.m_whatToShow) {
                buf.append("doc()");
            } else if (65536 == pat.m_whatToShow) {
                buf.append("function()");
            } else if (-1 == pat.m_whatToShow) {
                buf.append("node()");
            } else if (4 == pat.m_whatToShow) {
                buf.append("text()");
            } else if (64 == pat.m_whatToShow) {
                buf.append("processing-instruction(");
                if (null != pat.m_name) {
                    buf.append(pat.m_name);
                }
                buf.append(")");
            } else if (128 == pat.m_whatToShow) {
                buf.append("comment()");
            } else if (null != pat.m_name) {
                if (2 == pat.m_whatToShow) {
                    buf.append("@");
                }
                if (null != pat.m_namespace) {
                    buf.append("{");
                    buf.append(pat.m_namespace);
                    buf.append("}");
                }
                buf.append(pat.m_name);
            } else if (2 == pat.m_whatToShow) {
                buf.append("@");
            } else if (1280 == pat.m_whatToShow) {
                buf.append("doc-root()");
            } else {
                buf.append("?" + Integer.toHexString(pat.m_whatToShow));
            }
            if (null != pat.m_predicates) {
                int i = 0;
                while (i < pat.m_predicates.length) {
                    buf.append("[");
                    buf.append(pat.m_predicates[i]);
                    buf.append("]");
                    ++i;
                }
            }
            pat = pat.m_relativePathPattern;
        }
        return buf.toString();
    }

    public double getMatchScore(XPathContext xctxt, int context) throws TransformerException {
        double d;
        xctxt.pushCurrentNode(context);
        xctxt.pushCurrentExpressionNode(context);
        try {
            XObject score = this.execute(xctxt);
            d = score.num();
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            throw throwable;
        }
        xctxt.popCurrentNode();
        xctxt.popCurrentExpressionNode();
        return d;
    }

    public void setAxis(int axis) {
        this.m_axis = axis;
    }

    public int getAxis() {
        return this.m_axis;
    }

    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        if (visitor.visitMatchPattern(owner, this)) {
            this.callSubtreeVisitors(visitor);
        }
    }

    protected void callSubtreeVisitors(XPathVisitor visitor) {
        if (null != this.m_predicates) {
            int n = this.m_predicates.length;
            int i = 0;
            while (i < n) {
                PredOwner predOwner = new PredOwner(this, i);
                if (visitor.visitPredicate((ExpressionOwner)predOwner, this.m_predicates[i])) {
                    this.m_predicates[i].callVisitors((ExpressionOwner)predOwner, visitor);
                }
                ++i;
            }
        }
        if (null != this.m_relativePathPattern) {
            this.m_relativePathPattern.callVisitors((ExpressionOwner)this, visitor);
        }
    }

    public Expression getExpression() {
        return this.m_relativePathPattern;
    }

    public void setExpression(Expression exp) {
        exp.exprSetParent((ExpressionNode)this);
        this.m_relativePathPattern = (StepPattern)exp;
    }

    public boolean deepEquals(Expression expr) {
        if (!super.deepEquals(expr)) {
            return false;
        }
        StepPattern sp = (StepPattern)expr;
        if (null != this.m_predicates) {
            int n = this.m_predicates.length;
            if (null == sp.m_predicates || sp.m_predicates.length != n) {
                return false;
            }
            int i = 0;
            while (i < n) {
                if (!this.m_predicates[i].deepEquals(sp.m_predicates[i])) {
                    return false;
                }
                ++i;
            }
        } else if (null != sp.m_predicates) {
            return false;
        }
        return !(null != this.m_relativePathPattern ? !this.m_relativePathPattern.deepEquals((Expression)sp.m_relativePathPattern) : sp.m_relativePathPattern != null);
    }
}

