/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.transform.Source;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMDefaultBase;
import org.apache.xml.dtm.ref.DTMDefaultBaseTraversers;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.XMLStringFactory;

public abstract class DTMDefaultBaseTraversers
extends DTMDefaultBase {
    public DTMDefaultBaseTraversers(DTMManager mgr, Source source, int dtmIdentity, DTMWSFilter whiteSpaceFilter, XMLStringFactory xstringfactory, boolean doIndexing) {
        super(mgr, source, dtmIdentity, whiteSpaceFilter, xstringfactory, doIndexing);
    }

    public DTMDefaultBaseTraversers(DTMManager mgr, Source source, int dtmIdentity, DTMWSFilter whiteSpaceFilter, XMLStringFactory xstringfactory, boolean doIndexing, int blocksize, boolean usePrevsib, boolean newNameTable) {
        super(mgr, source, dtmIdentity, whiteSpaceFilter, xstringfactory, doIndexing, blocksize, usePrevsib, newNameTable);
    }

    public DTMAxisTraverser getAxisTraverser(int axis) {
        DTMAxisTraverser traverser;
        if (null == this.m_traversers) {
            this.m_traversers = new DTMAxisTraverser[Axis.getNamesLength()];
            traverser = null;
        } else {
            traverser = this.m_traversers[axis];
            if (traverser != null) {
                return traverser;
            }
        }
        switch (axis) {
            case 0: {
                traverser = new AncestorTraverser(this, null);
                break;
            }
            case 1: {
                traverser = new AncestorOrSelfTraverser(this, null);
                break;
            }
            case 2: {
                traverser = new AttributeTraverser(this, null);
                break;
            }
            case 3: {
                traverser = new ChildTraverser(this, null);
                break;
            }
            case 4: {
                traverser = new DescendantTraverser(this, null);
                break;
            }
            case 5: {
                traverser = new DescendantOrSelfTraverser(this, null);
                break;
            }
            case 6: {
                traverser = new FollowingTraverser(this, null);
                break;
            }
            case 7: {
                traverser = new FollowingSiblingTraverser(this, null);
                break;
            }
            case 9: {
                traverser = new NamespaceTraverser(this, null);
                break;
            }
            case 8: {
                traverser = new NamespaceDeclsTraverser(this, null);
                break;
            }
            case 10: {
                traverser = new ParentTraverser(this, null);
                break;
            }
            case 11: {
                traverser = new PrecedingTraverser(this, null);
                break;
            }
            case 12: {
                traverser = new PrecedingSiblingTraverser(this, null);
                break;
            }
            case 13: {
                traverser = new SelfTraverser(this, null);
                break;
            }
            case 16: {
                traverser = new AllFromRootTraverser(this, null);
                break;
            }
            case 14: {
                traverser = new AllFromNodeTraverser(this, null);
                break;
            }
            case 15: {
                traverser = new PrecedingAndAncestorTraverser(this, null);
                break;
            }
            case 17: {
                traverser = new DescendantFromRootTraverser(this, null);
                break;
            }
            case 18: {
                traverser = new DescendantOrSelfFromRootTraverser(this, null);
                break;
            }
            case 19: {
                traverser = new RootTraverser(this, null);
                break;
            }
            case 20: {
                return null;
            }
            default: {
                throw new DTMException(XMLMessages.createXMLMessage((String)"ER_UNKNOWN_AXIS_TYPE", (Object[])new Object[]{Integer.toString(axis)}));
            }
        }
        if (null == traverser) {
            throw new DTMException(XMLMessages.createXMLMessage((String)"ER_AXIS_TRAVERSER_NOT_SUPPORTED", (Object[])new Object[]{Axis.getNames((int)axis)}));
        }
        this.m_traversers[axis] = traverser;
        return traverser;
    }
}

