/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.transform.Source;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMDefaultBaseIterators;
import org.apache.xml.dtm.ref.DTMDefaultBaseTraversers;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.XMLStringFactory;

public abstract class DTMDefaultBaseIterators
extends DTMDefaultBaseTraversers {
    public DTMDefaultBaseIterators(DTMManager mgr, Source source, int dtmIdentity, DTMWSFilter whiteSpaceFilter, XMLStringFactory xstringfactory, boolean doIndexing) {
        super(mgr, source, dtmIdentity, whiteSpaceFilter, xstringfactory, doIndexing);
    }

    public DTMDefaultBaseIterators(DTMManager mgr, Source source, int dtmIdentity, DTMWSFilter whiteSpaceFilter, XMLStringFactory xstringfactory, boolean doIndexing, int blocksize, boolean usePrevsib, boolean newNameTable) {
        super(mgr, source, dtmIdentity, whiteSpaceFilter, xstringfactory, doIndexing, blocksize, usePrevsib, newNameTable);
    }

    public DTMAxisIterator getTypedAxisIterator(int axis, int type) {
        TypedSingletonIterator iterator = null;
        switch (axis) {
            case 13: {
                iterator = new TypedSingletonIterator(this, type);
                break;
            }
            case 3: {
                iterator = new TypedChildrenIterator(this, type);
                break;
            }
            case 10: {
                return new ParentIterator(this).setNodeType(type);
            }
            case 0: {
                return new TypedAncestorIterator(this, type);
            }
            case 1: {
                return new TypedAncestorIterator(this, type).includeSelf();
            }
            case 2: {
                return new TypedAttributeIterator(this, type);
            }
            case 4: {
                iterator = new TypedDescendantIterator(this, type);
                break;
            }
            case 5: {
                iterator = new TypedDescendantIterator(this, type).includeSelf();
                break;
            }
            case 6: {
                iterator = new TypedFollowingIterator(this, type);
                break;
            }
            case 11: {
                iterator = new TypedPrecedingIterator(this, type);
                break;
            }
            case 7: {
                iterator = new TypedFollowingSiblingIterator(this, type);
                break;
            }
            case 12: {
                iterator = new TypedPrecedingSiblingIterator(this, type);
                break;
            }
            case 9: {
                iterator = new TypedNamespaceIterator(this, type);
                break;
            }
            case 19: {
                iterator = new TypedRootIterator(this, type);
                break;
            }
            default: {
                throw new DTMException(XMLMessages.createXMLMessage((String)"ER_TYPED_ITERATOR_AXIS_NOT_IMPLEMENTED", (Object[])new Object[]{Axis.getNames((int)axis)}));
            }
        }
        return iterator;
    }

    public DTMAxisIterator getAxisIterator(int axis) {
        SingletonIterator iterator = null;
        switch (axis) {
            case 13: {
                iterator = new SingletonIterator(this);
                break;
            }
            case 3: {
                iterator = new ChildrenIterator(this);
                break;
            }
            case 10: {
                return new ParentIterator(this);
            }
            case 0: {
                return new AncestorIterator(this);
            }
            case 1: {
                return new AncestorIterator(this).includeSelf();
            }
            case 2: {
                return new AttributeIterator(this);
            }
            case 4: {
                iterator = new DescendantIterator(this);
                break;
            }
            case 5: {
                iterator = new DescendantIterator(this).includeSelf();
                break;
            }
            case 6: {
                iterator = new FollowingIterator(this);
                break;
            }
            case 11: {
                iterator = new PrecedingIterator(this);
                break;
            }
            case 7: {
                iterator = new FollowingSiblingIterator(this);
                break;
            }
            case 12: {
                iterator = new PrecedingSiblingIterator(this);
                break;
            }
            case 9: {
                iterator = new NamespaceIterator(this);
                break;
            }
            case 19: {
                iterator = new RootIterator(this);
                break;
            }
            default: {
                throw new DTMException(XMLMessages.createXMLMessage((String)"ER_ITERATOR_AXIS_NOT_IMPLEMENTED", (Object[])new Object[]{Axis.getNames((int)axis)}));
            }
        }
        return iterator;
    }
}

