/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import java.util.Comparator;

public class RequestID {
    private static final char requestNumberSeparatorChar = '-';
    public static final long lowestRequestnumber = 0L;
    private final String protocolSessionID;
    private final long requestnumber;
    private static final Comparator<RequestID> requestIDComparator = new Comparator<RequestID>(){

        @Override
        public int compare(RequestID paramT1, RequestID paramT2) {
            if (!$assertionsDisabled && !paramT1.protocolSessionID.equals(paramT2.protocolSessionID)) {
                throw new AssertionError();
            }
            return Long.signum(paramT1.requestnumber - paramT2.requestnumber);
        }
    };

    public RequestID(String protocolSessionID, long requestnumber) {
        assert (protocolSessionID != null);
        this.protocolSessionID = protocolSessionID;
        this.requestnumber = requestnumber;
    }

    public String getProtocolSessionID() {
        return this.protocolSessionID;
    }

    public long getRequestnumber() {
        return this.requestnumber;
    }

    public static String getFieldValueEncodedRequestID(RequestID requestID) {
        return String.valueOf(requestID.protocolSessionID) + '-' + Long.toString(requestID.requestnumber);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.requestnumber ^ this.requestnumber >>> 32);
        result = 31 * result + (this.protocolSessionID == null ? 0 : this.protocolSessionID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestID other = (RequestID)obj;
        if (this.requestnumber != other.requestnumber) {
            return false;
        }
        return !(this.protocolSessionID == null ? other.protocolSessionID != null : !this.protocolSessionID.equals(other.protocolSessionID));
    }

    public static RequestID parseFieldValueEncodedRequestID(String requestID) {
        int requestNumberSeparatorIndex = requestID.lastIndexOf(45);
        assert (requestNumberSeparatorIndex != -1);
        return new RequestID(requestID.substring(0, requestNumberSeparatorIndex), Long.parseLong(requestID.substring(requestNumberSeparatorIndex + 1)));
    }

    public static Comparator<RequestID> getRequestIDComparator() {
        return requestIDComparator;
    }

    public String toString() {
        return "RequestID [protocolSessionID=" + this.protocolSessionID + ", requestnumber=" + this.requestnumber + "]";
    }
}

