/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.psc.shared.message.IPermission;

public class EOPermission
extends EOEncodableObject
implements IPermission,
Cloneable {
    public static String XML_NAME = "psc.permission";
    private String permissionUID;
    private String subSetUID;
    private String subSetType;
    private String operandUID;
    private String operandType;
    private String ownerUID;
    private int ownerType;
    private String operation;
    private String operation2;
    public static final int OWNER_TYPE_USER = 0;
    public static final int OWNER_TYPE_GROUP = 1;
    public static final int OWNER_TYPE_ROLE = 2;
    private static final String ATTR_TAG_PERMISSION_UID = "permissionUID";
    private static final String ATTR_TAG_SUB_SET_UID = "subSetUID";
    private static final String ATTR_TAG_SUB_SET_TYPE = "subSetType";
    private static final String ATTR_TAG_OPERAND_UID = "operandUID";
    private static final String ATTR_TAG_OPERAND_TYPE = "operandType";
    private static final String ATTR_TAG_OWNER_UID = "ownerUID";
    private static final String ATTR_TAG_OWNER_TYPE = "ownerType";
    private static final String ATTR_TAG_OPERATION = "operation";
    private static final String ATTR_TAG_OPERATION2 = "operation2";

    public EOPermission() {
        super(XML_NAME);
    }

    public EOPermission(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    public EOPermission(EOPermission permission) {
        super(XML_NAME);
        this.setOperandType(permission.getOperandType());
        this.setOperandUID(permission.getOperandUID());
        this.setOperation(permission.getOperation());
        this.setOperation2(permission.getOperation2());
        this.setOwnerID(permission.getOwnerID());
        this.setOwnerType(permission.getOwnerType());
        this.setPermissionUID(permission.getPermissionUID());
        this.setSubSetType(permission.getSubSetType());
        this.setSubSetUID(permission.getSubSetUID());
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_TAG_PERMISSION_UID, this.permissionUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_SUB_SET_UID, this.subSetUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_SUB_SET_TYPE, this.subSetType);
        this.appendAttrToXML(writeContext, ATTR_TAG_OPERAND_UID, this.operandUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_OPERAND_TYPE, this.operandType);
        this.appendAttrToXML(writeContext, ATTR_TAG_OWNER_UID, this.ownerUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_OWNER_TYPE, this.ownerType);
        this.appendAttrToXML(writeContext, ATTR_TAG_OPERATION, this.operation);
        if (this.operation2 != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_OPERATION2, this.operation2);
        }
    }

    protected boolean hasChildren() {
        return false;
    }

    protected boolean setAttributeFromXML(String name, String value) {
        boolean success = true;
        if (name.equals(ATTR_TAG_PERMISSION_UID)) {
            this.permissionUID = value;
        } else if (name.equals(ATTR_TAG_SUB_SET_UID)) {
            this.subSetUID = value;
        } else if (name.equals(ATTR_TAG_SUB_SET_TYPE)) {
            this.subSetType = value;
        } else if (name.equals(ATTR_TAG_OPERAND_UID)) {
            this.operandUID = value;
        } else if (name.equals(ATTR_TAG_OPERAND_TYPE)) {
            this.operandType = value;
        } else if (name.equals(ATTR_TAG_OWNER_UID)) {
            this.ownerUID = value;
        } else if (name.equals(ATTR_TAG_OWNER_TYPE)) {
            this.ownerType = this.toInt(value);
        } else if (name.equals(ATTR_TAG_OPERATION)) {
            this.operation = value;
        } else if (name.equals(ATTR_TAG_OPERATION2)) {
            this.operation2 = value;
        } else {
            success = false;
        }
        return success;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    @Override
    public String getOperandType() {
        return this.operandType;
    }

    @Override
    public String getOperandUID() {
        return this.operandUID;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    public String getOperation2() {
        return this.operation2;
    }

    public boolean isOwnerTypeUser() {
        return this.ownerType == 0;
    }

    public boolean isOwnerTypeGroup() {
        return this.ownerType == 1;
    }

    public String getOwnerID() {
        return this.ownerUID;
    }

    public int getOwnerType() {
        return this.ownerType;
    }

    public String getPermissionUID() {
        return this.permissionUID;
    }

    public String getSubSetType() {
        return this.subSetType;
    }

    public String getSubSetUID() {
        return this.subSetUID;
    }

    public void setOperandType(String value) {
        assert (value.length() < 256) : "operand type to large";
        this.operandType = value;
    }

    public void setOperandUID(String value) {
        assert (value == null || value.length() < 33) : "operand UID to large";
        this.operandUID = value;
    }

    public void setOperation(String value) {
        assert (value != null) : "operation may not be null";
        assert (value.length() < 256) : "operation to large";
        this.operation = value;
    }

    public void setOperation2(String operation2) {
        if (operation2 != null) assert (operation2.length() < 256) : "operation2 to large";
        this.operation2 = operation2;
    }

    public void setOwnerTypeUser() {
        this.ownerType = 0;
    }

    public void setOwnerTypeGroup() {
        this.ownerType = 1;
    }

    public void setOwnerType(int value) {
        assert (value == 0 || value == 1 || value == 2) : "invalid owner type";
        this.ownerType = value;
    }

    public void setOwnerID(String value) {
        assert (value != null) : "owner UID may not be null";
        assert (value.length() < 64) : "owner UID to large";
        this.ownerUID = value;
    }

    public void setPermissionUID(String value) {
        assert (value != null) : "permission UID may not be null";
        assert (value.length() < 33) : "permission UID to large";
        this.permissionUID = value;
    }

    public void setSubSetType(String value) {
        assert (value != null) : "sub set type may not be null";
        assert (value.length() < 33) : "sub set type to large";
        this.subSetType = value;
    }

    public void setSubSetUID(String value) {
        assert (value != null) : "sub set UID may not be null";
        assert (value.length() < 33) : "sub set UID to large";
        this.subSetUID = value;
    }

    public boolean isEqual(EOPermission p) {
        if (this == p) {
            return true;
        }
        if (this.hasEqualRights(p) && p.getOwnerType() == this.getOwnerType()) {
            return this.equals(p.getOwnerID(), this.getOwnerID());
        }
        return false;
    }

    public boolean hasEqualRights(EOPermission permission) {
        return this.equals(this.operandType, permission.operandType) && this.equals(this.operandUID, permission.operandUID) && this.equals(this.operation, permission.operation) && this.equals(this.operation2, permission.operation2) && this.equals(this.subSetType, permission.subSetType) && this.equals(this.subSetUID, permission.subSetUID);
    }

    private boolean equals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        return s1 != null && s2 != null && s1.equals(s2);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

