/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.psc.shared.message.EOConfigField;
import java.util.List;

public class EOConfigurableComponent
extends EOEncodableObject {
    public static final String XML_NAME = "ConfigurableComponent";
    private static final String ATTR_TAG_DISPLAY_NAME = "displayname";
    private static final String ATTR_TAG_ID = "id";
    private static final String ATTR_TAG_REJECT_REASON = "rejectreason";
    private String displayName;
    private String id;
    private String rejectReason;
    private List<EOConfigField> fields;

    public EOConfigurableComponent() {
        super(XML_NAME);
    }

    public EOConfigurableComponent(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public EOConfigurableComponent(String id, String displayName, List<EOConfigField> fields) {
        super(XML_NAME);
        this.displayName = displayName;
        this.id = id;
        this.fields = fields;
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_TAG_DISPLAY_NAME, this.displayName);
        this.appendAttrToXML(writeContext, ATTR_TAG_ID, this.id);
        this.appendAttrToXML(writeContext, ATTR_TAG_REJECT_REASON, this.rejectReason);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_DISPLAY_NAME)) {
            this.displayName = value;
        } else if (name.equals(ATTR_TAG_ID)) {
            this.id = value;
        } else if (name.equals(ATTR_TAG_REJECT_REASON)) {
            this.rejectReason = value;
        } else {
            knownAttribute = false;
        }
        return knownAttribute;
    }

    protected boolean hasChildren() {
        return this.fields != null && this.fields.size() > 0;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        if (this.fields != null) {
            int i = 0;
            while (i < this.fields.size()) {
                EOConfigField field = this.fields.get(i);
                field.writeXMLBody(writeContext, depth);
                ++i;
            }
        }
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        if ("Field".equals(newChild.getTag())) {
            this.fields.add((EOConfigField)newChild);
            return true;
        }
        return false;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getID() {
        return this.id;
    }

    public List<EOConfigField> getFields() {
        return this.fields;
    }

    public String getParameterRejectReason() {
        return this.rejectReason;
    }

    public void setParameterRejectReason(String reason) {
        this.rejectReason = reason;
    }
}

