/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared;

import de.plans.psc.shared.Messages;
import de.plans.psc.shared.message.EOAddUserRequest;
import de.plans.psc.shared.message.EOGroup;
import de.plans.psc.shared.message.EOUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PSCUserAndGroupConstants {
    private static final EOAddUserRequest DefaultAddAdminUserRequest;
    private static final List<EOAddUserRequest> AddUserRequestsForMandatoryUsers;
    private static final Set<String> NamesOfMandatoryUsers;
    private static final List<EOGroup> DefaultGroups;
    private static final Set<String> NamesOfDefaultGroups;
    private static final List<EOGroup> MandatoryGroups;
    private static final Set<String> NamesOfMandatoryGroups;

    static {
        EOUser defaultAdminUser = new EOUser();
        defaultAdminUser.setUserName("Administrator");
        defaultAdminUser.setDisplayName("Main Administrator");
        defaultAdminUser.setDescription("Main Administrator. This user MUST not be deleted!");
        defaultAdminUser.setEmail("");
        DefaultAddAdminUserRequest = new EOAddUserRequest();
        DefaultAddAdminUserRequest.setUser(defaultAdminUser);
        DefaultAddAdminUserRequest.setPasswd("PSC");
        ArrayList<EOAddUserRequest> m_AddUserRequestsForMandatoryUsers = new ArrayList<EOAddUserRequest>();
        m_AddUserRequestsForMandatoryUsers.add(DefaultAddAdminUserRequest);
        AddUserRequestsForMandatoryUsers = Collections.unmodifiableList(m_AddUserRequestsForMandatoryUsers);
        HashSet<String> userNames = new HashSet<String>();
        for (EOAddUserRequest addUserRequestsForMandatoryUser : AddUserRequestsForMandatoryUsers) {
            userNames.add(addUserRequestsForMandatoryUser.getUser().getUserName());
        }
        NamesOfMandatoryUsers = Collections.unmodifiableSet(userNames);
        ArrayList<EOGroup> m_defaultGroups = new ArrayList<EOGroup>();
        EOGroup everyoneGroup = new EOGroup();
        everyoneGroup.setGroupName("Everyone");
        everyoneGroup.setDisplayName(Messages.getString("PSCUserAndGroupConstants.All_users_1"));
        everyoneGroup.setDescription(Messages.getString("PSCUserAndGroupConstants.All_users_of_the_system._This_group_MUST_not_be_deleted_!_2"));
        m_defaultGroups.add(everyoneGroup);
        DefaultGroups = Collections.unmodifiableList(m_defaultGroups);
        HashSet<String> groupNames = new HashSet<String>();
        for (EOGroup group : DefaultGroups) {
            groupNames.add(group.getGroupName());
        }
        NamesOfDefaultGroups = Collections.unmodifiableSet(groupNames);
        ArrayList<EOGroup> m_mandatoryGroups = new ArrayList<EOGroup>();
        EOGroup administratorsGroup = new EOGroup();
        administratorsGroup.setGroupName("Administrators");
        administratorsGroup.setDisplayName(Messages.getString("PSCUserAndGroupConstants.Administrators_3"));
        administratorsGroup.setDescription(Messages.getString("PSCUserAndGroupConstants.Server_Administrators._This_group_MUST_not_be_deleted_!_4"));
        m_mandatoryGroups.add(administratorsGroup);
        EOGroup everyoneGroup2 = new EOGroup();
        everyoneGroup2.setGroupName("Everyone");
        everyoneGroup2.setDisplayName(Messages.getString("PSCUserAndGroupConstants.All_users_5"));
        everyoneGroup2.setDescription(Messages.getString("PSCUserAndGroupConstants.All_users_of_the_system._This_group_MUST_not_be_deleted_!_6"));
        m_mandatoryGroups.add(everyoneGroup2);
        MandatoryGroups = Collections.unmodifiableList(m_mandatoryGroups);
        groupNames = new HashSet();
        for (EOGroup group : MandatoryGroups) {
            groupNames.add(group.getGroupName());
        }
        NamesOfMandatoryGroups = Collections.unmodifiableSet(groupNames);
    }

    public static final List<EOAddUserRequest> getAddUserRequestsForMandatoryUsers() {
        return AddUserRequestsForMandatoryUsers;
    }

    public static Set<String> getNamesOfMandatoryUsers() {
        return NamesOfMandatoryUsers;
    }

    public static boolean isMandatoryUser(EOUser user) {
        assert (user != null) : "user must not be null";
        return PSCUserAndGroupConstants.isMandatoryUser(user.getUserName());
    }

    public static boolean isMandatoryUser(String userName) {
        assert (userName != null) : "user name must not be null";
        return NamesOfMandatoryUsers.contains(userName);
    }

    public static List<EOGroup> getDefaultGroups() {
        return DefaultGroups;
    }

    public static List<EOGroup> getMandatoryGroups() {
        return MandatoryGroups;
    }

    public static Set<String> getNamesOfMandatoryGroups() {
        return NamesOfMandatoryGroups;
    }

    public static boolean isMandatoryGroup(EOGroup group) {
        assert (group != null) : "group must not be null";
        return PSCUserAndGroupConstants.isMandatoryGroup(group.getGroupName());
    }

    public static boolean isMandatoryGroup(String groupName) {
        assert (groupName != null) : "group name must not be null";
        return NamesOfMandatoryGroups.contains(groupName);
    }

    public static boolean isDefaultGroup(EOGroup group) {
        assert (group != null) : "group must not be null";
        return NamesOfDefaultGroups.contains(group.getGroupName());
    }
}

