/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding.sequential.read;

import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.encoding.sequential.processing.IEOContainerProcessor;
import de.plans.lib.xml.encoding.sequential.read.EOElementDispatcher;

public abstract class AbstractEOContainerReader<C extends EncodableObjectBase, E extends EncodableObjectBase>
implements IEncodableObjectFactory {
    private final IEOContainerProcessor<C, E> containerProcessor;
    private EOElementDispatcher<C, E> currentElementDispatcher = null;

    public AbstractEOContainerReader(IEOContainerProcessor<C, E> containerProcessor) {
        this.containerProcessor = containerProcessor;
    }

    @Override
    public EncodableObjectBase createEncodableObject(String name, XMLContext context) throws EXDecoderException {
        EOElementDispatcher<C, E> createdObject;
        if (this.currentElementDispatcher == null) {
            IEncodableObjectFactory eoFactory = this.getEOFactoryForEmptyContainer();
            EncodableObjectBase createdEmptyContainer = eoFactory.createEncodableObject(name, context);
            createdObject = this.currentElementDispatcher = new EOElementDispatcher(name, context, createdEmptyContainer, new IEOContainerProcessor<C, E>(){

                @Override
                public void beginContainer(C emptyContainer) {
                    AbstractEOContainerReader.this.containerProcessor.beginContainer(emptyContainer);
                }

                @Override
                public void processEO(E encodableObject) {
                    AbstractEOContainerReader.this.containerProcessor.processEO(encodableObject);
                }

                @Override
                public void endContainer() {
                    AbstractEOContainerReader.this.containerProcessor.endContainer();
                    AbstractEOContainerReader.this.currentElementDispatcher = null;
                }
            });
        } else {
            IEncodableObjectFactory eoFactory = this.getEOFactoryForDecoder();
            createdObject = eoFactory.createEncodableObject(name, context);
        }
        return createdObject;
    }

    protected abstract IEncodableObjectFactory getEOFactoryForDecoder();

    protected abstract IEncodableObjectFactory getEOFactoryForEmptyContainer();
}

