/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding.sequential.processing;

import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import de.plans.lib.xml.encoding.sequential.processing.IEOContainerProcessor;
import de.plans.lib.xml.encoding.sequential.read.EOContainerReader;
import java.io.File;
import java.io.InputStream;

public class EOConcatenatingContainerReader<C extends EncodableObjectBase, E extends EncodableObjectBase> {
    private final IEOContainerProcessor<C, E> containerProcessor;
    private EOConcatenatingContainerReader<? extends EncodableObjectBase, C> parentContainerProcessor;

    public EOConcatenatingContainerReader(IEOContainerProcessor<C, E> containerProcessor) {
        this.containerProcessor = containerProcessor;
        this.parentContainerProcessor = null;
    }

    public <EE extends EncodableObjectBase> EOConcatenatingContainerReader<E, EE> createChildProcessor(IEOContainerProcessor<E, EE> childProcessor) {
        EOConcatenatingContainerReader<E, EE> childContainerProcessor = new EOConcatenatingContainerReader<E, EE>(childProcessor);
        childContainerProcessor.parentContainerProcessor = this;
        return childContainerProcessor;
    }

    public void readContainer(File file, XMLDecoder xmlDecoder, IEncodableObjectFactory eoFactory) throws EXDecoderException, JvmExternalResourceInteractionException {
        this.readContainer(FileHelper.fileToInputStream((File)file), xmlDecoder, eoFactory);
    }

    public void readContainer(InputStream inputStream, XMLDecoder xmlDecoder, IEncodableObjectFactory eoFactory) throws EXDecoderException {
        EOContainerReader<C, E> containerReader = new EOContainerReader<C, E>(eoFactory, this.containerProcessor);
        if (this.parentContainerProcessor != null) {
            this.parentContainerProcessor.readContainer(inputStream, xmlDecoder, containerReader);
        } else {
            xmlDecoder.decodeXML(inputStream, containerReader, true);
        }
    }
}

