/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding;

import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.pooling.IPoolableObjectFactory;
import de.plans.lib.pooling.Pool;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.io.File;
import java.io.FileNotFoundException;

public class XMLDecoderPool {
    private static final Pool<XMLDecoder> xmlDecoderPool = new Pool<XMLDecoder>(new IPoolableObjectFactory<XMLDecoder>(){

        @Override
        public XMLDecoder createPoolElement() {
            return new XMLDecoder();
        }

        @Override
        public void destroyPoolElement(XMLDecoder element) {
        }
    });

    public static EncodableObjectBase decodeXMLFile(File file, IEncodableObjectFactory factory, boolean areAttributeValuesByDefaultURLEncoded) throws EXDecoderException, FileNotFoundException {
        XMLDecoder decoder = xmlDecoderPool.acquireObject();
        try {
            EncodableObjectBase encodableObjectBase = decoder.decodeXMLFile(file, factory, areAttributeValuesByDefaultURLEncoded);
            return encodableObjectBase;
        }
        finally {
            xmlDecoderPool.releaseObject(decoder);
        }
    }
}

