/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding;

import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.ExceptionMessageCreater;
import de.plans.lib.xml.encoding.EOGenericMessage;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.encoding.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDecoder
extends DefaultHandler {
    private static final ILogger logger = Logger.getLogger(XMLDecoder.class);
    private EncodableObjectBase eoRoot;
    private ElementAndContent activeElement;
    private IEncodableObjectFactory abstractEOFactory;
    private EncodableObjectBase.ReadContext readContext;
    private final CachingElementStack elementStack = new CachingElementStack();
    private SAXParser xmlParser;

    public XMLDecoder() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            this.xmlParser = factory.newSAXParser();
        }
        catch (SAXException e) {
            logger.error((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.error((Throwable)e);
        }
    }

    public EOGenericMessage decodeXML(InputStream is, boolean areAttributeValuesByDefaultURLEncoded) throws EXDecoderException {
        IEncodableObjectFactory factory = new IEncodableObjectFactory(){

            @Override
            public EncodableObjectBase createEncodableObject(String name, XMLContext context) throws EXDecoderException {
                return new EOGenericMessage(name, context);
            }
        };
        return (EOGenericMessage)this.decodeXML(is, factory, areAttributeValuesByDefaultURLEncoded);
    }

    public EncodableObjectBase decodeXMLFile(File file, IEncodableObjectFactory factory, boolean areAttributeValuesByDefaultURLEncoded) throws EXDecoderException, FileNotFoundException {
        EncodableObjectBase result;
        try {
            FileInputStream is = new FileInputStream(file);
            try {
                result = this.decodeXML(new BufferedInputStream(is), factory, areAttributeValuesByDefaultURLEncoded);
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e1) {
                    logger.error("IOException while closing XML Input Stream.", (Throwable)e1);
                }
            }
        }
        catch (EXDecoderException e) {
            StringBuilder stringBuf = new StringBuilder((int)file.length());
            FileInputStream is = new FileInputStream(file);
            try {
                try {
                    InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(is), "UTF-8");
                    char[] charBuf = new char[4096];
                    int read = reader.read(charBuf);
                    while (read >= 0) {
                        stringBuf.append(charBuf, 0, read);
                        read = reader.read(charBuf);
                    }
                    ((Reader)reader).close();
                    boolean replacedSomething = this.replaceAllInvalidXMLCharacterReferencesWithReplacementString(stringBuf);
                    if (replacedSomething) {
                        String xmlString = stringBuf.toString();
                        result = this.decodeXML(xmlString, factory, areAttributeValuesByDefaultURLEncoded);
                        logger.debug("Successfully repaired XML file " + file.getPath() + "containg invalid XML character reference(s) which caused the following parse-error:", (Throwable)e);
                    }
                    throw e;
                }
                catch (IrrepairableXMLException e1) {
                    throw e;
                }
                catch (UnsupportedEncodingException e1) {
                    throw e;
                }
                catch (IOException e1) {
                    throw e;
                }
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e1) {
                    logger.error("IOException while closing XML Input Stream.", (Throwable)e1);
                }
            }
        }
        return result;
    }

    private boolean replaceAllInvalidXMLCharacterReferencesWithReplacementString(StringBuilder buf) throws IrrepairableXMLException {
        String referencePrefix = "&#";
        String referenceSuffix = ";";
        boolean replacedSomething = false;
        int prefixIdx = buf.indexOf("&#");
        while (prefixIdx >= 0) {
            int numberStringIdx = prefixIdx + "&#".length();
            int suffixIdx = buf.indexOf(";", numberStringIdx);
            if (suffixIdx >= 0) {
                int codepoint;
                String numberString = buf.substring(numberStringIdx, suffixIdx);
                try {
                    codepoint = numberString.startsWith("x") || numberString.startsWith("X") ? Integer.parseInt(numberString.substring(1), 16) : Integer.parseInt(numberString);
                }
                catch (NumberFormatException e) {
                    throw new IrrepairableXMLException();
                }
                if (codepoint < 128 && XMLEncoder.INVALID_XML_CHARACTERS.contains(Character.valueOf((char)codepoint))) {
                    buf.replace(prefixIdx, suffixIdx + ";".length(), " ");
                    replacedSomething = true;
                }
            } else {
                throw new IrrepairableXMLException();
            }
            prefixIdx = buf.indexOf("&#", prefixIdx + 1);
        }
        return replacedSomething;
    }

    public EncodableObjectBase decodeXML(InputStream is, IEncodableObjectFactory factory, boolean areAttributeValuesByDefaultURLEncoded) throws EXDecoderException {
        EncodableObjectBase returnValue;
        try {
            this.abstractEOFactory = factory;
            this.eoRoot = null;
            this.elementStack.clearStackAndCache();
            this.readContext = new EncodableObjectBase.ReadContext(areAttributeValuesByDefaultURLEncoded);
            this.elementStack.pushAdditionalElement();
            this.activeElement = null;
            try {
                this.xmlParser.parse(is, (DefaultHandler)this);
            }
            catch (IOException e) {
                logger.error("IOException while parsing XML Input Stream", (Throwable)e);
                throw new EXDecoderException("IO failure.", (Throwable)e);
            }
            catch (SAXException e) {
                logger.error("SAX Exception: " + ExceptionMessageCreater.getMessageWithCauseMessages(e), (Throwable)e);
                Exception cause = e.getException();
                if (cause == null) {
                    throw new EXDecoderException("Parser failure.", (Throwable)e);
                }
                if (cause instanceof EXDecoderException) {
                    throw (EXDecoderException)((Object)cause);
                }
                throw new EXDecoderException("Parser failure.", (Throwable)cause);
            }
            if (this.elementStack.size() != 1) {
                throw new EXDecoderException("Parser failure. XML Stream is invalid or truncated (number of unclosed elements=" + (this.elementStack.size() - 1) + ")");
            }
            returnValue = this.eoRoot;
        }
        finally {
            this.cleanupAfterDecoding();
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error("IOException while closing XML Input Stream.", (Throwable)e);
                }
            }
        }
        return returnValue;
    }

    public EncodableObjectBase decodeXML(String xmlContent, IEncodableObjectFactory factory, boolean areAttributeValuesByDefaultURLEncoded) throws EXDecoderException {
        StringReader sr = new StringReader(xmlContent);
        InputSource is = new InputSource(sr);
        return this.decodeXML(is, factory, areAttributeValuesByDefaultURLEncoded);
    }

    public EncodableObjectBase decodeXML(InputSource is, IEncodableObjectFactory factory, boolean areAttributeValuesByDefaultURLEncoded) throws EXDecoderException {
        this.abstractEOFactory = factory;
        this.eoRoot = null;
        this.elementStack.clearStackAndCache();
        this.readContext = new EncodableObjectBase.ReadContext(areAttributeValuesByDefaultURLEncoded);
        this.elementStack.pushAdditionalElement();
        this.activeElement = null;
        try {
            this.xmlParser.parse(is, (DefaultHandler)this);
        }
        catch (IOException e) {
            logger.debug("IOException while parsing XML Input Stream", (Throwable)e);
            throw new EXDecoderException("IO failure.", (Throwable)e);
        }
        catch (SAXException e) {
            logger.debug("SAX Exception: " + ExceptionMessageCreater.getMessageWithCauseMessages(e));
            Exception cause = e.getException();
            if (cause instanceof EXDecoderException) {
                throw (EXDecoderException)((Object)cause);
            }
            throw new EXDecoderException("Parser failure.", (Throwable)cause);
        }
        if (this.elementStack.size() != 1) {
            throw new EXDecoderException("Parser failure. XML Stream is invalid or truncated (number of unclosed elements=" + (this.elementStack.size() - 1) + ")");
        }
        EncodableObjectBase returnValue = this.eoRoot;
        this.cleanupAfterDecoding();
        return returnValue;
    }

    @Override
    public void startElement(String nameSpaceURI, String localName, String qName, Attributes attr) throws SAXException {
        String name = localName == null || localName.length() == 0 ? qName : localName;
        try {
            this.flushContent(false);
            ElementAndContent parent = this.activeElement;
            EncodableObjectBase parentEO = parent == null ? null : this.activeElement.eo;
            this.elementStack.pushAdditionalElement();
            this.activeElement = this.elementStack.top();
            XMLContext context = new XMLContext(nameSpaceURI, parentEO);
            this.activeElement.parenteo = parentEO;
            this.activeElement.eo = this.abstractEOFactory.createEncodableObject(name, context);
            if (this.activeElement.eo == null) {
                throw new EXDecoderException("Was not able to create EO for tag <" + name + "/>");
            }
            this.activeElement.eo.setAttributesFromXMLDecoder(attr, this.readContext);
            if (this.activeElement.eo.canHaveBinaryContentFromBase()) {
                this.activeElement.eo.beginReadingBinaryContentFromBase();
            }
            if (this.eoRoot == null) {
                this.eoRoot = this.activeElement.eo;
            }
        }
        catch (EXDecoderException e) {
            logger.debug("EXDecoderException in startElement: " + ExceptionMessageCreater.getMessageWithCauseMessages(e), (Throwable)e);
            throw new SAXException((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.debug("Exception in startElement: " + ExceptionMessageCreater.getMessageWithCauseMessages(e), (Throwable)e);
            throw new SAXException(e);
        }
    }

    private void flushContent(boolean endElement) throws EXDecoderException {
        if (this.activeElement != null) {
            String untrimmed = this.activeElement.currentStringContent.toString();
            boolean trimBeginning = !this.activeElement.isFurtherStringContent;
            boolean trimEnd = endElement;
            String trimmed = XMLDecoder.trim(untrimmed, trimBeginning, trimEnd);
            if (this.activeElement.eo != null) {
                this.activeElement.eo.addContent(trimmed);
            }
            this.activeElement.currentStringContent.setLength(0);
            this.activeElement.isFurtherStringContent = true;
        }
    }

    private static String trim(String untrimmed, boolean trimBeginning, boolean trimEnd) {
        int endIndex = untrimmed.length();
        int startIndex = 0;
        if (trimBeginning) {
            while (startIndex < endIndex && untrimmed.charAt(startIndex) <= ' ') {
                ++startIndex;
            }
        }
        if (trimEnd) {
            while (startIndex < endIndex && untrimmed.charAt(endIndex - 1) <= ' ') {
                --endIndex;
            }
        }
        return startIndex > 0 || endIndex < untrimmed.length() ? untrimmed.substring(startIndex, endIndex) : untrimmed;
    }

    @Override
    public void endElement(String nameSpaceURI, String localName, String qName) throws SAXException {
        try {
            if (this.activeElement.eo != null) {
                if (this.activeElement.eo.canHaveBinaryContentFromBase()) {
                    this.activeElement.eo.endReadingBinaryContentFromBase();
                } else {
                    this.flushContent(true);
                }
                this.activeElement.eo.endElement();
                if (this.activeElement.parenteo != null) {
                    this.activeElement.parenteo.addChild(this.activeElement.eo);
                }
            }
            this.elementStack.pop();
            if (this.elementStack.isEmpty()) {
                throw new SAXException("endElement reached without startElement!");
            }
            this.activeElement = this.elementStack.top();
        }
        catch (Exception e) {
            logger.debug("Exception in endElement: " + ExceptionMessageCreater.getMessageWithCauseMessages(e));
            throw new SAXException(e);
        }
    }

    private void cleanupAfterDecoding() {
        this.abstractEOFactory = null;
        this.eoRoot = null;
        this.activeElement = null;
        this.elementStack.clearStackAndCache();
        this.readContext = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.activeElement != null) {
            if (this.activeElement.eo.canHaveBinaryContentFromBase()) {
                try {
                    this.activeElement.eo.readPartOfBinaryContentFromBase(ch, start, length);
                }
                catch (EXDecoderException e) {
                    throw new SAXException((Exception)((Object)e));
                }
            } else {
                this.activeElement.currentStringContent.append(ch, start, length);
            }
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if ("com.arcway.eobase".equals(target) && data != null) {
            if (data.indexOf("urlencoding=\"true\"") >= 0) {
                this.readContext.setAttributeValuesAreURLEncoded(true);
            }
            if (data.indexOf("urlencoding=\"false\"") >= 0) {
                this.readContext.setAttributeValuesAreURLEncoded(false);
            }
        }
        super.processingInstruction(target, data);
    }

    private static class CachingElementStack {
        ElementAndContent[] stackData = null;
        int stackheigth = 0;

        private CachingElementStack() {
        }

        private void ensureElementAndContentArrayIsBigEnough(int minRequiredSize) {
            if (this.stackData == null || this.stackData.length < minRequiredSize) {
                int paddingStartIndex;
                int enlargeAmount;
                if (this.stackData == null) {
                    enlargeAmount = 20;
                    paddingStartIndex = 0;
                    this.stackData = new ElementAndContent[enlargeAmount];
                } else {
                    enlargeAmount = this.stackData.length;
                    paddingStartIndex = this.stackData.length;
                    ElementAndContent[] newStackData = new ElementAndContent[this.stackData.length + enlargeAmount];
                    System.arraycopy(this.stackData, 0, newStackData, 0, this.stackData.length);
                    this.stackData = newStackData;
                }
                int i = paddingStartIndex;
                while (i < paddingStartIndex + enlargeAmount) {
                    this.stackData[i] = i == 0 ? null : new ElementAndContent();
                    ++i;
                }
            }
        }

        private void clearStackAndCache() {
            this.stackData = null;
            this.stackheigth = 0;
        }

        private void pushAdditionalElement() {
            ++this.stackheigth;
            this.ensureElementAndContentArrayIsBigEnough(this.stackheigth);
        }

        private void pop() {
            if (this.stackheigth > 0) {
                --this.stackheigth;
                this.stackData[this.stackheigth].reinitialize();
            }
        }

        private ElementAndContent top() {
            assert (this.stackheigth > 0) : "A Empty Stack has no top element";
            return this.stackData[this.stackheigth - 1];
        }

        private boolean isEmpty() {
            return this.stackheigth == 0;
        }

        private int size() {
            return this.stackheigth;
        }
    }

    private static class ElementAndContent {
        public EncodableObjectBase eo = null;
        public EncodableObjectBase parenteo = null;
        public StringBuffer currentStringContent = new StringBuffer();
        public boolean isFurtherStringContent = false;

        private void reinitialize() {
            this.eo = null;
            this.parenteo = null;
            this.currentStringContent.setLength(0);
            this.isFurtherStringContent = false;
        }
    }

    private class IrrepairableXMLException
    extends Exception {
        private IrrepairableXMLException() {
        }
    }
}

