/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding;

import de.plans.lib.xml.encoding.AbstractEncodableObjectFactory;
import de.plans.lib.xml.encoding.EOGenericMessage;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EOTuple;
import de.plans.lib.xml.encoding.EOValue;
import de.plans.lib.xml.encoding.EOValueNullable;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.primitiveTypes.EOBoolean;
import de.plans.lib.xml.primitiveTypes.EODouble;
import de.plans.lib.xml.primitiveTypes.EOInteger;
import de.plans.lib.xml.primitiveTypes.EOLong;
import de.plans.lib.xml.primitiveTypes.EOString;

public class MessageDataFactoryForBasicEOs
extends AbstractEncodableObjectFactory {
    private static MessageDataFactoryForBasicEOs singleton;

    public static MessageDataFactoryForBasicEOs getDefault() {
        if (singleton == null) {
            singleton = new MessageDataFactoryForBasicEOs();
        }
        return singleton;
    }

    private MessageDataFactoryForBasicEOs() {
        this.addConstructor("List", new AbstractEncodableObjectFactory.IFactory(){

            @Override
            public EncodableObjectBase createEO(XMLContext xmlContext) {
                return new EOList(xmlContext);
            }
        });
        this.addConstructor("Tuple", new AbstractEncodableObjectFactory.IFactory(){

            @Override
            public EncodableObjectBase createEO(XMLContext xmlContext) {
                return new EOTuple(xmlContext);
            }
        });
        this.addConstructor("Value", new AbstractEncodableObjectFactory.IFactory(){

            @Override
            public EncodableObjectBase createEO(XMLContext xmlContext) {
                return new EOValue(xmlContext);
            }
        });
        this.addConstructor("ValueNullable", new AbstractEncodableObjectFactory.IFactory(){

            @Override
            public EncodableObjectBase createEO(XMLContext xmlContext) {
                return new EOValueNullable(xmlContext);
            }
        });
        this.addConstructor("GenericMessage", new AbstractEncodableObjectFactory.IFactory(){

            @Override
            public EncodableObjectBase createEO(XMLContext xmlContext) {
                return new EOGenericMessage(xmlContext);
            }
        });
        this.addConstructor("pslib.datatype.eomodule", EOGenericMessage.EOModuleFactory);
        this.addConstructor("frame.datatype.boolean", new AbstractEncodableObjectFactory.IFactory(){

            @Override
            public EncodableObjectBase createEO(XMLContext xmlContext) {
                return new EOBoolean(xmlContext);
            }
        });
        this.addConstructor("frame.datatype.double", new AbstractEncodableObjectFactory.IFactory(){

            @Override
            public EncodableObjectBase createEO(XMLContext xmlContext) {
                return new EODouble(xmlContext);
            }
        });
        this.addConstructor("frame.datatype.integer", new AbstractEncodableObjectFactory.IFactory(){

            @Override
            public EncodableObjectBase createEO(XMLContext xmlContext) {
                return new EOInteger(xmlContext);
            }
        });
        this.addConstructor("frame.datatype.long", new AbstractEncodableObjectFactory.IFactory(){

            @Override
            public EncodableObjectBase createEO(XMLContext xmlContext) {
                return new EOLong(xmlContext);
            }
        });
        this.addConstructor("frame.datatype.string", new AbstractEncodableObjectFactory.IFactory(){

            @Override
            public EncodableObjectBase createEO(XMLContext xmlContext) {
                return new EOString(xmlContext);
            }
        });
    }
}

