/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding;

import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;

public class EOValue
extends EOEncodableObject {
    public static final String XML_NAME = "Value";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private String value;

    public EOValue(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
        this.value = "";
    }

    public EOValue() {
        super(XML_NAME);
        this.value = "";
    }

    public EOValue(String value) {
        super(XML_NAME);
        this.value = value;
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, "value", this.value);
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean success = false;
        if (name.equals("value")) {
            this.value = value;
            success = true;
        }
        return success;
    }

    @Override
    protected boolean hasChildren() {
        return false;
    }

    @Override
    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    public String toString() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public int getIntValue() {
        return Integer.parseInt(this.value);
    }

    public long getLongValue() {
        return Long.parseLong(this.value);
    }

    public double getDoubleValue() {
        return Double.parseDouble(this.value);
    }

    public float getFloatValue() {
        return Float.parseFloat(this.value);
    }

    public boolean getBooleanValue() {
        return this.value.equalsIgnoreCase(TRUE);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(int value) {
        this.value = Integer.toString(value);
    }

    public void setValue(long value) {
        this.value = Long.toString(value);
    }

    public void setValue(double value) {
        this.value = Double.toString(value);
    }

    public void setValue(float value) {
        this.value = Float.toString(value);
    }

    public void setValue(boolean value) {
        this.value = Boolean.toString(value);
    }
}

