/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding;

import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EOOfUnknownType
extends EOEncodableObject {
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final List<EncodableObjectBase> children = new ArrayList<EncodableObjectBase>();

    public EOOfUnknownType(String originalXMLName) {
        super(originalXMLName);
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            this.appendAttrToXML(writeContext, entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        this.attributes.put(name, value);
        return true;
    }

    @Override
    protected boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        for (EncodableObjectBase child : this.children) {
            child.writeXMLBody(writeContext, depth);
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        this.children.add(newChild);
        return true;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<EncodableObjectBase> getChildren() {
        return this.children;
    }

    public EncodableObjectBase convert(IEncodableObjectFactory factory) {
        EncodableObjectBase encodableObjectBase;
        XMLContext dummyXMLContext = new XMLContext(null, null);
        try {
            encodableObjectBase = factory.createEncodableObject(this.getTag(), dummyXMLContext);
            if (encodableObjectBase != null) {
                for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                    encodableObjectBase.setAttribute(entry.getKey(), entry.getValue());
                }
                for (EncodableObjectBase child : this.getChildren()) {
                    encodableObjectBase.addChild(child);
                }
            }
        }
        catch (EXDecoderException e) {
            encodableObjectBase = this;
        }
        return encodableObjectBase;
    }
}

