/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding;

import de.plans.lib.xml.encoding.AbstractEncodableObjectFactory;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOEncodableObjectWithRole;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EOGenericMessage
extends EOEncodableObject {
    public static final String XML_NAME = "GenericMessage";
    private static final String ATTR_TAG_MSG_ID = "msgID";
    private String msgID = null;
    private boolean sortAttributes = false;
    Map<String, String> attributes = new HashMap<String, String>();
    List<EncodableObjectBase> childs = new ArrayList<EncodableObjectBase>();
    public static final AbstractEncodableObjectFactory.IFactory EOModuleFactory = new AbstractEncodableObjectFactory.IFactory(){

        @Override
        public EncodableObjectBase createEO(XMLContext xmlContext) {
            return new EOModuleAttribute(xmlContext);
        }
    };
    public static final String EOModule_XML_NAME = "pslib.datatype.eomodule";

    public EOGenericMessage() {
        super(XML_NAME);
    }

    public EOGenericMessage(String xmlName) {
        super(xmlName);
    }

    public EOGenericMessage(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public EOGenericMessage(String xmlName, XMLContext xmlContext) {
        super(xmlName, xmlContext);
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        if (name.equals(ATTR_TAG_MSG_ID)) {
            if (this.msgID == null) {
                this.msgID = value;
            }
        } else {
            this.attributes.put(name.intern(), value);
        }
        return true;
    }

    @Override
    protected boolean hasChildren() {
        return true;
    }

    @Override
    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        int i = 0;
        while (i < this.childs.size()) {
            EncodableObjectBase eo = this.childs.get(i);
            eo.writeXMLBody(writeContext, depth);
            ++i;
        }
        EOModuleAttribute em = new EOModuleAttribute(this.msgID == null ? "" : this.msgID, ATTR_TAG_MSG_ID);
        em.writeXMLBody(writeContext, depth);
        Set<Map.Entry<String, String>> attributeSet = this.attributes.entrySet();
        Iterator<Map.Entry<String, String>> i2 = null;
        if (this.sortAttributes) {
            ArrayList<Map.Entry<String, String>> attributeList = new ArrayList<Map.Entry<String, String>>(attributeSet);
            Collections.sort(attributeList, AttributeComparator.INSTANCE);
            i2 = attributeList.iterator();
        } else {
            i2 = attributeSet.iterator();
        }
        while (i2.hasNext()) {
            Map.Entry<String, String> e = i2.next();
            String key = e.getKey() != null ? e.getKey().toString() : "";
            String value = e.getValue() != null ? e.getValue().toString() : "";
            em = new EOModuleAttribute(value, key);
            em.writeXMLBody(writeContext, depth);
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        if (newChild instanceof EOModuleAttribute) {
            EOModuleAttribute em = (EOModuleAttribute)newChild;
            if (em.getRole().equals(ATTR_TAG_MSG_ID)) {
                if (this.msgID == null) {
                    this.msgID = em.getValueString();
                }
            } else {
                this.attributes.put(em.getRole().intern(), em.getValueString());
            }
        } else {
            this.childs.add(newChild);
        }
        return true;
    }

    public String getAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            return this.attributes.get(name);
        }
        return null;
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name.intern(), value);
    }

    public void setMsgID(String msgID) {
        this.msgID = msgID;
    }

    public String getMsgID() {
        return this.msgID;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<EncodableObjectBase> getChilds() {
        return this.childs;
    }

    public void setAttributes(Map<String, String> map) {
        this.attributes = map;
    }

    public void setChilds(List<? extends EncodableObjectBase> list) {
        this.childs = new ArrayList<EncodableObjectBase>(list);
    }

    public void sortAttributes() {
        this.sortAttributes = true;
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
    }

    private static class AttributeComparator
    implements Comparator<Map.Entry<String, String>> {
        public static final AttributeComparator INSTANCE = new AttributeComparator();

        private AttributeComparator() {
        }

        @Override
        public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    }

    private static class EOModuleAttribute
    extends EOEncodableObjectWithRole {
        private static final String DEFAULT_ROLE = "valueString";
        public static final String XML_NAME = "pslib.datatype.eomodule";
        private String valueString;

        public EOModuleAttribute() {
            super("pslib.datatype.eomodule");
            this.setRole(DEFAULT_ROLE);
        }

        public EOModuleAttribute(XMLContext xmlContext) {
            super("pslib.datatype.eomodule", xmlContext);
        }

        public EOModuleAttribute(String valueString) {
            super("pslib.datatype.eomodule");
            this.valueString = valueString;
            this.setRole(DEFAULT_ROLE);
        }

        public EOModuleAttribute(String valueString, String role) {
            super("pslib.datatype.eomodule");
            this.valueString = valueString;
            this.setRole(role);
        }

        public String getValueString() {
            return this.valueString;
        }

        @Override
        protected boolean hasChildren() {
            return false;
        }

        @Override
        protected boolean addChildFromXML(EncodableObjectBase newChild) {
            return false;
        }

        @Override
        protected void writeContentToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
            this.appendContentToXML(writeContext, this.valueString);
        }

        @Override
        protected boolean setContentFromXML(String value) {
            if (this.valueString == null) {
                this.valueString = value;
            }
            return true;
        }

        @Override
        protected boolean hasContent() {
            return true;
        }
    }
}

