/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.html;

import de.plans.lib.util.html.HTMLText;
import de.plans.lib.util.html.IF_HTMLText;
import java.util.ArrayList;
import java.util.List;

public class HTMLTableCell {
    private final List content = new ArrayList();
    private boolean isHeaderCell = false;
    private String cellAttribtes = null;

    public HTMLTableCell() {
    }

    public HTMLTableCell(boolean isHeader) {
        this.isHeaderCell = isHeader;
    }

    public HTMLTableCell(String value) {
        this.addContent(value);
    }

    public HTMLTableCell(String value, boolean isHeader) {
        this.addContent(value);
        this.isHeaderCell = isHeader;
    }

    public HTMLTableCell(IF_HTMLText value) {
        this.addContent(value);
    }

    public HTMLTableCell setAttributes(String value) {
        this.cellAttribtes = value;
        return this;
    }

    public HTMLTableCell addContent(String value) {
        return this.addContent(new HTMLText(value));
    }

    public HTMLTableCell addContent(IF_HTMLText value) {
        this.content.add(value);
        return this;
    }

    public String getHTMLText() {
        if (this.isHeaderCell) {
            if (this.cellAttribtes != null) {
                return "<TH " + this.cellAttribtes + ">" + this.getContent() + "</TH>";
            }
            return "<TH>" + this.getContent() + "</TH>";
        }
        if (this.cellAttribtes != null) {
            return "<TD " + this.cellAttribtes + ">" + this.getContent() + "</TD>";
        }
        return "<TD>" + this.getContent() + "</TD>";
    }

    private String getContent() {
        if (this.content.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.content.size()) {
            result.append(((IF_HTMLText)this.content.get(i)).getHTMLText());
            ++i;
        }
        return result.toString();
    }
}

