/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

public class StacktraceConverter {
    public static final String LineSep;

    static {
        String propertyValue = null;
        try {
            propertyValue = System.getProperty("line.separator");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LineSep = propertyValue != null ? propertyValue : "\n";
    }

    public static String stacktraceToString(Throwable e) {
        StringBuilder sb = new StringBuilder();
        StacktraceConverter.appendSingleException(e, "", sb);
        Throwable cause = e.getCause();
        while (cause != null) {
            StacktraceConverter.appendSingleException(cause, "Caused by: ", sb);
            cause = cause != cause.getCause() ? cause.getCause() : null;
        }
        return sb.toString();
    }

    private static void appendSingleException(Throwable e, String headerLinePrefix, StringBuilder sb) {
        sb.append(headerLinePrefix);
        sb.append(e.getClass().getName());
        sb.append(": ");
        if (e.getLocalizedMessage() != null) {
            sb.append(e.getLocalizedMessage());
        } else {
            sb.append("<no message>");
        }
        sb.append(LineSep);
        StackTraceElement[] stackTraceElements = e.getStackTrace();
        if (stackTraceElements != null) {
            StackTraceElement[] stackTraceElementArray = stackTraceElements;
            int n = stackTraceElements.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                sb.append("\tat ");
                if (stackTraceElement.getClassName() != null) {
                    sb.append(stackTraceElement.getClassName());
                } else {
                    sb.append("<unknown class>");
                }
                sb.append(".");
                if (stackTraceElement.getMethodName() != null) {
                    sb.append(stackTraceElement.getMethodName());
                } else {
                    sb.append("<unknown method>");
                }
                sb.append("(");
                if (stackTraceElement.getFileName() != null) {
                    sb.append(stackTraceElement.getFileName());
                    sb.append(":");
                    sb.append(stackTraceElement.getLineNumber());
                } else {
                    sb.append("<unknown file>");
                }
                sb.append(")");
                sb.append(LineSep);
                ++n2;
            }
        }
    }
}

