/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import de.plans.lib.util.INotificationBusListener;
import de.plans.lib.util.Notification;
import java.util.StringTokenizer;
import java.util.Vector;

public class NotificationBus {
    private final SubscriptionTreeElement subscriptionRoot = new SubscriptionTreeElement("subscriptionRoot");
    private final SubscriptionTreeElement uncaughtRoot = new SubscriptionTreeElement("uncaughtRoot");

    public void subscribeListener(INotificationBusListener listener, String notificationtype, String serverID) {
        String treePath = this.parseToTokenString(new Notification(notificationtype, serverID, null));
        SubscriptionTreeElement responsibleNode = this.getResponsibleNode(this.subscriptionRoot, treePath);
        responsibleNode.addListener(listener);
    }

    public void unsubscribeListener(INotificationBusListener listener, String notificationtype, String serverID) {
        String treePath = this.parseToTokenString(new Notification(notificationtype, serverID, null));
        SubscriptionTreeElement responsibleNode = this.getResponsibleNode(this.subscriptionRoot, treePath);
        responsibleNode.removeListener(listener);
    }

    public void postNotification(Notification notification) {
        Vector notificationListeners = new Vector();
        this.subscriptionRoot.collectListeners(new StringTokenizer(this.parseToTokenString(notification), "."), notificationListeners);
        this.subscriptionRoot.collectListeners(new StringTokenizer(this.parseToTokenString(new Notification(notification.getType(), null, null)), "."), notificationListeners);
        if (notificationListeners.size() == 0) {
            this.uncaughtRoot.collectListeners(new StringTokenizer(this.parseToTokenString(notification), "."), notificationListeners);
            this.uncaughtRoot.collectListeners(new StringTokenizer(this.parseToTokenString(new Notification(notification.getType(), null, null)), "."), notificationListeners);
        }
        int i = 0;
        while (i < notificationListeners.size()) {
            ((INotificationBusListener)notificationListeners.get(i)).receiveNotification(notification);
            ++i;
        }
    }

    public void subscribeNonDeliverableListener(INotificationBusListener listener, String notificationtype, String serverID) {
        String treePath = this.parseToTokenString(new Notification(notificationtype, serverID, null));
        SubscriptionTreeElement responsibleNode = this.getResponsibleNode(this.uncaughtRoot, treePath);
        responsibleNode.addListener(listener);
    }

    public void unsubscribeNonDeliverableListener(INotificationBusListener listener, String notificationtype, String serverID) {
        String treePath = this.parseToTokenString(new Notification(notificationtype, serverID, null));
        SubscriptionTreeElement responsibleNode = this.getResponsibleNode(this.uncaughtRoot, treePath);
        responsibleNode.removeListener(listener);
    }

    public void unsubscribeEverything(INotificationBusListener listener) {
        this.subscriptionRoot.removeListener(listener);
        this.uncaughtRoot.removeListener(listener);
    }

    private String parseToTokenString(Notification notification) {
        String tokenString = null;
        String serverIDString = notification.getServerID();
        String typeString = notification.getType();
        if (serverIDString == null) {
            serverIDString = "@ANY";
        }
        tokenString = "." + serverIDString;
        if (typeString != null) {
            tokenString = String.valueOf(tokenString) + "." + typeString;
        }
        return tokenString;
    }

    private SubscriptionTreeElement getResponsibleNode(SubscriptionTreeElement node, String treePath) {
        StringTokenizer st = new StringTokenizer(treePath, ".");
        do {
            String searchString;
            SubscriptionTreeElement foundNode;
            if ((foundNode = node.find(searchString = st.nextToken())) == null) {
                node = foundNode = node.addsubElement(searchString);
            }
            node = foundNode;
        } while (st.hasMoreTokens());
        return node;
    }

    private class SubscriptionTreeElement {
        private String name = null;
        private final Vector subElements = new Vector();
        private final Vector listeners = new Vector();

        public SubscriptionTreeElement(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addListener(INotificationBusListener listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
            int i = 0;
            while (i < this.subElements.size()) {
                SubscriptionTreeElement currentSubElement = (SubscriptionTreeElement)this.subElements.get(i);
                currentSubElement.addListener(listener);
                ++i;
            }
        }

        private void addListener(Vector listeners) {
            int i = 0;
            while (i < listeners.size()) {
                this.addListener((INotificationBusListener)listeners.get(i));
                ++i;
            }
        }

        public void removeListener(INotificationBusListener listener) {
            this.listeners.remove(listener);
            int i = 0;
            while (i < this.subElements.size()) {
                SubscriptionTreeElement currentSubElement = (SubscriptionTreeElement)this.subElements.get(i);
                currentSubElement.removeListener(listener);
                ++i;
            }
        }

        public SubscriptionTreeElement addsubElement(String name) {
            SubscriptionTreeElement newSubElement = new SubscriptionTreeElement(name);
            newSubElement.addListener(this.listeners);
            this.subElements.add(newSubElement);
            return newSubElement;
        }

        public SubscriptionTreeElement find(String name) {
            int i = 0;
            while (i < this.subElements.size()) {
                if (((SubscriptionTreeElement)this.subElements.get(i)).getName().compareTo(name) == 0) {
                    return (SubscriptionTreeElement)this.subElements.get(i);
                }
                ++i;
            }
            return null;
        }

        public void collectListeners(StringTokenizer st, Vector eventListeners) {
            boolean addOwnListeners = false;
            if (st.hasMoreTokens()) {
                SubscriptionTreeElement responsibleSubElement = this.find(st.nextToken());
                if (responsibleSubElement != null) {
                    responsibleSubElement.collectListeners(st, eventListeners);
                } else {
                    addOwnListeners = true;
                }
            } else {
                addOwnListeners = true;
            }
            if (addOwnListeners) {
                int i = 0;
                while (i < this.listeners.size()) {
                    if (!eventListeners.contains(this.listeners.get(i))) {
                        eventListeners.add(this.listeners.get(i));
                    }
                    ++i;
                }
            }
        }
    }
}

