/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

public class Hex {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Hex() {
    }

    public static char[] asChars(byte in) {
        return Hex.asChars(in, 2);
    }

    public static char[] asChars(byte in, int length) {
        char[] out = new char[length--];
        int i = length;
        while (i > -1) {
            out[i] = DIGITS[(byte)(in & 0xF)];
            in = (byte)(in >> 4);
            --i;
        }
        return out;
    }

    public static char[] asChars(int in) {
        return Hex.asChars(in, 8);
    }

    public static char[] asChars(int in, int length) {
        char[] out = new char[length--];
        int i = length;
        while (i > -1) {
            out[i] = DIGITS[(byte)(in & 0xF)];
            in >>= 4;
            --i;
        }
        return out;
    }

    public static char[] asChars(long in) {
        return Hex.asChars(in, 16);
    }

    public static char[] asChars(long in, int length) {
        char[] out = new char[length--];
        int i = length;
        while (i > -1) {
            out[i] = DIGITS[(byte)(in & 0xFL)];
            in >>= 4;
            --i;
        }
        return out;
    }

    public static char[] asChars(short in) {
        return Hex.asChars(in, 4);
    }

    public static char[] asChars(short in, int length) {
        char[] out = new char[length--];
        int i = length;
        while (i > -1) {
            out[i] = DIGITS[(byte)(in & 0xF)];
            in = (short)(in >> 4);
            --i;
        }
        return out;
    }

    public static char[] asChars(byte[] b) {
        int len = b.length << 1;
        char[] out = new char[len--];
        int i = b.length - 1;
        while (i > -1) {
            out[len--] = DIGITS[(byte)(b[i] & 0xF)];
            out[len--] = DIGITS[(byte)((b[i] & 0xF0) >> 4)];
            --i;
        }
        return out;
    }

    public static long parseLong(String s) throws NullPointerException {
        if (s == null) {
            throw new NullPointerException("The argument \"s\" was null.");
        }
        s = s.toLowerCase();
        long out = 0L;
        int shifts = 0;
        int i = 0;
        while (i < s.length() && shifts < 16) {
            char c = s.charAt(i);
            if (c > '/' && c < ':') {
                out <<= 4;
                shifts = (byte)(shifts + 1);
                out |= (long)(c - 48);
            } else if (c > '`' && c < 'g') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= (long)(c - 87);
            }
            ++i;
        }
        return out;
    }

    public static int parseInt(String s) throws NullPointerException {
        if (s == null) {
            throw new NullPointerException("The argument \"s\" was null.");
        }
        s = s.toLowerCase();
        int out = 0;
        int shifts = 0;
        int i = 0;
        while (i < s.length() && shifts < 8) {
            char c = s.charAt(i);
            if (c > '/' && c < ':') {
                out <<= 4;
                shifts = (byte)(shifts + 1);
                out |= c - 48;
            } else if (c > '`' && c < 'g') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= c - 87;
            }
            ++i;
        }
        return out;
    }

    public static short parseShort(String s) throws NullPointerException {
        if (s == null) {
            throw new NullPointerException("The argument \"s\" was null.");
        }
        s = s.toLowerCase();
        short out = 0;
        int shifts = 0;
        int i = 0;
        while (i < s.length() && shifts < 4) {
            char c = s.charAt(i);
            if (c > '/' && c < ':') {
                out = (short)(out << 4);
                shifts = (byte)(shifts + 1);
                out = (short)(out | c - 48);
            } else if (c > '`' && c < 'g') {
                shifts = (byte)(shifts + 1);
                out = (short)(out << 4);
                out = (short)(out | c - 87);
            }
            ++i;
        }
        return out;
    }

    public static byte parseByte(String s) throws NullPointerException {
        if (s == null) {
            throw new NullPointerException("The argument \"s\" was null.");
        }
        s = s.toLowerCase();
        byte out = 0;
        int shifts = 0;
        int i = 0;
        while (i < s.length() && shifts < 2) {
            char c = s.charAt(i);
            if (c > '/' && c < ':') {
                out = (byte)(out << 4);
                shifts = (byte)(shifts + 1);
                out = (byte)(out | c - 48);
            } else if (c > '`' && c < 'g') {
                shifts = (byte)(shifts + 1);
                out = (byte)(out << 4);
                out = (byte)(out | c - 87);
            }
            ++i;
        }
        return out;
    }
}

