/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import de.plans.lib.util.html.HTMLPage;
import java.util.Calendar;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class HTMLLogFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        String separator = "</TD>\n<TD>";
        StringBuffer result = new StringBuffer();
        result.append("<TR align=\"CENTER\" " + this.getLevelSpecificColorString(record.getLevel()) + ">\n<TD>");
        this.dateToISO8601String(record.getMillis(), result);
        result.append(separator).append(record.getMillis()).append(separator);
        result.append(record.getSequenceNumber()).append(separator);
        this.escape(record.getLoggerName(), result);
        result.append(separator);
        this.escape(record.getLevel().toString(), result);
        result.append(separator);
        this.escape(record.getSourceClassName(), result);
        result.append(separator);
        this.escape(record.getSourceMethodName(), result);
        result.append(separator).append(record.getThreadID()).append(separator);
        if (record.getMessage() != null) {
            this.escape(this.formatMessage(record), result);
        } else {
            result.append("&nbsp;");
        }
        result.append(separator);
        Throwable t = record.getThrown();
        if (t != null) {
            result.append(t.getMessage());
            int i = 0;
            while (i < t.getStackTrace().length) {
                StackTraceElement s = t.getStackTrace()[i];
                String msg = "<br>" + s.getClassName() + ":" + s.getMethodName() + "() line " + s.getLineNumber();
                result.append(msg);
                ++i;
            }
        } else {
            result.append("&nbsp;");
        }
        result.append("</TD>\n</TR>");
        return result.toString();
    }

    private void dateToISO8601String(long millis, StringBuffer buffer) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        buffer.append(calendar.get(1));
        buffer.append('-');
        this.append2Digits(calendar.get(2) + 1, buffer);
        buffer.append('-');
        this.append2Digits(calendar.get(5), buffer);
        buffer.append('T');
        this.append2Digits(calendar.get(11), buffer);
        buffer.append(':');
        this.append2Digits(calendar.get(12), buffer);
        buffer.append(':');
        this.append2Digits(calendar.get(13), buffer);
    }

    private void escape(String input, StringBuffer buffer) {
        if (input == null) {
            return;
        }
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            switch (c) {
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
    }

    private void append2Digits(int number, StringBuffer buffer) {
        if (number < 10) {
            buffer.append('0');
        }
        buffer.append(number);
    }

    @Override
    public String getHead(Handler h) {
        String head = new HTMLPage().setTitle("Log").getHeaderString();
        head = String.valueOf(head) + "<body><table border=\"1\">";
        head = String.valueOf(head) + "<TR><TH>Date</TH><TH>Millis</TH><TH>Sequence</TH><TH>Logger</TH><TH>Level</TH>";
        head = String.valueOf(head) + "<TH>Class</TH><TH>Method</TH><TH>Thread</TH><TH>Message</TH><TH>Exception</TH></TR>";
        return head;
    }

    @Override
    public String getTail(Handler h) {
        return "</table></body></html>";
    }

    private String getLevelSpecificColorString(Level l) {
        if (l.intValue() == Level.SEVERE.intValue()) {
            return " bgcolor=\"FF0000\" ";
        }
        if (l.intValue() == Level.WARNING.intValue()) {
            return " bgcolor=\"00FFFF\" ";
        }
        return "";
    }
}

