/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat;

@Plugin(name="EclipseWorkbenchLayout", category="Core", elementType="layout", printObject=true)
public class EclipseWorkbenchLogLayout
extends AbstractStringLayout {
    static ThreadLocal<FastDateFormat> tlDateFormatters = new ThreadLocal<FastDateFormat>(){

        @Override
        protected FastDateFormat initialValue() {
            return FixedDateFormat.FixedFormat.ISO8601.getFastDateFormat();
        }
    };
    private static final Charset CHARSET = Charset.forName("UTF-8");

    @PluginFactory
    public static EclipseWorkbenchLogLayout createLayout() {
        return new EclipseWorkbenchLogLayout();
    }

    private static FastDateFormat getDateFormatter() {
        return tlDateFormatters.get();
    }

    public EclipseWorkbenchLogLayout() {
        super(CHARSET, EclipseWorkbenchLogLayout.buildHeader().getBytes(CHARSET), null);
    }

    public String toSerializable(LogEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append("!ENTRY ");
        sb.append(e.getLoggerName());
        Level lv = e.getLevel();
        if (lv.isMoreSpecificThan(Level.ERROR)) {
            sb.append(" 4 ");
        } else if (lv.isMoreSpecificThan(Level.WARN)) {
            sb.append(" 2 ");
        } else {
            sb.append(" 1 ");
        }
        sb.append(Integer.toString(lv.intLevel()));
        sb.append(" ");
        EclipseWorkbenchLogLayout.getDateFormatter().format((Object)new Date(e.getTimeMillis()), sb, null);
        sb.append("\n");
        sb.append("!MESSAGE ");
        sb.append(e.getMessage());
        sb.append("\n");
        ThrowableProxy thrownProxy = e.getThrownProxy();
        if (thrownProxy != null) {
            ExtendedStackTraceElement[] tsa;
            sb.append("!STACK 0");
            sb.append("\n");
            ExtendedStackTraceElement[] extendedStackTraceElementArray = tsa = thrownProxy.getExtendedStackTrace();
            int n = tsa.length;
            int n2 = 0;
            while (n2 < n) {
                ExtendedStackTraceElement element = extendedStackTraceElementArray[n2];
                sb.append(element.toString());
                sb.append("\n");
                ++n2;
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    private static String buildHeader() {
        StringBuilder sb = new StringBuilder();
        Date date = new Date(System.currentTimeMillis());
        sb.append("!SESSION ");
        EclipseWorkbenchLogLayout.getDateFormatter().format((Object)date, sb, null);
        sb.append(" -----------------------------------------------\n");
        sb.append("Start of Session: ");
        EclipseWorkbenchLogLayout.getDateFormatter().format((Object)date, sb, null);
        sb.append("\n");
        Properties props = System.getProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            sb.append(entry.getKey() != null ? entry.getKey().toString() : "NULL-Key");
            sb.append("=");
            sb.append(entry.getValue() != null ? entry.getValue().toString() : "NULL-Value");
            sb.append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }
}

