/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static int getDays(Date d1, Date d2) {
        int elapsed = 0;
        Calendar gc1 = Calendar.getInstance();
        Calendar gc2 = Calendar.getInstance();
        if (d2.after(d1)) {
            gc2.setTime((Date)d2.clone());
            gc1.setTime((Date)d1.clone());
        } else {
            gc2.setTime((Date)d1.clone());
            gc1.setTime((Date)d2.clone());
        }
        gc1.clear(14);
        gc1.clear(13);
        gc1.clear(12);
        gc1.clear(11);
        gc2.clear(14);
        gc2.clear(13);
        gc2.clear(12);
        gc2.clear(11);
        while (gc1.before(gc2)) {
            gc1.add(5, 1);
            ++elapsed;
        }
        return elapsed;
    }

    public static int getWorkingDays(Date d1, Date d2) {
        int elapsed = 0;
        Calendar gc1 = Calendar.getInstance();
        Calendar gc2 = Calendar.getInstance();
        if (d2.after(d1)) {
            gc2.setTime((Date)d2.clone());
            gc1.setTime((Date)d1.clone());
        } else {
            gc2.setTime((Date)d1.clone());
            gc1.setTime((Date)d2.clone());
        }
        int y1 = gc1.get(1);
        int m1 = gc1.get(2);
        int dm1 = gc1.get(5);
        gc1.clear();
        gc1.set(y1, m1, dm1);
        int y2 = gc2.get(1);
        int m2 = gc2.get(2);
        int dm2 = gc2.get(5);
        gc2.clear();
        gc2.set(y2, m2, dm2);
        while (gc1.before(gc2)) {
            gc1.add(5, 1);
            int dayOfWeek = gc1.get(7);
            if (dayOfWeek == 7 || dayOfWeek == 1) continue;
            ++elapsed;
        }
        return elapsed;
    }

    public static Date addWorkingDays(Date d, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime((Date)d.clone());
        if (days > 0) {
            int additionalDays = days + 2 * (days / 5);
            int remainingDays = days % 5;
            int dayOfWeek = c.get(7);
            if (dayOfWeek == 1) {
                ++additionalDays;
            } else {
                switch (dayOfWeek) {
                    case 2: {
                        dayOfWeek = 5;
                        break;
                    }
                    case 3: {
                        dayOfWeek = 4;
                        break;
                    }
                    case 4: {
                        dayOfWeek = 3;
                        break;
                    }
                    case 5: {
                        dayOfWeek = 2;
                        break;
                    }
                    case 6: {
                        dayOfWeek = 1;
                        break;
                    }
                    case 7: {
                        dayOfWeek = 0;
                    }
                }
                if (dayOfWeek - remainingDays <= 0) {
                    additionalDays += 2;
                }
            }
            c.add(5, additionalDays);
        } else if (days < 0) {
            int daysToGoBack = -days + 2 * (-days / 5);
            int remainingDays = -days % 5;
            int dayOfWeek = c.get(7);
            if (dayOfWeek == 7) {
                ++daysToGoBack;
            } else {
                switch (dayOfWeek) {
                    case 2: {
                        dayOfWeek = 1;
                        break;
                    }
                    case 3: {
                        dayOfWeek = 2;
                        break;
                    }
                    case 4: {
                        dayOfWeek = 3;
                        break;
                    }
                    case 5: {
                        dayOfWeek = 4;
                        break;
                    }
                    case 6: {
                        dayOfWeek = 5;
                        break;
                    }
                    case 1: {
                        dayOfWeek = 0;
                    }
                }
                if (dayOfWeek - remainingDays <= 0) {
                    daysToGoBack += 2;
                }
            }
            c.add(5, -daysToGoBack);
        }
        return c.getTime();
    }

    public static boolean equals(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 == null || d2 == null) {
            return false;
        }
        return d1.equals(d2);
    }

    public static int compare(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return 0;
        }
        if (d1 == null) {
            return 1;
        }
        if (d2 == null) {
            return -1;
        }
        return d1.compareTo(d2);
    }
}

