/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.structure;

import de.plans.lib.structure.AbstractStructure;
import de.plans.lib.structure.AbstractStructureTraverserCheckVisitedElements;
import de.plans.lib.structure.IRelative;
import de.plans.lib.structure.IStructureElement;
import de.plans.lib.structure.IStructureElementVisitor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class StructureTraverserAllLowerElements
extends AbstractStructureTraverserCheckVisitedElements {
    private final IRelative relative;

    public StructureTraverserAllLowerElements(AbstractStructure structure, IStructureElementVisitor visitor, IRelative relative) {
        super(structure, visitor);
        assert (relative != null) : "relative is null";
        this.relative = relative;
    }

    public boolean traverse(Collection startElements, boolean mode) {
        Set visitedElements = this.initializeVisitedElements(mode);
        return this.traverse(startElements, visitedElements);
    }

    public boolean traverse(Collection startElements, Set visitedElements) {
        boolean cancel = false;
        Iterator i = startElements.iterator();
        while (!cancel && i.hasNext()) {
            IStructureElement startElement = (IStructureElement)i.next();
            cancel |= this.traverse(startElement, visitedElements);
        }
        return cancel;
    }

    private boolean traverse(IStructureElement startElement, Set visitedElements) {
        boolean cancled = false;
        boolean isToVisit = this.isToVisit(startElement, visitedElements);
        if (isToVisit) {
            cancled |= this.visit(startElement);
            Iterator i = this.relative.getPrecessors(startElement).iterator();
            while (!cancled && i.hasNext()) {
                IStructureElement precessor = (IStructureElement)i.next();
                cancled |= this.traverse(precessor, visitedElements);
            }
        }
        return cancled;
    }
}

