/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.structure;

import de.plans.lib.structure.AbstractStructure;
import de.plans.lib.structure.IStructureElement;
import de.plans.lib.structure.IStructureProviderRW;
import de.plans.lib.structure.Relation;
import de.plans.lib.structure.StructuredRelation;
import java.util.ArrayList;
import java.util.Collection;

public class StructureDelegating
extends AbstractStructure {
    private final IStructureProviderRW structureProvider;

    public StructureDelegating(IStructureProviderRW structureProvider) {
        this.structureProvider = structureProvider;
    }

    public Collection getAllDelegatedAncestors(Collection startElements) {
        Collection delegatingStartElements = this.getDelegatingElements(startElements);
        return this.getDelegatedElements(this.getAllAncestors(delegatingStartElements));
    }

    public Collection getAllDelegatedDescendants(Collection startElements) {
        Collection delegatingStartElements = this.getDelegatingElements(startElements);
        return this.getDelegatedElements(this.getAllDescendants(delegatingStartElements));
    }

    private Collection getDelegatingElements(Collection delegatedElements) {
        ArrayList<StructureElementDelegate> delegatingElements = new ArrayList<StructureElementDelegate>(delegatedElements.size());
        for (Object delegated : delegatedElements) {
            delegatingElements.add(new StructureElementDelegate(delegated));
        }
        return delegatingElements;
    }

    private Collection getDelegatedElements(Collection delegatingElements) {
        ArrayList<Object> delegatedElements = new ArrayList<Object>(delegatingElements.size());
        for (StructureElementDelegate delegate : delegatingElements) {
            delegatedElements.add(delegate.getDelegated());
        }
        return delegatedElements;
    }

    @Override
    protected Collection getAllElements() {
        Collection allDelegatedElements = this.structureProvider.getAllElements();
        return this.getDelegatingElements(allDelegatedElements);
    }

    @Override
    protected int getNumberOfElements() {
        return this.structureProvider.getNumberOfElements();
    }

    @Override
    protected void createRelation(StructuredRelation relation) {
        StructureElementDelegate childDelegate = (StructureElementDelegate)relation.getStructuredChild();
        StructureElementDelegate parentDelegate = (StructureElementDelegate)relation.getStructuredParent();
        Relation delegatedRelation = new Relation(childDelegate.getDelegated(), parentDelegate.getDelegated());
        this.structureProvider.createRelation(delegatedRelation);
    }

    @Override
    protected void removeRelation(StructuredRelation relation) {
        StructureElementDelegate childDelegate = (StructureElementDelegate)relation.getStructuredChild();
        StructureElementDelegate parentDelegate = (StructureElementDelegate)relation.getStructuredParent();
        Relation delegatedRelation = new Relation(childDelegate.getDelegated(), parentDelegate.getDelegated());
        this.structureProvider.removeRelation(delegatedRelation);
    }

    @Override
    protected boolean isAncestor(IStructureElement ancestor, IStructureElement descendant) {
        StructureElementDelegate ancestorDelegate = (StructureElementDelegate)ancestor;
        StructureElementDelegate descendantDelegate = (StructureElementDelegate)descendant;
        return this.structureProvider.isAncestor(ancestorDelegate.getDelegated(), descendantDelegate.getDelegated());
    }

    @Override
    protected int getStructureTypeHint() {
        return this.structureProvider.getStructureTypeHint();
    }

    private class StructureElementDelegate
    implements IStructureElement {
        private final Object delegated;

        public StructureElementDelegate(Object delegated) {
            this.delegated = delegated;
        }

        public Object getDelegated() {
            return this.delegated;
        }

        @Override
        public Collection getParents() {
            return StructureDelegating.this.getDelegatingElements(StructureDelegating.this.structureProvider.getParents(this.delegated));
        }

        @Override
        public Collection getChildren() {
            return StructureDelegating.this.getDelegatingElements(StructureDelegating.this.structureProvider.getChildren(this.delegated));
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof StructureElementDelegate) {
                StructureElementDelegate delegate = (StructureElementDelegate)obj;
                return this.delegated.equals(delegate.getDelegated());
            }
            return false;
        }

        public int hashCode() {
            return this.delegated.hashCode();
        }

        public String toString() {
            return "StructureElementDelegate to " + this.delegated.toString();
        }
    }
}

