/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.lic;

import de.plans.lib.lic.ValidityHelper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UserLicense {
    private final String applicationName;
    private int licenseCount;
    private final List<ValidityHelper.NrOfLicensesAndValidity> validityPeriods = new ArrayList<ValidityHelper.NrOfLicensesAndValidity>();

    public UserLicense(String applicationName, int licenseCount, long validFromDate, long expiryDate) {
        this.applicationName = applicationName;
        this.licenseCount = licenseCount;
        if (licenseCount != 0) {
            this.validityPeriods.add(new ValidityHelper.NrOfLicensesAndValidity(licenseCount, validFromDate, expiryDate));
        }
    }

    public void addLicenses(int licenseCount_, long validFromDate, long expiryDate) {
        this.licenseCount = this.licenseCount == -1 || licenseCount_ == -1 ? -1 : (this.licenseCount += licenseCount_);
        if (licenseCount_ != 0) {
            this.validityPeriods.add(new ValidityHelper.NrOfLicensesAndValidity(licenseCount_, validFromDate, expiryDate));
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public int getLicenseCount() {
        this.updateLicenseCount();
        return this.licenseCount;
    }

    public Timestamp getExpiryDateForSingleLicense() {
        ValidityHelper.NrOfLicensesAndValidity validity = this.getValidityForSingleLicense();
        if (validity.nrOfLicenses == -1L || validity.nrOfLicenses > 0L) {
            if (validity.expiryDate != -1L) {
                return new Timestamp(validity.expiryDate);
            }
            return ValidityHelper.EXPIRES_NEVER_TIMESTAMP;
        }
        return null;
    }

    public Timestamp getValidFromDateForSingleLicense() {
        ValidityHelper.NrOfLicensesAndValidity validity = this.getValidityForSingleLicense();
        if (validity.nrOfLicenses == -1L || validity.nrOfLicenses > 0L) {
            if (validity.validFromDate != -1L) {
                return new Timestamp(validity.validFromDate);
            }
            return ValidityHelper.VALID_SINCE_EVER_TIMESTAMP;
        }
        return null;
    }

    private ValidityHelper.NrOfLicensesAndValidity getValidityForSingleLicense() {
        this.updateLicenseCount();
        return ValidityHelper.getMaximumValidityForAtLeastOneLicense(this.validityPeriods);
    }

    private void updateLicenseCount() {
        long systemTime = System.currentTimeMillis() - 86400000L;
        int newLicenseCount = 0;
        Iterator<ValidityHelper.NrOfLicensesAndValidity> iterator = this.validityPeriods.iterator();
        while (iterator.hasNext()) {
            ValidityHelper.NrOfLicensesAndValidity nrOfLicensesAndValidity = iterator.next();
            if (nrOfLicensesAndValidity.expiryDate != -1L && nrOfLicensesAndValidity.expiryDate < systemTime) {
                iterator.remove();
                continue;
            }
            newLicenseCount = newLicenseCount == -1 || nrOfLicensesAndValidity.nrOfLicenses == -1L ? -1 : (int)((long)newLicenseCount + nrOfLicensesAndValidity.nrOfLicenses);
        }
        this.licenseCount = newLicenseCount;
    }
}

