/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.lic;

public class ByteArrayProcessor {
    private static int pc = 0;
    private static byte[] program = null;

    private ByteArrayProcessor() {
    }

    public static byte[] wickleAb(byte[] theProgram) {
        program = new byte[theProgram.length];
        System.arraycopy(theProgram, 0, program, 0, theProgram.length);
        pc = 0;
        block11: while (true) {
            switch (program[pc]) {
                case 3: {
                    return ByteArrayProcessor.gib_aus();
                }
                case 50: {
                    ByteArrayProcessor.gehe();
                    continue block11;
                }
                case 88: {
                    ByteArrayProcessor.loesche();
                    continue block11;
                }
                case 89: {
                    ByteArrayProcessor.addiere();
                    continue block11;
                }
                case 99: {
                    ByteArrayProcessor.multipliziere();
                    continue block11;
                }
                case 120: {
                    ByteArrayProcessor.vertausche();
                    continue block11;
                }
                case -101: {
                    ByteArrayProcessor.kopiere();
                    continue block11;
                }
                case -67: {
                    ByteArrayProcessor.verschiebe();
                    continue block11;
                }
                case -15: {
                    ByteArrayProcessor.drehe_um();
                    continue block11;
                }
            }
            break;
        }
        System.out.println("Illegal instruction!");
        System.out.print("--> Program = [ ");
        int count = 0;
        while (count < program.length) {
            System.out.print(program[count]);
            if (count < program.length - 1) {
                System.out.print(", ");
            }
            ++count;
        }
        System.out.println("]");
        System.out.println("--> PC = " + pc);
        return new byte[0];
    }

    private static byte[] gib_aus() {
        short offset = ByteArrayProcessor.bytesToShort(program[pc + 1], program[pc + 2]);
        short amount = ByteArrayProcessor.bytesToShort(program[pc + 3], program[pc + 4]);
        byte[] result = new byte[amount];
        System.arraycopy(program, pc + offset, result, 0, amount);
        return result;
    }

    private static void gehe() {
        short offset = ByteArrayProcessor.bytesToShort(program[pc + 1], program[pc + 2]);
        pc += offset;
    }

    private static void loesche() {
        short offset = ByteArrayProcessor.bytesToShort(program[pc + 1], program[pc + 2]);
        short amount = ByteArrayProcessor.bytesToShort(program[pc + 3], program[pc + 4]);
        byte[] buffer = new byte[program.length - amount];
        System.arraycopy(program, 0, buffer, 0, pc + offset);
        System.arraycopy(program, pc + offset + amount, buffer, pc + offset, program.length - (pc + offset + amount));
        program = buffer;
        pc = pc + 5 > pc + offset ? pc + 5 - Math.min(amount, pc + 5 - (pc + offset)) : (pc += 5);
    }

    private static void addiere() {
        short offset = ByteArrayProcessor.bytesToShort(program[pc + 1], program[pc + 2]);
        ByteArrayProcessor.program[ByteArrayProcessor.pc + offset] = (byte)(program[pc + offset] + program[pc + 3]);
        pc += 4;
    }

    private static void multipliziere() {
        short offset = ByteArrayProcessor.bytesToShort(program[pc + 1], program[pc + 2]);
        ByteArrayProcessor.program[ByteArrayProcessor.pc + offset] = (byte)(program[pc + offset] * program[pc + 3]);
        pc += 4;
    }

    private static void vertausche() {
        short offset1 = ByteArrayProcessor.bytesToShort(program[pc + 1], program[pc + 2]);
        short offset2 = ByteArrayProcessor.bytesToShort(program[pc + 3], program[pc + 4]);
        byte temp = program[pc + offset1];
        ByteArrayProcessor.program[ByteArrayProcessor.pc + offset1] = program[pc + offset2];
        ByteArrayProcessor.program[ByteArrayProcessor.pc + offset2] = temp;
        pc += 5;
    }

    private static void kopiere() {
        short offsetSource = ByteArrayProcessor.bytesToShort(program[pc + 1], program[pc + 2]);
        int amount = ByteArrayProcessor.bytesToShort(program[pc + 3], program[pc + 4]);
        short offsetSink = ByteArrayProcessor.bytesToShort(program[pc + 5], program[pc + 6]);
        int count = 0;
        while (count < amount) {
            ByteArrayProcessor.program[ByteArrayProcessor.pc + offsetSink + count] = program[pc + offsetSource + count];
            ++count;
        }
        pc += 7;
    }

    private static void verschiebe() {
        short offsetSource = ByteArrayProcessor.bytesToShort(program[pc + 1], program[pc + 2]);
        short amountSource = ByteArrayProcessor.bytesToShort(program[pc + 3], program[pc + 4]);
        short offsetTarget = ByteArrayProcessor.bytesToShort(program[pc + 5], program[pc + 6]);
        short offsetCounterBlock = (short)(offsetSource + amountSource);
        short amountCounterBlock = (short)(offsetTarget - offsetSource - amountSource);
        byte[] buffer = new byte[amountSource + amountCounterBlock];
        System.arraycopy(program, pc + offsetCounterBlock, buffer, 0, amountCounterBlock);
        System.arraycopy(program, pc + offsetSource, buffer, amountCounterBlock, amountSource);
        System.arraycopy(buffer, 0, program, pc + offsetSource, amountSource + amountCounterBlock);
        pc = pc + 7 > pc + offsetSource && pc + 7 < pc + offsetSource + amountSource ? (pc += 7 + amountCounterBlock) : (pc + 7 >= pc + offsetSource + amountSource && pc + 7 < pc + offsetTarget ? (pc += 7 - amountSource) : (pc += 7));
    }

    private static void drehe_um() {
        short offset1 = ByteArrayProcessor.bytesToShort(program[pc + 1], program[pc + 2]);
        short amount = ByteArrayProcessor.bytesToShort(program[pc + 3], program[pc + 4]);
        short offset2 = (short)(offset1 + amount - 1);
        int count = 0;
        while (count < amount / 2) {
            byte temp = program[pc + offset1 + count];
            ByteArrayProcessor.program[ByteArrayProcessor.pc + offset1 + count] = program[pc + offset2 - count];
            ByteArrayProcessor.program[ByteArrayProcessor.pc + offset2 - count] = temp;
            ++count;
        }
        pc += 5;
    }

    private static short bytesToShort(byte byte1, byte byte2) {
        int temp1 = byte1 >= 0 ? byte1 : byte1 + 256;
        int temp2 = byte2 >= 0 ? byte2 : byte2 + 256;
        return (short)(temp1 + 256 * temp2);
    }
}

