/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstantsWithoutAWT;
import javax.swing.text.StyledDocument;
import javax.swing.text.TextAction;

public class StyledEditorKitWithoutAWT
extends DefaultEditorKit {
    Element currentRun;
    Element currentParagraph;
    MutableAttributeSet inputAttributes;
    private AttributeTracker inputAttributeUpdater;
    private static final Action[] defaultActions = new Action[0];

    public StyledEditorKitWithoutAWT() {
        this.createInputAttributeUpdated();
        this.createInputAttributes();
    }

    @Override
    public MutableAttributeSet getInputAttributes() {
        return this.inputAttributes;
    }

    public Element getCharacterAttributeRun() {
        return this.currentRun;
    }

    @Override
    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    @Override
    public Document createDefaultDocument() {
        return new DefaultStyledDocument();
    }

    @Override
    public void install(JEditorPane c) {
        c.addCaretListener(this.inputAttributeUpdater);
        c.addPropertyChangeListener(this.inputAttributeUpdater);
        Caret caret = c.getCaret();
        if (caret != null) {
            this.inputAttributeUpdater.updateInputAttributes(caret.getDot(), caret.getMark(), c);
        }
    }

    @Override
    public void deinstall(JEditorPane c) {
        c.removeCaretListener(this.inputAttributeUpdater);
        c.removePropertyChangeListener(this.inputAttributeUpdater);
        this.currentRun = null;
        this.currentParagraph = null;
    }

    @Override
    public Object clone() {
        StyledEditorKitWithoutAWT o = (StyledEditorKitWithoutAWT)super.clone();
        o.currentParagraph = null;
        o.currentRun = null;
        o.createInputAttributeUpdated();
        o.createInputAttributes();
        return o;
    }

    private void createInputAttributes() {
        this.inputAttributes = new SimpleAttributeSet(){

            @Override
            public AttributeSet getResolveParent() {
                return StyledEditorKitWithoutAWT.this.currentParagraph != null ? StyledEditorKitWithoutAWT.this.currentParagraph.getAttributes() : null;
            }

            @Override
            public Object clone() {
                return new SimpleAttributeSet(this);
            }
        };
    }

    private void createInputAttributeUpdated() {
        this.inputAttributeUpdater = new AttributeTracker();
    }

    protected void createInputAttributes(Element element, MutableAttributeSet set) {
        set.removeAttributes(set);
        set.addAttributes(element.getAttributes());
        set.removeAttribute(StyleConstantsWithoutAWT.ComponentAttribute);
        set.removeAttribute(StyleConstantsWithoutAWT.IconAttribute);
        set.removeAttribute("$ename");
        set.removeAttribute(StyleConstantsWithoutAWT.ComposedTextAttribute);
    }

    class AttributeTracker
    implements CaretListener,
    PropertyChangeListener,
    Serializable {
        AttributeTracker() {
        }

        void updateInputAttributes(int dot, int mark, JTextComponent c) {
            Document aDoc = c.getDocument();
            if (!(aDoc instanceof StyledDocument)) {
                return;
            }
            int start = Math.min(dot, mark);
            StyledDocument doc = (StyledDocument)aDoc;
            StyledEditorKitWithoutAWT.this.currentParagraph = doc.getParagraphElement(start);
            Element run = StyledEditorKitWithoutAWT.this.currentParagraph.getStartOffset() == start || dot != mark ? doc.getCharacterElement(start) : doc.getCharacterElement(Math.max(start - 1, 0));
            if (run != StyledEditorKitWithoutAWT.this.currentRun) {
                StyledEditorKitWithoutAWT.this.currentRun = run;
                StyledEditorKitWithoutAWT.this.createInputAttributes(StyledEditorKitWithoutAWT.this.currentRun, StyledEditorKitWithoutAWT.this.getInputAttributes());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object newValue = evt.getNewValue();
            Object source = evt.getSource();
            if (source instanceof JTextComponent && newValue instanceof Document) {
                this.updateInputAttributes(0, 0, (JTextComponent)source);
            }
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.updateInputAttributes(e.getDot(), e.getMark(), (JTextComponent)e.getSource());
        }
    }
}

