/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.valueranges;

import com.arcway.lib.java.SetterSuccess;
import de.plans.lib.util.valueranges.ILong;
import de.plans.lib.util.valueranges.IValueRangeHelperText;
import de.plans.lib.util.valueranges.Messages;
import java.text.DecimalFormat;
import java.util.HashMap;

public class ValueRangeHelperDuration
implements IValueRangeHelperText {
    public static final int UNIT_HOURS = 1;
    public static final int UNIT_MINUTES = 2;
    public static final int UNIT_DAYS = 3;
    private int MS_PER_MINUTE = 60000;
    private int MINUTES_PER_HOUR = 60;
    private int HOURS_PER_DAY = 8;
    private static final String MINUTES_UNIT = "min";
    private static final String HOURS_UNIT = "h";
    private static final String DAYS_UNIT = "d";
    private static final String ERROR_MSG_NOINT_PARTI = Messages.getString("ValueRangeHelperDuration.ErrorMsg.NoInt.PartI");
    private static final String ERROR_MSG_NOINT_PARTII = Messages.getString("ValueRangeHelperDuration.ErrorMsg.NoInt.PartII");
    private static final String ERROR_MSG_NEGATIVE_PARTI = Messages.getString("ValueRangeHelperDuration.ErrorMsg.Negative.PartI");
    private static final String ERROR_MSG_NEGATIVE_PARTII = Messages.getString("ValueRangeHelperDuration.ErrorMsg.Negative.PartII");
    private static ThreadLocal tlDecimalFormatterMap = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    private int unit = 1;
    private final ILong persistentLocation;
    private boolean lastCheckWasSuccessful = true;
    private int error;

    public ValueRangeHelperDuration(ILong associatedPersistentLocation) {
        this.persistentLocation = associatedPersistentLocation;
    }

    public ValueRangeHelperDuration(int unit, ILong associatedPersistentLocation) {
        this.unit = unit;
        this.persistentLocation = associatedPersistentLocation;
    }

    private DecimalFormat getUnitSpecificFormatter() {
        DecimalFormat decimalFormatter;
        HashMap decimalFormatterMap = (HashMap)tlDecimalFormatterMap.get();
        if (this.unit == 3) {
            String FORMAT_SPECIFICATION = "0.##";
            decimalFormatter = (DecimalFormat)decimalFormatterMap.get("0.##");
            if (decimalFormatter == null) {
                decimalFormatter = new DecimalFormat("0.##");
                decimalFormatterMap.put("0.##", decimalFormatter);
            }
        } else {
            String FORMAT_SPECIFICATION = "0";
            decimalFormatter = (DecimalFormat)decimalFormatterMap.get("0");
            if (decimalFormatter == null) {
                decimalFormatter = new DecimalFormat("0");
                decimalFormatterMap.put("0", decimalFormatter);
            }
        }
        return decimalFormatter;
    }

    @Override
    public String getDisplayFormat() {
        DecimalFormat decimalFormatter = this.getUnitSpecificFormatter();
        long duration = this.persistentLocation.getValue();
        switch (this.unit) {
            case 3: {
                return decimalFormatter.format(duration / (long)(this.MS_PER_MINUTE * this.MINUTES_PER_HOUR * this.HOURS_PER_DAY));
            }
            case 1: {
                return decimalFormatter.format(duration / (long)(this.MS_PER_MINUTE * this.MINUTES_PER_HOUR));
            }
            case 2: {
                return decimalFormatter.format(duration / (long)this.MS_PER_MINUTE);
            }
        }
        return String.valueOf(0);
    }

    public String getDisplayFormatWithUnit() {
        DecimalFormat decimalFormatter = this.getUnitSpecificFormatter();
        long duration = this.persistentLocation.getValue();
        switch (this.unit) {
            case 3: {
                return String.valueOf(decimalFormatter.format(duration / (long)(this.MS_PER_MINUTE * this.MINUTES_PER_HOUR * this.HOURS_PER_DAY))) + " " + DAYS_UNIT;
            }
            case 1: {
                return String.valueOf(decimalFormatter.format(duration / (long)(this.MS_PER_MINUTE * this.MINUTES_PER_HOUR))) + " " + HOURS_UNIT;
            }
            case 2: {
                return String.valueOf(decimalFormatter.format(duration / (long)this.MS_PER_MINUTE)) + " " + MINUTES_UNIT;
            }
        }
        return String.valueOf(0);
    }

    public static String getDisplayFormatForUnit(int unit) {
        switch (unit) {
            case 3: {
                return DAYS_UNIT;
            }
            case 1: {
                return HOURS_UNIT;
            }
            case 2: {
                return MINUTES_UNIT;
            }
        }
        return null;
    }

    @Override
    public SetterSuccess setPersistentValue(String newValue) {
        assert (newValue != null) : "newValue must not be null";
        String valueWithoutUnit = newValue;
        if (this.unit == 1) {
            valueWithoutUnit = newValue.replaceAll(" h", "");
        }
        if (this.unit == 3) {
            valueWithoutUnit = newValue.replaceAll(" d", "");
        }
        if (this.unit == 2) {
            valueWithoutUnit = newValue.replaceAll(" min", "");
        }
        try {
            double duration = Double.parseDouble(valueWithoutUnit);
            if (duration < 0.0) {
                return SetterSuccess.NEW_VALUE_COULD_NOT_BE_APPLIED;
            }
            Long oldValue = this.persistentLocation.getValue();
            switch (this.unit) {
                case 3: {
                    this.persistentLocation.setValue(new Long((long)(duration * (double)this.HOURS_PER_DAY * (double)this.MINUTES_PER_HOUR * (double)this.MS_PER_MINUTE)));
                    break;
                }
                case 1: {
                    this.persistentLocation.setValue(new Long((long)(duration * (double)this.MINUTES_PER_HOUR * (double)this.MS_PER_MINUTE)));
                    break;
                }
                case 2: {
                    this.persistentLocation.setValue(new Long((long)(duration * (double)this.MS_PER_MINUTE)));
                    break;
                }
                default: {
                    return SetterSuccess.NEW_VALUE_COULD_NOT_BE_APPLIED;
                }
            }
            boolean valueChanged = oldValue == null && this.persistentLocation.getValue() != null || oldValue != null && !oldValue.equals(this.persistentLocation.getValue());
            return valueChanged ? SetterSuccess.VALUE_CHANGED : SetterSuccess.VALUE_DID_NOT_CHANGE;
        }
        catch (NumberFormatException e) {
            return SetterSuccess.NEW_VALUE_COULD_NOT_BE_APPLIED;
        }
    }

    public int getUnit() {
        return this.unit;
    }

    public void setUnit(int unit) {
        this.unit = unit;
    }

    public void setConversionFactors(int milliSecondsPerMinute, int minutesPerHour, int hoursPerDay) {
        if (milliSecondsPerMinute > 0) {
            this.MS_PER_MINUTE = milliSecondsPerMinute;
        }
        if (minutesPerHour > 0) {
            this.MINUTES_PER_HOUR = minutesPerHour;
        }
        if (hoursPerDay > 0) {
            this.HOURS_PER_DAY = hoursPerDay;
        }
    }

    public int getMillisecondsPerMinute() {
        return this.MS_PER_MINUTE;
    }

    public int getMinutesPerHour() {
        return this.MINUTES_PER_HOUR;
    }

    public int getHoursPerDay() {
        return this.HOURS_PER_DAY;
    }

    @Override
    public boolean check(String valueToCheck) {
        String valueWithoutUnit = valueToCheck;
        if (this.unit == 1) {
            valueWithoutUnit = valueToCheck.replaceAll(" h", "");
        }
        if (this.unit == 3) {
            valueWithoutUnit = valueToCheck.replaceAll(" d", "");
        }
        if (this.unit == 2) {
            valueWithoutUnit = valueToCheck.replaceAll(" min", "");
        }
        try {
            long duration = Long.parseLong(valueWithoutUnit);
            if (duration < 0L) {
                this.error = 2;
                this.lastCheckWasSuccessful = false;
            } else {
                this.error = 0;
                this.lastCheckWasSuccessful = true;
            }
        }
        catch (NumberFormatException e) {
            this.error = 1;
            this.lastCheckWasSuccessful = false;
        }
        return this.lastCheckWasSuccessful;
    }

    @Override
    public String getErrorMessage(String description) {
        if (!this.lastCheckWasSuccessful) {
            if (this.error == 1) {
                if (description != null) {
                    return String.valueOf(description) + ERROR_MSG_NOINT_PARTII;
                }
                return String.valueOf(ERROR_MSG_NOINT_PARTI) + ERROR_MSG_NOINT_PARTII;
            }
            if (this.error == 2) {
                if (description != null) {
                    return String.valueOf(description) + ERROR_MSG_NEGATIVE_PARTII;
                }
                return String.valueOf(ERROR_MSG_NEGATIVE_PARTI) + ERROR_MSG_NEGATIVE_PARTII;
            }
            assert (false) : "last check was not successful, but no error is set";
            return "";
        }
        return "";
    }

    public long getDurationAsValue() {
        if (this.unit == 2) {
            long duration = this.persistentLocation.getValue();
            return duration / (long)this.MS_PER_MINUTE;
        }
        if (this.unit == 1) {
            long duration = this.persistentLocation.getValue();
            return duration / (long)(this.MS_PER_MINUTE * this.MINUTES_PER_HOUR);
        }
        if (this.unit == 3) {
            long duration = this.persistentLocation.getValue();
            return duration / (long)(this.MS_PER_MINUTE * this.MINUTES_PER_HOUR * this.HOURS_PER_DAY);
        }
        assert (false) : "Unknown duration unit";
        return -1L;
    }

    public long getDurationInSpecificUnit(int unit_) {
        if (unit_ == 2) {
            long duration = this.persistentLocation.getValue();
            return duration / (long)this.MS_PER_MINUTE;
        }
        if (unit_ == 1) {
            long duration = this.persistentLocation.getValue();
            return duration / (long)(this.MS_PER_MINUTE * this.MINUTES_PER_HOUR);
        }
        if (unit_ == 3) {
            long duration = this.persistentLocation.getValue();
            return duration / (long)(this.MS_PER_MINUTE * this.MINUTES_PER_HOUR * this.HOURS_PER_DAY);
        }
        assert (false) : "Unknown duration unit";
        return -1L;
    }

    public void setDurationInSpecificUnit(int unit, long durationInGivenUnit) {
        if (unit == 2) {
            this.persistentLocation.setValue(new Long(durationInGivenUnit * (long)this.MS_PER_MINUTE));
        } else if (unit == 1) {
            this.persistentLocation.setValue(new Long(durationInGivenUnit * (long)this.MS_PER_MINUTE * (long)this.MINUTES_PER_HOUR));
        } else if (unit == 3) {
            this.persistentLocation.setValue(new Long(durationInGivenUnit * (long)this.MS_PER_MINUTE * (long)this.MINUTES_PER_HOUR * (long)this.HOURS_PER_DAY));
        } else assert (false) : "Unknown duration unit";
    }
}

